/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import com.videx.jirck.JIrCKSocketException;
import com.videx.misc.AbortFlag;
import cyberagentpc.AppRenderer;
import cyberagentpc.ConfigInfo;
import cyberagentpc.CyberAgentClient;
import cyberagentpc.CyberAgentPC;
import cyberagentpc.CyberAgentServer;
import cyberagentpc.InputCanceledException;
import cyberagentpc.InvalidKeyException;
import cyberagentpc.KeySessionHandler;
import cyberagentpc.KeyStatus;
import cyberagentpc.ProDeniedException;
import cyberagentpc.ServerProperties;
import cyberagentpc.ServiceException;
import cyberagentpc.UIHandler;
import cyberagentpc.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLHandshakeException;

public class WorkerThread
extends Thread {
    private CyberAgentPC capc;
    private UIHandler uiHandler;
    KeySessionHandler keySession;
    CyberAgentServer keyComm;
    CyberAgentClient webService;
    private KeyStatus KS;
    private boolean stop = false;
    private AbortFlag flag;
    private int wasDisabled;
    private String lastKey = "";
    private String currentKey = "";
    private String voltage = "";
    private String missionID = "";
    private long doneTime = 0L;
    private long currentTime = 0L;
    private boolean isMission = false;
    public static int productLevel;
    public static int configTSFromServer;
    public static byte[] configBytesFromServer;
    public ServerProperties serverProps;

    public WorkerThread(CyberAgentPC capc) {
        this.capc = capc;
        this.uiHandler = capc.getUIHandler();
        this.flag = new AbortFlag(false);
    }

    private ServerProperties initializeProperties() throws Exception {
        ServerProperties props;
        this.uiHandler.postOperation(AppRenderer.instance.render("message.connect"));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.wait"));
        try {
            props = this.webService.getServerProperties();
        }
        catch (Exception ex) {
            String[] errorAndStatus = this.handleException(ex);
            if (errorAndStatus[0] == null) {
                errorAndStatus[0] = ex.toString();
            }
            this.uiHandler.connectionError(errorAndStatus[0]);
            throw ex;
        }
        int myVer = Integer.parseInt(ResourceBundle.getBundle("cyberagentpc.buildNumber").getString("build.number"));
        if (myVer < props.cyberAgentPCVer && props.cyberAgentPCVer != 0 && System.getProperty("DEBUG") == null) {
            this.uiHandler.handleUpdateNotice(myVer, props.cyberAgentPCVer, props.cyberAgentPC_min_Ver);
        }
        this.uiHandler.postError("");
        return props;
    }

    private String[] handleException(Exception e2) {
        String postError = null;
        String postStatus = null;
        if (e2 instanceof JIrCKSocketException) {
            JIrCKSocketException j2 = (JIrCKSocketException)e2;
            postError = j2.errorCode == 10048 ? AppRenderer.instance.render("jirck.error.irmonitor") : (j2.errorCode == 10047 ? AppRenderer.instance.render("jirck.error.noport") : (j2.errorCode == 10050 ? AppRenderer.instance.render("jirck.error.noport") : (j2.errorCode == 10054 ? AppRenderer.instance.render("jirck.error.interrupted") : j2.toString())));
        } else if (e2 instanceof InvalidKeyException) {
            postError = AppRenderer.instance.render("key.error.invalid");
        } else if (e2 instanceof SSLHandshakeException) {
            SSLHandshakeException sslio = (SSLHandshakeException)e2;
            System.out.println("error: " + sslio);
            postError = AppRenderer.instance.render("comm.error.ssl");
        } else if (e2 instanceof IOException) {
            IOException ioe = (IOException)e2;
            postError = ioe.getMessage().equals("Connection refused: connect") ? AppRenderer.instance.render("comm.error.refused") : (ioe.getMessage().equals("No route to host: connect") ? AppRenderer.instance.render("comm.error.route") : "IO error: " + ioe.getMessage());
        } else if (e2 instanceof TimeoutException) {
            TimeoutException t = (TimeoutException)e2;
            postError = AppRenderer.instance.render("key.error.missing");
        } else if (e2 instanceof InterruptedException) {
            InterruptedException ie = (InterruptedException)e2;
            if (ie.getMessage().equals("timeout")) {
                postError = AppRenderer.instance.render("key.error.confirm");
            }
        } else if (e2 instanceof ServiceException) {
            ServiceException ex = (ServiceException)e2;
            if (ex.errorCode == ServiceException.ErrorCode.HIGH_SECURITY_BIT_SET) {
                postError = AppRenderer.instance.render("key.error.database");
            } else if (ex.errorCode == ServiceException.ErrorCode.GM_INFO_REQUIRED) {
                postError = AppRenderer.instance.render("master.error.config");
            } else if (ex.errorCode == ServiceException.ErrorCode.CATALOG_DOESNT_EXIST) {
                postError = AppRenderer.instance.render("comm.error.database");
            } else if (ex.errorCode == ServiceException.ErrorCode.KEY_ADDITION_DENIED) {
                if (this.serverProps.isLite() && this.wasDisabled == 1) {
                    if (this.KS.isGrandMaster()) {
                        postStatus = AppRenderer.instance.render("key.config.success");
                        postError = AppRenderer.instance.render("master.config.default");
                    } else {
                        postStatus = AppRenderer.instance.render("key.config.success");
                        postError = AppRenderer.instance.render("key.config.disabled");
                    }
                } else {
                    postError = AppRenderer.instance.render("key.config.fail");
                }
            } else {
                postError = ex.errorCode == ServiceException.ErrorCode.USER_NOT_LOGGED_IN ? AppRenderer.instance.render("key.error.login") : ex.toString();
            }
        } else if (e2 instanceof InputCanceledException) {
            if (e2.getMessage().equals("No Grandmaster issue")) {
                postStatus = AppRenderer.instance.render("master.remove");
                postError = AppRenderer.instance.render("master.error.add");
            }
        } else if (e2 instanceof ProDeniedException) {
            postError = AppRenderer.instance.render(e2.getMessage());
        } else {
            e2.printStackTrace();
            postError = e2.getMessage();
        }
        return new String[]{postError, postStatus};
    }

    public void run() {
        this.uiHandler.allowAbort(false);
        this.uiHandler.postStatus(AppRenderer.instance.render("message.irmonitor.stop"));
        this.capc.stopIRMonitor();
        while (!this.stop) {
            if (CyberAgentPC.serverURL != null) {
                block20: {
                    this.flag.abort = false;
                    this.isMission = false;
                    this.keySession = new KeySessionHandler(this.flag);
                    try {
                        this.webService = new CyberAgentClient(this.uiHandler);
                        if (this.serverProps == null) {
                            this.serverProps = this.initializeProperties();
                        }
                        this.uiHandler.postOperation(AppRenderer.instance.render("message.ready"));
                        this.uiHandler.postStatus(AppRenderer.instance.render("message.show.key"));
                        this.uiHandler.postError("");
                        this.uiHandler.postVoltage("");
                        this.currentKey = this.keySession.connectToKeyServer();
                        this.capc.showApp();
                        this.uiHandler.postOperation(AppRenderer.instance.render("message.key.found") + " " + this.currentKey);
                        this.uiHandler.postStatus("");
                        if (this.serverProps.productLevel == 2) {
                            throw new ProDeniedException("CyberAgentPC does not work with Professional");
                        }
                        this.currentTime = System.currentTimeMillis();
                        long diffTime = this.currentTime - this.doneTime;
                        if (this.currentKey.equals(this.lastKey) && diffTime < 5000L) {
                            this.uiHandler.postOperation(AppRenderer.instance.render("message.key.same") + " " + this.currentKey);
                            this.uiHandler.postStatus(AppRenderer.instance.render("message.key.remove"));
                            Thread.sleep(3000L);
                            this.lastKey = "";
                            continue;
                        }
                        this.uiHandler.allowAbort(true);
                        this.uiHandler.postError("");
                        this.processKey();
                    }
                    catch (Exception e2) {
                        if (e2 instanceof ServiceException) {
                            ServiceException ex = (ServiceException)e2;
                            if (ex.errorCode == ServiceException.ErrorCode.FW_UPDATE_NEEDED) {
                                try {
                                    this.upgradeStealthFirmware();
                                    continue;
                                }
                                catch (Exception execpt) {
                                    e2 = execpt;
                                }
                            }
                        }
                        if (this.stop) break block20;
                        String[] errorAndStatus = this.handleException(e2);
                        if (errorAndStatus[0] != null) {
                            this.uiHandler.postError(errorAndStatus[0]);
                        }
                        if (errorAndStatus[1] != null) {
                            this.uiHandler.postStatus(errorAndStatus[1]);
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.uiHandler.allowAbort(false);
            } else {
                this.uiHandler.postOperation(AppRenderer.instance.render("message.welcome"));
                this.uiHandler.postStatus(AppRenderer.instance.render("message.serverurl"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (this.keySession == null) continue;
            try {
                this.keySession.waitForAllKeysToLeave();
            }
            catch (Exception exception) {}
        }
    }

    public void processKey() throws Exception {
        block26: {
            block25: {
                this.keyComm = new CyberAgentServer(this.uiHandler);
                this.KS = this.keyComm.requestStatus(this.keySession);
                this.voltage = this.KS.getVoltage();
                this.uiHandler.postVoltage(AppRenderer.instance.render("status.battery.voltage") + " " + this.voltage);
                byte[] Status = this.KS.getRawData();
                short PID = this.KS.getPID();
                if (PID == 66) {
                    throw new InvalidKeyException();
                }
                this.lastKey = this.KS.getKeyID();
                this.wasDisabled = 0;
                this.syncKeyClock();
                String keySerial = this.KS.getKeyID();
                byte[] eventReqCmd = this.getEventRequest(this.webService, keySerial, this.KS.isProgrammer(), Status);
                this.uiHandler.postOperation(AppRenderer.instance.render("message.key.audit") + " " + this.currentKey);
                this.uiHandler.postStatus("");
                this.keySession.connectToKeyServer();
                byte[] events = this.keyComm.requestEvents(this.keySession, eventReqCmd);
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.events1") + " " + events.length + " " + AppRenderer.instance.render("message.key.events2"));
                int programmerCode = Integer.MIN_VALUE;
                boolean configNeeded = true;
                byte[] lockListBytes = null;
                if (this.KS.isProgrammer() || this.KS.isGrandMaster() || this.KS.isConfigureKey()) {
                    byte[] lockListRequestCommand = this.getLockListRequestCommand(keySerial, Status, this.KS.isProgrammer());
                    this.keySession.connectToKeyServer();
                    lockListBytes = this.keyComm.requestEvents(this.keySession, lockListRequestCommand);
                }
                while (configNeeded) {
                    if (this.KS.isProgrammer() || this.KS.isGrandMaster() && !this.serverProps.isLite() && programmerCode == Integer.MIN_VALUE) {
                        try {
                            programmerCode = this.getJobOrAdminNumber(false);
                        }
                        catch (InputCanceledException e2) {
                            if (this.KS.isProgrammer()) {
                                this.processInputCanceled(events, lockListBytes, this.currentKey);
                                return;
                            }
                            programmerCode = -1;
                        }
                    }
                    if (programmerCode != -1) {
                        this.uiHandler.postStatus(AppRenderer.instance.render("message.programmer.code") + programmerCode);
                    }
                    ConfigInfo extraInfo = new ConfigInfo();
                    byte[] keyConfig = null;
                    if (this.flag.abort) {
                        throw new InterruptedException("aborted");
                    }
                    try {
                        keyConfig = this.getKeyConfig(this.webService, events, lockListBytes, this.currentKey, Status, this.keyComm.expectedTime, programmerCode, extraInfo, this.KS.isProgrammer());
                    }
                    catch (InputCanceledException ice) {
                        if (ice.getMessage().equals("PROG_JOB_NOT_FOUND")) {
                            return;
                        }
                        if (this.wasDisabled != 0) break;
                        throw ice;
                    }
                    if (extraInfo.pinRequired()) {
                        try {
                            this.processPIN(extraInfo.getPINBytes());
                        }
                        catch (InputCanceledException ice) {
                            this.uiHandler.postStatus(AppRenderer.instance.render("message.key.pincancel"));
                            throw ice;
                        }
                    }
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.inconfig"));
                    this.keySession.connectToKeyServer();
                    events = this.keyComm.sendKeyConfig(this.keySession, keyConfig);
                    lockListBytes = null;
                    this.wasDisabled = extraInfo.getDisabledFlag();
                    if (this.wasDisabled != 0) continue;
                    configNeeded = false;
                }
                try {
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.confirm"));
                    if (this.isMission) {
                        this.webService.saveKeyEvents(events, null, this.missionID);
                    } else {
                        this.webService.saveKeyEvents(events, null, keySerial);
                    }
                }
                catch (ServiceException se) {
                    if (se.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST && this.wasDisabled != 0) break block25;
                    throw se;
                }
            }
            if ((this.KS.getSWV() & 0x7F) > 22 || this.KS.getPID() >= 106) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.verify"));
                long start = System.currentTimeMillis();
                Thread.sleep(2000L);
                do {
                    this.keySession.connectToKeyServer();
                    this.KS = this.keyComm.requestStatus(this.keySession);
                    byte[] configBytesFromStatus = this.KS.getFileConfigBytes();
                    if (Arrays.equals(configBytesFromStatus, configBytesFromServer)) break block26;
                    Thread.sleep(1000L);
                } while (System.currentTimeMillis() - start <= 15000L);
                throw new InterruptedException("timeout");
            }
        }
        this.uiHandler.postOperation(AppRenderer.instance.render("message.key.configured"));
        if (this.wasDisabled != 0) {
            if (this.KS.isGrandMaster()) {
                this.uiHandler.postStatus(AppRenderer.instance.render("master.config.default"));
            } else {
                this.uiHandler.postStatus(AppRenderer.instance.render("key.config.disabled"));
            }
        } else {
            this.uiHandler.postStatus(AppRenderer.instance.render("message.key.removenow"));
        }
    }

    private void upgradeStealthFirmware() throws Exception, ServiceException {
        int tries;
        short oldSWV = this.KS.getSWV();
        for (tries = 2; tries > 0; --tries) {
            byte[] FWBytes = this.webService.getStealthFirmware(this.currentKey);
            Thread.sleep(2000L);
            this.keySession.connectToKeyServer();
            this.keyComm.sendFirmwareUpdate(this.keySession, FWBytes);
            this.uiHandler.postOperation(AppRenderer.instance.render("message.recharge.update"));
            this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.updatewait"));
            Thread.sleep(12000L);
            if (this.verifyUpdate(oldSWV)) break;
        }
        if (tries == 0) {
            // empty if block
        }
    }

    private boolean verifyUpdate(int oldSWV) throws Exception {
        this.keySession.connectToKeyServer();
        this.KS = this.keyComm.requestStatus(this.keySession);
        return this.KS.getSWV() > oldSWV && this.KS.getSWV() == this.KS.getSWVFromConfigBytes();
    }

    private int getJobOrAdminNumber(boolean isInvalid) throws InputCanceledException {
        int jobOrAdminNumber = 0;
        int codeType = 0;
        codeType = this.KS.isProgrammer() ? 3 : 5;
        jobOrAdminNumber = Integer.parseInt(this.uiHandler.getUserInput(codeType, isInvalid));
        return jobOrAdminNumber;
    }

    private void processInputCanceled(byte[] events, byte[] locklist, String keyID) throws Exception {
        this.uiHandler.postOperation(AppRenderer.instance.render("message.key.confirmsend") + " " + this.currentKey);
        this.webService.saveKeyEvents(events, locklist, keyID);
        this.uiHandler.postOperation(AppRenderer.instance.render("message.key.done") + " " + keyID);
        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.removenow"));
        this.doneTime = System.currentTimeMillis();
    }

    private byte[] getEventRequest(CyberAgentClient webService, String keySerial, boolean isProgrammer, byte[] keyStatus) throws Exception, ServiceException {
        while (true) {
            try {
                if (this.isMission) {
                    return webService.getEventRequest(this.missionID, keyStatus);
                }
                return webService.getEventRequest(keySerial, keyStatus);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(webService);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(webService, keyStatus, keySerial, isProgrammer);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(webService, keySerial, keyStatus);
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getKeyClockCorrection() throws ServiceException, Exception {
        while (true) {
            try {
                if (this.isMission) {
                    return this.webService.getKeyClockCorrection(this.missionID, this.keyComm.expectedTime, this.KS.getRawData());
                }
                return this.webService.getKeyClockCorrection(this.KS.getKeyID(), this.keyComm.expectedTime, this.KS.getRawData());
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(this.webService);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(this.webService, this.KS.getRawData(), this.KS.getKeyID(), this.KS.isProgrammer());
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(this.webService, this.KS.getKeyID(), this.KS.getRawData());
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getLockListRequestCommand(String keySerial, byte[] keyStatus, boolean isProgrammer) throws Exception, ServiceException {
        while (true) {
            try {
                return this.webService.getLockListRequestCommand(keySerial);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(this.webService);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(this.webService, keyStatus, keySerial, isProgrammer);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(this.webService, keySerial, keyStatus);
                    Thread.sleep(500L);
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getKeyConfig(CyberAgentClient webService, byte[] events, byte[] lockListBytes, String currentKey, byte[] keyStatus, int expTime, int programmerCode, ConfigInfo extraInfo, boolean isProgrammer) throws Exception, ServiceException {
        Object b2 = null;
        int mismatchCount = 0;
        while (true) {
            try {
                if (this.isMission && !this.missionID.equals("M0")) {
                    this.uiHandler.postOperation(AppRenderer.instance.render("message.mission.process") + " " + currentKey);
                    return webService.getKeyConfig(events, lockListBytes, this.missionID, expTime, programmerCode, extraInfo);
                }
                this.uiHandler.postOperation(AppRenderer.instance.render("message.key.process") + " " + currentKey);
                return webService.getKeyConfig(events, lockListBytes, currentKey, expTime, programmerCode, extraInfo);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(webService);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(webService, keyStatus, currentKey, isProgrammer);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(webService, currentKey, keyStatus);
                    Thread.sleep(500L);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DATA_MISMATCH) {
                    if (++mismatchCount == 1) {
                        this.initializeKey(webService, currentKey, keyStatus);
                        Thread.sleep(500L);
                        continue;
                    }
                    throw ex;
                }
                if (ex.errorCode == ServiceException.ErrorCode.PROG_JOB_NOT_FOUND) {
                    try {
                        programmerCode = this.getJobOrAdminNumber(true);
                    }
                    catch (InputCanceledException ice) {
                        if (this.KS.isProgrammer()) {
                            this.processInputCanceled(events, lockListBytes, currentKey);
                            throw new InputCanceledException("PROG_JOB_NOT_FOUND");
                        }
                        programmerCode = -1;
                    }
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void issueCellnode(CyberAgentClient webService) throws Exception, ServiceException {
        while (true) {
            try {
                String numberStr = this.uiHandler.getUserInput(4, true);
                webService.issueCellNode(Integer.parseInt(numberStr));
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.UNKNOWN_ISSUE_NUMBER) continue;
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void issueKey(CyberAgentClient webService, byte[] keyStatus, String keySerial, boolean isProgrammer) throws Exception, ServiceException, InputCanceledException {
        boolean isInvalid = false;
        while (true) {
            try {
                String numberStr = "0";
                if (this.KS.isGrandMaster() && !this.serverProps.isLite()) {
                    throw new InputCanceledException("No Grandmaster issue");
                }
                if (!isProgrammer && !this.serverProps.isLite()) {
                    numberStr = this.uiHandler.getUserInput(1, isInvalid);
                }
                if (this.KS.isGrandMaster() && this.serverProps.isLite()) {
                    numberStr = "-1";
                }
                this.isMission = webService.issueKey(Integer.parseInt(numberStr), keyStatus, keySerial, null);
                if (this.isMission) {
                    this.missionID = "M" + numberStr;
                }
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.UNKNOWN_ISSUE_NUMBER) {
                    throw ex;
                }
                isInvalid = true;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void initializeKey(CyberAgentClient webService, String currentKey, byte[] status) throws Exception, ServiceException {
        while (true) {
            try {
                webService.initializeKey(currentKey, status, null);
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    throw ex;
                }
                this.issueCellnode(webService);
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getGMInfoCommand(CyberAgentClient webService, byte[] status, String currentKey) throws Exception, ServiceException {
        Object b2 = null;
        while (true) {
            try {
                return webService.getGMBytesRequestCommand(currentKey);
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    throw ex;
                }
                this.issueCellnode(webService);
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void processPIN(byte[] requiredPIN) throws Exception {
        boolean isInvalid = false;
        do {
            String pinStr;
            byte[] pin;
            if (Arrays.equals(pin = Util.stringPinToBytes(pinStr = this.uiHandler.getUserInput(2, isInvalid)), requiredPIN)) {
                return;
            }
            isInvalid = true;
        } while (!this.flag.abort);
        throw new Exception("aborted");
    }

    public void stopWorking() {
        this.stop = true;
        this.flag.abort = true;
    }

    public void signalReset() {
        this.flag.abort = true;
    }

    public void syncKeyClock() throws Exception {
        byte[] correctionFile = this.getKeyClockCorrection();
        while (correctionFile != null) {
            this.keySession.connectToKeyServer();
            this.KS = this.keyComm.sendClockCorrection(this.keySession, correctionFile);
            correctionFile = this.getKeyClockCorrection();
        }
    }
}

