/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import cyberagentpc.CyberAgentPC;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Util {
    public static final int beginTimeSecs = 820454400;
    static final int VIDEX_MAX_DATE_UTC = 2147385600;

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2 + 64);
        for (int k = 0; k < bytes.length; ++k) {
            if (bytes[k] <= 15) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(bytes[k] & 0xFF));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    public static void printHexBytes(byte[] b2) {
        int l = b2.length;
        if (l == 0) {
            System.out.println("no bytes to print!");
            return;
        }
        for (int k = 0; k < l; ++k) {
            if (k % 32 == 0 && k != 0) {
                System.out.print("\n");
            }
            Util.printHexByte(b2[k]);
            System.out.print(" ");
        }
        System.out.print("\n");
    }

    private static void printHexByte(byte b2) {
        String s = Integer.toHexString(b2 & 0xFF).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        System.out.print(s);
    }

    public static String makeKeyIDFromLong(long keyIDLong) {
        byte[] temp = Util.longToFourBEBytes(keyIDLong);
        return Util.makeKeyID(temp);
    }

    public static String makeStringID(String productID, byte[] kid) {
        String fourth;
        String third;
        String second;
        String ID = productID;
        String first = Integer.toHexString(kid[0] & 0xFF).toUpperCase();
        if (first.length() == 1) {
            first = "0" + first;
        }
        if ((second = Integer.toHexString(kid[1] & 0xFF).toUpperCase()).length() == 1) {
            second = "0" + second;
        }
        if ((third = Integer.toHexString(kid[2] & 0xFF).toUpperCase()).length() == 1) {
            third = "0" + third;
        }
        if ((fourth = Integer.toHexString(kid[3] & 0xFF).toUpperCase()).length() == 1) {
            fourth = "0" + fourth;
        }
        ID = ID + first + second + third + fourth;
        return ID;
    }

    public static String makeKeyID(byte[] kid) {
        String fourth;
        String third;
        String second;
        String ID = "K";
        String first = Integer.toHexString(kid[0] & 0xFF).toUpperCase();
        if (first.length() == 1) {
            first = "0" + first;
        }
        if ((second = Integer.toHexString(kid[1] & 0xFF).toUpperCase()).length() == 1) {
            second = "0" + second;
        }
        if ((third = Integer.toHexString(kid[2] & 0xFF).toUpperCase()).length() == 1) {
            third = "0" + third;
        }
        if ((fourth = Integer.toHexString(kid[3] & 0xFF).toUpperCase()).length() == 1) {
            fourth = "0" + fourth;
        }
        ID = ID + first + second + third + fourth;
        return ID;
    }

    public static byte[] longToFourBEBytes(long i2) {
        byte[] byteArray = new byte[]{0, 0, 0, 0};
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.putLong(i2);
        int j2 = 0;
        for (int k = 4; k < 8; ++k) {
            byteArray[j2++] = bbuf.get(k);
        }
        return byteArray;
    }

    public static long fourBEBytesToLong(byte[] b2) {
        byte[] bb = new byte[]{b2[3], b2[2], b2[1], b2[0], 0, 0, 0, 0};
        return Util.LEBytesToLong(bb);
    }

    public static long LEBytesToLong(byte[] b2) {
        if (b2.length != 8) {
            return 0L;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        return bbuf.getLong();
    }

    public static byte[] getKey() {
        String mac = CyberAgentPC.cellNodeID;
        return mac.getBytes();
    }

    public static long fourLEBytesToLong(byte[] b2) {
        byte[] bb = new byte[]{b2[0], b2[1], b2[2], b2[3], 0, 0, 0, 0};
        return Util.LEBytesToLong(bb);
    }

    public static int getVidexTime() {
        GregorianCalendar now = new GregorianCalendar();
        long tempSecs = now.getTimeInMillis() / 1000L;
        long videxSecs = tempSecs - 820454400L;
        if (videxSecs > 2147385600L) {
            return 2147385600;
        }
        return (int)videxSecs;
    }

    public static int secondsUTCFromUTCGC(GregorianCalendar G) {
        G.setTimeZone(TimeZone.getTimeZone("GMT"));
        long tempsecs = G.getTimeInMillis() / 1000L;
        long videxsecs = tempsecs - 820454400L;
        if (videxsecs > 2147385600L) {
            return 2147385600;
        }
        return (int)videxsecs;
    }

    public static int decodeOffset(int encodedOffset) {
        short calcOff = 0;
        if (encodedOffset == 0) {
            return 0;
        }
        calcOff = encodedOffset < 49 ? (short)(-(encodedOffset * 15)) : (short)((96 - encodedOffset) * 15);
        return calcOff;
    }

    public static byte[] stringPinToBytes(String pin) {
        ByteBuffer asciiBytes = Charset.forName("ASCII").encode(pin);
        try {
            return MessageDigest.getInstance("SHA-1").digest(asciiBytes.array());
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public static short ByteToShort(byte b2) {
        return Util.getUnsignedByte(b2);
    }

    public static short BEBytesToShort(byte[] b2) {
        if (b2.length != 2) {
            return 0;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        return bbuf.getShort();
    }

    public static int twoBEBytesToInt(byte[] b2) {
        byte[] bb = new byte[]{0, 0, b2[0], b2[1]};
        return Util.BEBytesToInt(bb);
    }

    public static int BEBytesToInt(byte[] b2) {
        if (b2.length != 4) {
            return 0;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        return bbuf.getInt();
    }

    public static short getUnsignedByte(byte _b) {
        return (short)(_b & 0xFF);
    }

    public static int getUnsignedShort(short _s) {
        return _s & 0xFFFF;
    }

    private static int mkBin(char ch) {
        if (ch == '0') {
            ch = '\u0000';
        }
        if (ch == '1') {
            ch = '\u0001';
        }
        if (ch == '2') {
            ch = (char)2;
        }
        if (ch == '3') {
            ch = (char)3;
        }
        if (ch == '4') {
            ch = (char)4;
        }
        if (ch == '5') {
            ch = (char)5;
        }
        if (ch == '6') {
            ch = (char)6;
        }
        if (ch == '7') {
            ch = (char)7;
        }
        if (ch == '8') {
            ch = (char)8;
        }
        if (ch == '9') {
            ch = (char)9;
        }
        if (ch == 'A' || ch == 'a') {
            ch = (char)10;
        }
        if (ch == 'B' || ch == 'b') {
            ch = (char)11;
        }
        if (ch == 'C' || ch == 'c') {
            ch = (char)12;
        }
        if (ch == 'D' || ch == 'd') {
            ch = (char)13;
        }
        if (ch == 'E' || ch == 'e') {
            ch = (char)14;
        }
        if (ch == 'F' || ch == 'f') {
            ch = (char)15;
        }
        return ch;
    }

    public static byte[] binaryToHexAscii(byte[] b2) {
        int i2 = 0;
        int count = b2.length;
        String s = null;
        byte[] retVal = new byte[count * 2];
        for (int k = 0; k < count; ++k) {
            s = Integer.toHexString(b2[k] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                s = "0" + s;
            }
            retVal[i2++] = (byte)s.charAt(0);
            retVal[i2++] = (byte)s.charAt(1);
        }
        return retVal;
    }

    public static byte[] hexAsciiToBinary(byte[] b2) {
        int i2 = 0;
        int count = b2.length;
        byte[] retVal = new byte[count / 2];
        for (int k = 0; k < count; k += 2) {
            char first = (char)b2[k];
            char second = (char)b2[k + 1];
            retVal[i2++] = (byte)((Util.mkBin(first) << 4) + Util.mkBin(second));
        }
        return retVal;
    }
}

