/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import cyberagentpc.AppRenderer;
import cyberagentpc.BaseDialog;
import cyberagentpc.CyberAgentPC;
import cyberagentpc.GrandmasterDialog;
import cyberagentpc.IRLinkIssueDialog;
import cyberagentpc.InputCanceledException;
import cyberagentpc.KeyIssueDialog;
import cyberagentpc.MainFrame;
import cyberagentpc.PinNumberDialog;
import cyberagentpc.ProgrammerDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class UIHandler {
    public static final int SERVER_URL = 0;
    public static final int KEY_ISSUE_NUMBER = 1;
    public static final int PIN_NUMBER = 2;
    public static final int PROGRAMMER_CODE = 3;
    public static final int CN_ISSUE_NUMBER = 4;
    public static final int GRANDMASTER_CODE = 5;
    public static final int KEYTYPE_USER = 1;
    public static final int KEYTYPE_PROGRAMMER = 2;
    public static final int KEYTYPE_GRANDMASTER = 3;
    private MainFrame frame;
    private int keyType;
    public static String InBox = "";

    public UIHandler(MainFrame frame) {
        this.frame = frame;
    }

    public void postOperation(String message) {
        this.frame.lblOperation.setText(message);
    }

    public void postStatus(String message) {
        this.frame.lblStatus.setText(message);
    }

    public void postError(String message) {
        this.frame.txtErrors.setText(message);
    }

    public void postVoltage(String voltage) {
        this.frame.lblVoltage.setText(voltage);
    }

    public void appendError(String message) {
        this.frame.txtErrors.setText(this.frame.txtErrors.getText() + '\n' + message);
    }

    public void allowAbort(boolean allowed) {
        this.frame.btnCancel.setVisible(allowed);
    }

    public String getUserInput(int mode, boolean isInvalid) throws InputCanceledException {
        BaseDialog dialog = null;
        switch (mode) {
            case 4: {
                dialog = new IRLinkIssueDialog();
                break;
            }
            case 1: {
                if (this.keyType == 3) {
                    dialog = new KeyIssueDialog(AppRenderer.instance.render("master.issue.title"));
                    break;
                }
                dialog = new KeyIssueDialog(AppRenderer.instance.render("key.issue.title"));
                break;
            }
            case 3: {
                dialog = new ProgrammerDialog();
                break;
            }
            case 2: {
                dialog = new PinNumberDialog();
                break;
            }
            case 5: {
                dialog = new GrandmasterDialog();
                break;
            }
        }
        String text = null;
        block24: while (true) {
            switch (mode) {
                case 4: {
                    int value;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("irlink.error.unkown"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c2 = text.charAt(0);
                            if (c2 == 'C' || c2 == 'c') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("irlink.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("irlink.error.format"));
                        }
                        continue block24;
                    }
                    throw new InputCanceledException();
                }
                case 1: {
                    int value;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        if (this.keyType == 3) {
                            if (isInvalid) {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.notfound"));
                            } else {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.unknown"));
                            }
                        } else if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.notfound"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.unknown"));
                        }
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c3 = text.charAt(0);
                            if (c3 == 'U' || c3 == 'u') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("key.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.format"));
                        }
                        continue block24;
                    }
                    throw new InputCanceledException();
                }
                case 3: {
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.error.notfound"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.job.prompt"));
                        }
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        try {
                            text = dialog.getInput();
                            int value = Integer.parseInt(text.trim());
                            text = Integer.toString(value);
                            if (text.length() != 8) {
                                dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                                continue block24;
                            }
                            return text;
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                            continue block24;
                        }
                    }
                    throw new InputCanceledException();
                }
                case 2: {
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pininvalid"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pinrequired"));
                        }
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            text = text.trim();
                            Integer.parseInt(text);
                            if (text.length() >= 4 && text.length() <= 8) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                        }
                        continue block24;
                    }
                    throw new InputCanceledException();
                }
                case 5: {
                    if (dialog.getPrompt().equals("")) {
                        if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("master.error.jobinvalid"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("master.job.prompt"));
                        }
                    }
                    boolean ok = dialog.showDialog(this.frame);
                    text = dialog.getInput();
                    if (ok && text.length() != 0 && !text.equals("")) {
                        try {
                            int value = Integer.parseInt(text.trim());
                            text = Integer.toString(value);
                            if (text.length() != 8) {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.format"));
                                continue block24;
                            }
                            return text;
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("master.error.format"));
                            continue block24;
                        }
                    }
                    throw new InputCanceledException();
                }
            }
        }
    }

    public void connectionError(String error) {
        String msg = AppRenderer.instance.render("connect.error.comm") + error;
        Object[] options = new Object[]{AppRenderer.instance.render("connect.title"), AppRenderer.instance.render("connect.retry"), AppRenderer.instance.render("connect.exit")};
        int n = JOptionPane.showOptionDialog(this.frame, msg, AppRenderer.instance.render("connect.error"), 1, 2, null, options, options[0]);
        if (n == 0) {
            this.frame.showSettingsModal();
        } else if (n == 2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((UIHandler)UIHandler.this).frame.capc.shutdown();
                }
            });
        }
    }

    public void handleUpdateNotice(int myVer, int serverVer, int minVer) {
        boolean isRequired = myVer < minVer;
        boolean isAvailable = myVer >= minVer && myVer < serverVer;
        String url = CyberAgentPC.serverURL.toString();
        url = url + (url.endsWith("/") ? "download/" : "/download/");
        String msg = null;
        String dispos = AppRenderer.instance.render("version.newer");
        if (isRequired) {
            msg = AppRenderer.instance.render("version.mismatch1") + " " + dispos + " " + AppRenderer.instance.render("version.mismatch2") + serverVer + AppRenderer.instance.render("version.mismatch3") + url;
            Object[] options = new Object[]{AppRenderer.instance.render("version.exit")};
            JOptionPane.showOptionDialog(this.frame, msg, AppRenderer.instance.render("version.required"), 0, 2, null, options, options[0]);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((UIHandler)UIHandler.this).frame.capc.shutdown();
                }
            });
        } else if (isAvailable) {
            msg = AppRenderer.instance.render("version.mismatch4") + " " + dispos + " " + AppRenderer.instance.render("version.mismatch2") + serverVer + AppRenderer.instance.render("version.mismatch5") + url + " " + AppRenderer.instance.render("version.mismatch6");
            Object[] options = new Object[]{AppRenderer.instance.render("version.yes"), AppRenderer.instance.render("button.cancel")};
            int result = JOptionPane.showOptionDialog(this.frame, msg, AppRenderer.instance.render("version.available"), 0, 2, null, options, options[0]);
            if (result == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((UIHandler)UIHandler.this).frame.capc.shutdown();
                    }
                });
            }
        }
    }
}

