/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import cyberagentpc.AppRenderer;
import cyberagentpc.Util;

public class KeyStatus {
    private byte[] rawData;
    private short PID;
    private short HWV;
    private short SWV;
    private byte[] keyIDBytes;
    private String keyID;
    private byte[] fileConfigBytes;
    private long currentKeySettingID;
    private boolean isGrandMaster;
    private boolean isProgrammer;
    private boolean isConfigureKey;
    private String voltage;
    private byte SWVFromConfig;

    public KeyStatus(byte[] status) {
        this.rawData = status;
        this.processStatus();
    }

    public String getKeyID() {
        return this.keyID;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public byte[] getFileConfigBytes() {
        return this.fileConfigBytes;
    }

    public long getCurrentKeySetting() {
        return this.currentKeySettingID;
    }

    public short getSWV() {
        return this.SWV;
    }

    public short getSWVFromConfigBytes() {
        return this.SWVFromConfig;
    }

    public short getPID() {
        return this.PID;
    }

    public String getVoltage() {
        return this.voltage;
    }

    public boolean isGrandMaster() {
        return this.isGrandMaster;
    }

    public boolean isProgrammer() {
        return this.isProgrammer;
    }

    public boolean isConfigureKey() {
        return this.isConfigureKey;
    }

    private void processStatus() {
        int k;
        byte[] packet1 = new byte[24];
        byte[] packet2 = new byte[25];
        byte[] packet3 = new byte[26];
        byte[] packet4 = new byte[14];
        for (k = 0; k < 24; ++k) {
            packet1[k] = this.rawData[k];
        }
        for (k = 24; k < 49; ++k) {
            packet2[k - 24] = this.rawData[k];
        }
        for (k = 49; k < 75; ++k) {
            packet3[k - 49] = this.rawData[k];
        }
        for (k = 75; k < 89; ++k) {
            packet4[k - 75] = this.rawData[k];
        }
        this.processPacketOne(packet1);
        this.processPacketTwo(packet2);
        this.processPacketThree(packet3);
    }

    private void processPacketOne(byte[] packet1) {
        Object temp = null;
        this.keyIDBytes = new byte[8];
        for (int k = 0; k < 8; ++k) {
            this.keyIDBytes[k] = packet1[k];
        }
        this.PID = Util.ByteToShort(packet1[0]);
        this.SWV = Util.ByteToShort(packet1[1]);
        this.HWV = Util.ByteToShort(packet1[2]);
        byte[] b2 = new byte[]{packet1[3], packet1[4], packet1[5], packet1[6]};
        this.keyID = Util.makeStringID("K", b2);
        byte[] hexAsciiBytes = new byte[16];
        for (int k = 8; k < 24; ++k) {
            hexAsciiBytes[k - 8] = packet1[k];
        }
        byte[] binaryBytes = Util.hexAsciiToBinary(hexAsciiBytes);
        byte[] encoderIDBytes = new byte[4];
        for (int k = 3; k < 7; ++k) {
            encoderIDBytes[k - 3] = binaryBytes[k];
        }
    }

    private void processPacketTwo(byte[] packet2) {
        this.fileConfigBytes = new byte[4];
        this.fileConfigBytes[0] = packet2[12];
        this.fileConfigBytes[1] = packet2[11];
        this.fileConfigBytes[2] = packet2[10];
        this.fileConfigBytes[3] = packet2[9];
        this.currentKeySettingID = Util.fourBEBytesToLong(this.fileConfigBytes);
        if (this.currentKeySettingID == 0xFFFFFFFFL) {
            this.currentKeySettingID = Util.getVidexTime();
        }
    }

    private void processPacketThree(byte[] packet3) {
        this.isProgrammer = ((packet3[15] & 8) > 0 || (this.SWV & 0x80) > 0) && this.PID != 106;
        this.isConfigureKey = (packet3[14] & 0xFF & 1) > 0 && (packet3[15] & 0xFF & 8) == 0;
        this.isGrandMaster = packet3[0] == 106;
        this.SWVFromConfig = packet3[1];
        this.calculateVoltage(packet3);
    }

    private void calculateVoltage(byte[] packet3) {
        double temp = 0.0;
        byte voltageByte = packet3[10];
        int stealthLowByte = packet3[24];
        if (voltageByte == 0) {
            this.voltage = "0.00";
        } else {
            temp = this.PID == 108 ? (double)(5000 * (voltageByte & 0xFF) / 255) : (double)((voltageByte & 0xF0) * 5000 / 512 + 1250);
            String s = new Double(temp).toString();
            this.voltage = s.substring(0, 1) + "." + s.substring(1, 3);
        }
        if (stealthLowByte < 0) {
            stealthLowByte = 256 + stealthLowByte;
        }
        double stealthLow = stealthLowByte * 5000 / 255;
        double regularLow = 5000.0 * ((double)(voltageByte & 0xF) / 32.0 + 0.25);
        Double d2 = new Double(regularLow);
        regularLow = d2.intValue();
        if (this.PID == 102 && temp <= regularLow || this.PID > 102 && this.PID < 108 && temp < regularLow || this.PID == 108 && temp < stealthLow) {
            this.voltage = this.voltage + AppRenderer.instance.render("message.low.battery");
        }
    }
}

