/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import com.videx.jirck.IrDACyberKeyComm;
import com.videx.misc.AbortFlag;
import cyberagentpc.Util;

public class KeySessionHandler {
    private String keySerial;
    private IrDACyberKeyComm IRKeyComm = new IrDACyberKeyComm();
    private AbortFlag flag;
    private int timeout;

    public KeySessionHandler(AbortFlag flag) {
        this.flag = flag;
        this.timeout = 0;
    }

    public String connectToKeyServer() throws Exception {
        long keyIDLong = this.IRKeyComm.connectToKeyServer(this.timeout, this.flag);
        String tempID = Util.makeKeyIDFromLong(keyIDLong);
        if (this.keySerial == null) {
            this.timeout = 10000;
            this.keySerial = tempID;
        } else if (!this.keySerial.equals(tempID)) {
            throw new Exception("different key in session, aborting.");
        }
        return this.keySerial;
    }

    public void connectToKeyClient() throws Exception {
        long keyIDLong = this.IRKeyComm.connectToKeyClient(10000, this.flag);
        String tempID = Util.makeKeyIDFromLong(keyIDLong);
        if (!this.keySerial.equals(tempID)) {
            throw new Exception("different key in session, aborting.");
        }
    }

    public void waitForAllKeysToLeave() throws Exception {
        this.timeout = 2000;
        while (!this.flag.abort) {
            this.connectToKeyServer();
            Thread.sleep(1000L);
        }
    }

    public void sendBytesToKey(byte[] bytes) throws Exception {
        this.IRKeyComm.sendFile(bytes);
    }

    public byte[] getBytesFromKey() throws Exception {
        byte[] b2 = this.IRKeyComm.receiveFile();
        return b2;
    }

    public String getKeySerial() {
        return this.keySerial;
    }
}

