/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import cyberagentpc.AppRenderer;
import cyberagentpc.KeySessionHandler;
import cyberagentpc.KeyStatus;
import cyberagentpc.UIHandler;
import cyberagentpc.Util;

public class CyberAgentServer {
    private UIHandler uiHandler;
    public int expectedTime;

    public CyberAgentServer(UIHandler uiHandler) {
        this.uiHandler = uiHandler;
        this.expectedTime = Integer.MIN_VALUE;
    }

    public KeyStatus requestStatus(KeySessionHandler sessionHandler) throws Exception {
        byte[] statusCommand = new byte[]{51, 1, 1, 0, 0, 46, 51, 46, 51, 1, -1, 51, 1, 46, -1, -1, -1, -1, -1, -1, 46, 51, 1, -1, 51, 1, 46, -1, 51, 1, 1, 0, 0, 46, 51, 46, 51, 1, -1, 51, 1, 46, -1, -1, 113, -86};
        int[] expected = new int[1];
        byte[] resp = this.doKeyTransaction(sessionHandler, statusCommand, AppRenderer.instance.render("message.key.status"), expected);
        this.expectedTime = expected[0];
        return new KeyStatus(resp);
    }

    private byte[] doKeyTransaction(KeySessionHandler sessionHandler, byte[] commandFile, String waitingForResponseMsg, int[] expectedTime) throws Exception {
        byte[] events = null;
        sessionHandler.sendBytesToKey(commandFile);
        this.uiHandler.postStatus(waitingForResponseMsg);
        sessionHandler.connectToKeyClient();
        expectedTime[0] = Util.getVidexTime();
        events = sessionHandler.getBytesFromKey();
        return events;
    }

    public byte[] requestEvents(KeySessionHandler sessionHandler, byte[] eventCmdBytes) throws Exception {
        int[] expected = new int[1];
        byte[] resp = this.doKeyTransaction(sessionHandler, eventCmdBytes, AppRenderer.instance.render("message.key.events"), expected);
        this.expectedTime = expected[0];
        return resp;
    }

    public byte[] sendKeyConfig(KeySessionHandler sessionHandler, byte[] keyConfigBytes) throws Exception {
        int[] expected = new int[1];
        byte[] resp = this.doKeyTransaction(sessionHandler, keyConfigBytes, AppRenderer.instance.render("message.key.inconfirm"), expected);
        this.expectedTime = expected[0];
        return resp;
    }

    public KeyStatus sendClockCorrection(KeySessionHandler sessionHandler, byte[] correctionCmd) throws Exception {
        int[] expected = new int[1];
        byte[] resp = this.doKeyTransaction(sessionHandler, correctionCmd, AppRenderer.instance.render("message.key.inconfirm"), expected);
        this.expectedTime = expected[0];
        return new KeyStatus(resp);
    }

    public void sendFirmwareUpdate(KeySessionHandler sessionHandler, byte[] newFirmware) throws Exception {
        int[] expected = new int[1];
        this.doKeyTransaction(sessionHandler, newFirmware, AppRenderer.instance.render("message.key.firmware"), expected);
    }
}

