/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import com.ccg.net.ethernet.EthernetAddress;
import cyberagentpc.AppRenderer;
import cyberagentpc.DesEncrypter;
import cyberagentpc.Listener;
import cyberagentpc.MainFrame;
import cyberagentpc.ProductIdentifier;
import cyberagentpc.UIHandler;
import cyberagentpc.Util;
import cyberagentpc.WorkerThread;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CyberAgentPC {
    boolean packFrame = false;
    private static WorkerThread wt;
    private Listener listener;
    private MainFrame frame;
    private UIHandler UIhandler;
    public String NO_MAC_ADDRESS;
    private static boolean IRShutdownSuccessful;
    public AppRenderer renderer;
    public static URL serverURL;
    public static String account;
    public static String cellNodeID;
    public static String proxyHost;
    public static int proxyPort;
    public static String proxyUserName;
    public static String proxyPassword;
    public static boolean useProductID;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                new CyberAgentPC();
            }
        });
    }

    public CyberAgentPC() {
        if (this.connectToListener()) {
            System.exit(0);
        }
        this.renderer = new AppRenderer();
        this.NO_MAC_ADDRESS = this.renderer.render("id.error.unknown");
        this.listener = new Listener();
        this.listener.start();
        this.getUniqueIdentifier();
        this.readSettings();
        this.setUpUserInterface();
        this.UIhandler = new UIHandler(this.frame);
        wt = new WorkerThread(this);
        this.frame.setWorkerThreadReference(wt);
        wt.start();
    }

    public static void connectionSettingsChanged() {
        if (wt != null) {
            CyberAgentPC.wt.serverProps = null;
            wt.signalReset();
        }
    }

    private boolean connectToListener() {
        try {
            Socket socket = new Socket((String)null, 17920);
            socket.close();
        }
        catch (UnknownHostException u) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public UIHandler getUIHandler() {
        return this.UIhandler;
    }

    public void showApp() {
        this.frame.setState(0);
        this.frame.setVisible(true);
    }

    public void normalizeApp() {
        this.frame.setState(0);
        this.frame.setVisible(true);
        this.frame.setAlwaysOnTop(false);
        this.frame.setEnabled(true);
    }

    public void shutdown() {
        wt.stopWorking();
        try {
            wt.join();
        }
        catch (InterruptedException ie) {
            System.out.println("join for WorkerThread failed" + ie);
        }
        if (IRShutdownSuccessful) {
            this.restoreIRMonitor();
        }
        this.writeSettings();
        this.listener.stopListener();
        if (this.connectToListener()) {
            try {
                this.listener.join();
            }
            catch (InterruptedException e2) {
                System.out.println("join for Listener failed" + e2);
            }
        }
        System.out.println("shutting down...");
        System.exit(0);
    }

    public void stopIRMonitor() {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec("net stop \"infrared monitor\"");
            p.waitFor();
            int i2 = p.exitValue();
            IRShutdownSuccessful = i2 == 0;
        }
        catch (InterruptedException ie) {
            System.out.println("failed to stop IRMonitor: " + ie);
        }
        catch (IOException ioe) {
            System.out.println("failed to stop IRMonitor: " + ioe);
        }
    }

    public void restoreIRMonitor() {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec("net start \"infrared monitor\"");
            p.waitFor();
        }
        catch (InterruptedException ie) {
            System.out.println("failed to start IRMonitor: " + ie);
        }
        catch (IOException ioe) {
            System.out.println("failed to start IRMonitor: " + ioe);
        }
    }

    private void getUniqueIdentifier() {
        if (useProductID) {
            this.determineProductID();
        } else {
            this.determineMachineID();
            if (cellNodeID.equals("00-53-45-00-00-00")) {
                int answer = JOptionPane.showConfirmDialog(null, this.renderer.render("id.request.generate"), this.renderer.render("id.request.warn"), 0, 3);
                switch (answer) {
                    case 1: {
                        System.exit(0);
                        break;
                    }
                    case 0: {
                        useProductID = true;
                        this.getUniqueIdentifier();
                        break;
                    }
                    default: {
                        System.exit(0);
                    }
                }
            }
        }
    }

    private void determineMachineID() {
        cellNodeID = this.getMachineID();
        boolean tryagain = true;
        block7: while (tryagain) {
            if (cellNodeID == null || cellNodeID.equals(this.NO_MAC_ADDRESS)) {
                int answer = JOptionPane.showConfirmDialog(null, this.renderer.render("id.request.nic"), this.renderer.render("id.request.warn"), 1, 3);
                switch (answer) {
                    case 2: {
                        tryagain = false;
                        System.exit(0);
                        continue block7;
                    }
                    case 0: {
                        cellNodeID = this.getMachineID();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block7;
                    }
                    case 1: {
                        useProductID = true;
                        this.getUniqueIdentifier();
                        continue block7;
                    }
                }
                tryagain = false;
                System.exit(0);
                continue;
            }
            tryagain = false;
        }
    }

    private String getMachineID() {
        int nonZeroIdx;
        EthernetAddress E = null;
        try {
            E = EthernetAddress.getPrimaryAdapter();
            if (E == null) {
                System.out.println("error: Unable to determine Ethernet Address.");
                return this.NO_MAC_ADDRESS;
            }
        }
        catch (UnsatisfiedLinkError ule) {
            System.out.println("error: " + ule);
            return this.NO_MAC_ADDRESS;
        }
        String idStr = Util.bytesToHexString(E.getBytes());
        for (nonZeroIdx = 0; nonZeroIdx < idStr.length() && idStr.charAt(nonZeroIdx) == '0'; ++nonZeroIdx) {
        }
        if (nonZeroIdx > 0) {
            idStr = idStr.substring(nonZeroIdx);
        }
        if (idStr.length() > 0) {
            return idStr;
        }
        return null;
    }

    private void determineProductID() {
        ProductIdentifier PID = new ProductIdentifier();
        String pid = PID.getProductIdentifier();
        if (pid.equals("key handle") || pid.equals("PID")) {
            int answer = JOptionPane.showConfirmDialog(null, this.renderer.render("id.request.registry"), this.renderer.render("id.request.warn"), 0, 3);
            switch (answer) {
                case 1: {
                    System.exit(0);
                    break;
                }
                case 0: {
                    this.getUniqueIdentifier();
                    break;
                }
                default: {
                    System.exit(0);
                    break;
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(pid);
            String user = System.getProperty("user.name");
            sb.append(user);
            byte[] b2 = Util.stringPinToBytes(sb.toString());
            StringBuilder temp = new StringBuilder();
            for (int k = 9; k < 15; ++k) {
                temp.append(Integer.toHexString(b2[k] & 0xFF).toUpperCase());
            }
            cellNodeID = temp.toString();
        }
    }

    private void initDefaultSettings() {
        serverURL = null;
        account = null;
        proxyHost = null;
        proxyPort = 0;
        proxyUserName = null;
        proxyPassword = null;
    }

    private void readSettings() {
        this.initDefaultSettings();
        String fileName = "CyberAgentPC.properties";
        if (new File(fileName).exists()) {
            try {
                FileInputStream in = new FileInputStream(fileName);
                Properties settings = new Properties();
                settings.load(in);
                in.close();
                String tmp = settings.getProperty("server.url");
                if (tmp != null && tmp.length() > 0) {
                    try {
                        serverURL = new URL(tmp.trim());
                    }
                    catch (MalformedURLException mex) {
                        // empty catch block
                    }
                }
                if ((tmp = settings.getProperty("server.account")) != null) {
                    if ((tmp = tmp.trim()).length() > 0) {
                        account = tmp;
                    }
                } else {
                    account = null;
                }
                if ((tmp = settings.getProperty("proxy.host")) != null && tmp.length() > 0) {
                    proxyHost = tmp.trim();
                }
                if ((tmp = settings.getProperty("proxy.port")) != null && tmp.length() > 0) {
                    proxyPort = Integer.parseInt(tmp.trim());
                }
                if ((tmp = settings.getProperty("proxy.username")) != null && tmp.length() > 0) {
                    proxyUserName = tmp.trim();
                }
                if ((tmp = settings.getProperty("proxy.password")) != null && tmp.length() > 0) {
                    proxyPassword = CyberAgentPC.deMystify(tmp.trim());
                }
                useProductID = (tmp = settings.getProperty("product.id")) != null && tmp.length() > 0;
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    public static String Mystify(String s) {
        byte[] key = Util.getKey();
        DesEncrypter encrypter = new DesEncrypter(new String(key));
        return encrypter.encrypt(s);
    }

    public static String deMystify(String s) {
        byte[] key = Util.getKey();
        DesEncrypter encrypter = new DesEncrypter(new String(key));
        return encrypter.decrypt(s);
    }

    public void writeSettings() {
        Properties settings = new Properties();
        if (serverURL != null && serverURL.toString().length() > 0) {
            settings.put("server.url", serverURL.toString());
        }
        if (account != null) {
            settings.put("server.account", account);
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            settings.put("proxy.host", proxyHost);
        }
        if (proxyPort != 0) {
            settings.put("proxy.port", Integer.toString(proxyPort));
        }
        if (proxyUserName != null && proxyUserName.length() > 0) {
            settings.put("proxy.username", proxyUserName);
        }
        if (proxyPassword != null && proxyPassword.length() > 0) {
            settings.put("proxy.password", CyberAgentPC.Mystify(proxyPassword));
        }
        if (useProductID) {
            settings.put("product.id", "true");
        }
        try {
            FileOutputStream out = new FileOutputStream("CyberAgentPC.properties");
            settings.store(out, "CyberAgentPC Properties");
            out.close();
        }
        catch (IOException e2) {
            System.err.println(e2);
        }
    }

    private void setUpUserInterface() {
        this.frame = new MainFrame(this);
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setVisible(true);
    }

    static {
        System.loadLibrary("MachineID");
        System.loadLibrary("ProductID");
        System.loadLibrary("jirck");
    }
}

