/*
 * Decompiled with CFR 0.152.
 */
package cyberagentpc;

import cyberagentpc.AppRenderer;
import cyberagentpc.ConfigInfo;
import cyberagentpc.CyberAgentPC;
import cyberagentpc.EasySSLProtocolSocketFactory;
import cyberagentpc.ServerProperties;
import cyberagentpc.ServiceException;
import cyberagentpc.UIHandler;
import cyberagentpc.Util;
import cyberagentpc.WorkerThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.StringReader;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyberAgentClient {
    private UIHandler uiHandler;
    private String cellNodeID;
    private String catalog;
    private String serverAddress;
    private HttpClient client;
    private boolean isSSL;

    public CyberAgentClient(UIHandler uiHandler) {
        this.uiHandler = uiHandler;
        this.cellNodeID = CyberAgentPC.cellNodeID;
        this.catalog = CyberAgentPC.account;
        try {
            String secProviderName = "com.sun.crypto.provider.SunJCE";
            Provider secProvider = (Provider)Class.forName(secProviderName).newInstance();
            Security.addProvider(secProvider);
        }
        catch (Exception e2) {
            uiHandler.postError("error in security protocol: " + e2);
        }
        this.serverAddress = this.getServerAddress();
        if (this.isSSL) {
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol("https", easyhttps);
            this.client = new HttpClient();
        } else {
            this.client = new HttpClient();
        }
        if (this.isProxyRequired()) {
            HostConfiguration HConf = this.client.getHostConfiguration();
            HConf.setProxy(CyberAgentPC.proxyHost, CyberAgentPC.proxyPort);
            if (this.isCertRequired()) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(CyberAgentPC.proxyUserName, CyberAgentPC.proxyPassword);
                this.client.getState().setCredentials(new AuthScope(CyberAgentPC.proxyHost, CyberAgentPC.proxyPort, AuthScope.ANY_REALM), defaultcreds);
                this.client.getState().setProxyCredentials(new AuthScope(CyberAgentPC.proxyHost, CyberAgentPC.proxyPort, AuthScope.ANY_REALM), defaultcreds);
                this.client.getParams().setAuthenticationPreemptive(true);
            }
        }
    }

    private void setUserAgentHeader(PostMethod method) {
        method.addRequestHeader(new Header("User-Agent", "cntype=0"));
    }

    private List<Part> getCommonReqParts() {
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(new StringPart("cellNodeID", this.cellNodeID));
        if (this.catalog != null) {
            parts.add(new StringPart("catalog", this.catalog));
        }
        return parts;
    }

    private List<NameValuePair> getCommonReqParams() {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        pairs.add(new NameValuePair("cellNodeID", this.cellNodeID));
        if (this.catalog != null) {
            pairs.add(new NameValuePair("catalog", this.catalog));
        }
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean issueKey(int issueNumber, byte[] status, String keySerial, byte[] GMInfo) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "issueKey.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        if (issueNumber != -1) {
            parts.add(new StringPart("issueNumber", Integer.toString(issueNumber)));
        }
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        if (GMInfo != null) {
            parts.add(new FilePart("GMInfo", new ByteArrayPartSource("GMInfo", GMInfo)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                boolean bl = false;
                return bl;
            }
            boolean bl = method.getResponseBodyAsString().equals("1");
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueCellNode(int issueNumber) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "issue.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("issueNumber", Integer.toString(issueNumber)));
        params.add(new NameValuePair("type", "0"));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] initializeKey(String keySerial, byte[] status, byte[] GMInfo) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "initializeKey.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        if (GMInfo != null) {
            parts.add(new FilePart("GMInfo", new ByteArrayPartSource("GMInfo", GMInfo)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEventRequest(String keySerial, byte[] status) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getEventRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStealthFirmware(String keySerial) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getStealthFirmware.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("keySerial", keySerial));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        this.uiHandler.postOperation(AppRenderer.instance.render("message.recharge.update"));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.getfirmware"));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                System.out.println("error-> " + method.getStatusCode());
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getKeyClockCorrection(String keySerial, int expTime, byte[] status) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getKeyClockCorrection.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new StringPart("expectedTime", Integer.toString(expTime)));
        parts.add(new StringPart("requestTime", Integer.toString(Util.getVidexTime())));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] bytes = method.getResponseBody();
            if (bytes.length > 0) {
                byte[] byArray = bytes;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGMBytesRequestCommand(String keySerial) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getGMBytesRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("keySerial", keySerial));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.master.config"));
        try {
            byte[] incoming;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = incoming = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLockListRequestCommand(String keySerial) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getLockListBytesRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("keySerial", keySerial));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.locklist"));
        try {
            byte[] incoming;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = incoming = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProperties getServerProperties() throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getServerProperties.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<NameValuePair> params = this.getCommonReqParams();
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        try {
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                ServerProperties serverProperties = null;
                return serverProperties;
            }
            Properties props = new Properties();
            props.load(new BufferedInputStream(method.getResponseBodyAsStream(), 1024));
            ServerProperties sp = new ServerProperties();
            String tmp = props.getProperty("productLevel");
            if (tmp == null) {
                tmp = props.getProperty("propertylevel");
            }
            sp.productLevel = Integer.parseInt(tmp);
            tmp = props.getProperty("cyberAgentPC_min_Ver");
            sp.cyberAgentPCVer = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("cyberAgentPCVer");
            sp.cyberAgentPC_min_Ver = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.cyberAgentPCPath = props.getProperty("cyberAgentPCPath");
            ServerProperties serverProperties = sp;
            return serverProperties;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getKeyConfig(byte[] eventData, byte[] lockListData, String keySerial, int expTime, int progCode, ConfigInfo extraInfo) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "getKeyConfig.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("expectedTime", Integer.toString(expTime)));
        parts.add(new StringPart("requestTime", Integer.toString(Util.getVidexTime())));
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new StringPart("extra", "1"));
        if (progCode > 0) {
            parts.add(new StringPart("programmerCode", Integer.toString(progCode)));
        }
        parts.add(new FilePart("eventData", new ByteArrayPartSource("eventData", eventData)));
        if (lockListData != null) {
            parts.add(new FilePart("lockListData", new ByteArrayPartSource("lockListData", lockListData)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.config"));
        try {
            byte[] trimmedMessage;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] incoming = method.getResponseBody();
            extraInfo.extractExtraInfo(incoming);
            WorkerThread.configTSFromServer = extraInfo.configID();
            WorkerThread.configBytesFromServer = extraInfo.getConfigIDBytes();
            byte[] byArray = trimmedMessage = extraInfo.extractMessage(incoming);
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] saveKeyEvents(byte[] eventData, byte[] lockListData, String keySerial) throws Exception, ServiceException {
        PostMethod method = new PostMethod(this.serverAddress + "saveKeyEvents.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("eventData", new ByteArrayPartSource("eventData", eventData)));
        if (lockListData != null) {
            parts.add(new FilePart("lockListData", new ByteArrayPartSource("lockListData", lockListData)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    private void throwError(HttpMethod method) throws Exception, ServiceException {
        if (method.getStatusCode() == 555) {
            String txt = method.getResponseBodyAsString();
            BufferedReader reader = new BufferedReader(new StringReader(txt));
            String line = reader.readLine();
            if (line != null && line.equals("ERROR") && (line = reader.readLine()) != null) {
                try {
                    int code = Integer.parseInt(line);
                    for (ServiceException.ErrorCode ec : EnumSet.allOf(ServiceException.ErrorCode.class)) {
                        if (ec.ordinal() != code) continue;
                        throw new ServiceException(ec);
                    }
                    throw new Exception("Unrecognized web service exception: #" + code);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            throw new Exception("Unrecognized web service exception response: " + txt);
        }
        if (method.getStatusCode() != 299) {
            throw new Exception(method.getStatusLine().toString());
        }
    }

    private boolean isProxyRequired() {
        return CyberAgentPC.proxyHost != null && CyberAgentPC.proxyPort != 0;
    }

    private boolean isCertRequired() {
        return CyberAgentPC.proxyUserName != null && CyberAgentPC.proxyPassword != null;
    }

    private String getServerAddress() {
        String protocol = CyberAgentPC.serverURL.getProtocol();
        this.isSSL = protocol.equals("https");
        String url = CyberAgentPC.serverURL.toString();
        if (!url.endsWith("/")) {
            return url + "/services/cellnode/";
        }
        return url + "services/cellnode/";
    }
}

