/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CustomItemPainter
implements ItemPainter,
ItemPaintSite,
CustomPaintSite,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter painter;
    protected transient ItemPaintSite paintSite;
    protected Color background;
    protected Color foreground;
    protected Font font;
    protected int alignment;
    protected Insets margins;

    public CustomItemPainter() {
    }

    public CustomItemPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public void setPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public Dimension getPreferredSize(Object data, Graphics graphics, int state, ItemPaintSite site) {
        this.paintSite = site;
        return this.painter != null ? this.painter.getPreferredSize(data, graphics, state, this) : null;
    }

    public void paint(Object data, Graphics graphics, Rectangle rect, int state, ItemPaintSite site) {
        this.paintSite = site;
        if (this.painter != null) {
            this.painter.paint(data, graphics, rect, state, this);
        }
    }

    public void reset() {
        this.background = null;
        this.foreground = null;
        this.font = null;
        this.alignment = 0;
        this.margins = null;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return this.paintSite != null ? this.paintSite.getBackground() : null;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.paintSite != null ? this.paintSite.getForeground() : null;
    }

    public boolean isTransparent() {
        return this.paintSite != null ? this.paintSite.isTransparent() : false;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return this.paintSite != null ? this.paintSite.getFont() : null;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        if (this.alignment != 0) {
            return this.alignment;
        }
        return this.paintSite != null ? this.paintSite.getAlignment() : 0;
    }

    public void setItemMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getItemMargins() {
        if (this.margins != null) {
            return this.margins;
        }
        return this.paintSite != null ? this.paintSite.getItemMargins() : null;
    }

    public Component getSiteComponent() {
        return this.paintSite != null ? this.paintSite.getSiteComponent() : null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

