/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jbcl.editors.Res;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class String2DArrayEditorPanel
extends JComponent
implements ActionListener,
ListSelectionListener {
    JTable grid = new JTable();
    JScrollPane gridPane = new JScrollPane();
    JPanel butPan = new JPanel();
    JPanel rowPan = new JPanel();
    JPanel colPan = new JPanel();
    JButton addRow = new JButton();
    JButton remRow = new JButton();
    JButton addCol = new JButton();
    JButton remCol = new JButton();
    JButton clear = new JButton();
    JLabel label = new JLabel();

    public String2DArrayEditorPanel() {
        JPanel panel = new JPanel();
        panel.add(this.butPan);
        this.butPan.setLayout(new GridLayout(0, 1, 10, 10));
        this.butPan.add(this.addRow);
        this.butPan.add(this.remRow);
        this.butPan.add(this.clear);
        this.butPan.add(this.addCol);
        this.butPan.add(this.remCol);
        this.butPan.add(this.rowPan);
        this.butPan.add(this.colPan);
        this.setLayout(new BorderLayout(10, 10));
        this.gridPane.getViewport().add((Component)this.grid, null);
        this.add((Component)this.gridPane, "Center");
        this.add((Component)panel, "East");
        this.add((Component)this.label, "North");
        this.addRow.setText(Res._AddRow);
        this.addRow.addActionListener(this);
        this.remRow.setText(Res._RemoveRow);
        this.remRow.addActionListener(this);
        this.clear.setText(Res._Clear);
        this.clear.addActionListener(this);
        this.addCol.setText(Res._AddColumn);
        this.addCol.addActionListener(this);
        this.remCol.setText(Res._RemoveColumn);
        this.remCol.addActionListener(this);
        this.label.setText(Res._GridDirections);
        this.grid.setAutoCreateColumnsFromModel(false);
        this.grid.setAutoResizeMode(0);
        this.grid.getSelectionModel().addListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent e2) {
        int cols;
        Object src = e2.getSource();
        if (this.grid.isEditing()) {
            TableCellEditor editor = this.grid.getCellEditor();
            editor.stopCellEditing();
        }
        int row = this.grid.getSelectedRow();
        int column = this.grid.getSelectedColumn();
        if (src == this.addRow) {
            ((DefaultTableModel)this.grid.getModel()).addRow(new String[this.grid.getColumnCount()]);
        } else if (src == this.remRow && row >= 0) {
            int rows = this.grid.getRowCount();
            if (rows > 1) {
                ((DefaultTableModel)this.grid.getModel()).removeRow(row);
                if (row == rows - 1) {
                    --row;
                }
                this.grid.getSelectionModel().setSelectionInterval(row, row);
            }
        } else if (src == this.clear) {
            ((DefaultTableModel)this.grid.getModel()).setNumRows(1);
            this.grid.setColumnModel(new DefaultTableColumnModel());
            TableColumn tableColumn = new TableColumn();
            tableColumn.setModelIndex(0);
            tableColumn.setPreferredWidth(75);
            tableColumn.setHeaderValue("");
            this.grid.addColumn(tableColumn);
            this.grid.getSelectionModel().setSelectionInterval(row - 1, row - 1);
        } else if (src == this.addCol) {
            int count = this.grid.getModel().getColumnCount();
            ((DefaultTableModel)this.grid.getModel()).addColumn(String.valueOf(String.valueOf(new StringBuffer("column").append(count + 1))));
            TableColumn tableColumn = new TableColumn();
            tableColumn.setModelIndex(count);
            tableColumn.setPreferredWidth(75);
            tableColumn.setHeaderValue("");
            this.grid.addColumn(tableColumn);
        } else if (src == this.remCol && column >= 0 && (cols = this.grid.getColumnCount()) > 1) {
            this.grid.removeColumn(this.grid.getColumnModel().getColumn(column));
            if (column == cols - 1) {
                --column;
            }
            this.grid.setColumnSelectionInterval(column, column);
        }
    }

    public void setItems(String[][] items) {
        int rowCount = 1;
        int colCount = 1;
        if (items != null && items.length > 0) {
            rowCount = items.length;
            if (items[0] != null && items[0].length > 0) {
                colCount = items[0].length;
            }
        }
        Object[] columns = new String[colCount];
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        this.grid.setColumnModel(columnModel);
        for (int i2 = 0; i2 < colCount; ++i2) {
            columns[i2] = String.valueOf(String.valueOf(new StringBuffer("column").append(i2 + 1)));
            TableColumn column = new TableColumn();
            column.setModelIndex(i2);
            column.setHeaderValue("");
            column.setPreferredWidth(75);
            columnModel.addColumn(column);
        }
        this.grid.setModel(new DefaultTableModel(items, columns));
    }

    public String[][] getItems() {
        TableModel model = this.grid.getModel();
        int rowCount = model.getRowCount();
        TableColumnModel columnModel = this.grid.getColumnModel();
        int colCount = columnModel.getColumnCount();
        String[][] items = new String[rowCount][colCount];
        for (int col = 0; col < colCount; ++col) {
            TableColumn tableColumn = columnModel.getColumn(col);
            int dataCol = tableColumn.getModelIndex();
            for (int row = 0; row < rowCount; ++row) {
                items[row][col] = (String)model.getValueAt(row, dataCol);
            }
        }
        return items;
    }

    public Insets getInsets() {
        return new Insets(10, 10, 5, 10);
    }

    public void valueChanged(ListSelectionEvent e2) {
        boolean delOK = this.grid.getSelectedRow() >= 0 && this.grid.getSelectedColumn() >= 0;
        this.remCol.setEnabled(delOK);
        this.remRow.setEnabled(delOK);
    }
}

