/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.runner.TestCollector;

public abstract class ClassPathTestCollector
implements TestCollector {
    static final int SUFFIX_LENGTH = ".class".length();

    public Enumeration collectTests() {
        String classPath = System.getProperty("java.class.path");
        Hashtable result = this.collectFilesInPath(classPath);
        return result.elements();
    }

    public Hashtable collectFilesInPath(String classPath) {
        Hashtable result = this.collectFilesInRoots(this.splitClassPath(classPath));
        return result;
    }

    Hashtable collectFilesInRoots(Vector roots) {
        Hashtable result = new Hashtable(100);
        Enumeration e2 = roots.elements();
        while (e2.hasMoreElements()) {
            this.gatherFiles(new File((String)e2.nextElement()), "", result);
        }
        return result;
    }

    void gatherFiles(File classRoot, String classFileName, Hashtable result) {
        File thisRoot = new File(classRoot, classFileName);
        if (thisRoot.isFile()) {
            if (this.isTestClass(classFileName)) {
                String className = this.classNameFromFile(classFileName);
                result.put(className, className);
            }
            return;
        }
        String[] contents = thisRoot.list();
        if (contents != null) {
            int i2 = 0;
            while (i2 < contents.length) {
                this.gatherFiles(classRoot, String.valueOf(classFileName) + File.separatorChar + contents[i2], result);
                ++i2;
            }
        }
    }

    Vector splitClassPath(String classPath) {
        Vector<String> result = new Vector<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, separator);
        while (tokenizer.hasMoreTokens()) {
            result.addElement(tokenizer.nextToken());
        }
        return result;
    }

    protected boolean isTestClass(String classFileName) {
        return classFileName.endsWith(".class") && classFileName.indexOf(36) < 0 && classFileName.indexOf("Test") > 0;
    }

    protected String classNameFromFile(String classFileName) {
        String s = classFileName.substring(0, classFileName.length() - SUFFIX_LENGTH);
        String s2 = s.replace(File.separatorChar, '.');
        if (s2.startsWith(".")) {
            return s2.substring(1);
        }
        return s2;
    }
}

