/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class ComparisonFailure
extends AssertionFailedError {
    private String fExpected;
    private String fActual;

    public ComparisonFailure(String message, String expected, String actual) {
        super(message);
        this.fExpected = expected;
        this.fActual = actual;
    }

    public String getMessage() {
        String actual;
        String expected;
        if (this.fExpected == null || this.fActual == null) {
            return Assert.format(super.getMessage(), this.fExpected, this.fActual);
        }
        int end = Math.min(this.fExpected.length(), this.fActual.length());
        int i2 = 0;
        while (i2 < end) {
            if (this.fExpected.charAt(i2) != this.fActual.charAt(i2)) break;
            ++i2;
        }
        int j2 = this.fExpected.length() - 1;
        int k = this.fActual.length() - 1;
        while (k >= i2 && j2 >= i2) {
            if (this.fExpected.charAt(j2) != this.fActual.charAt(k)) break;
            --k;
            --j2;
        }
        if (j2 < i2 && k < i2) {
            expected = this.fExpected;
            actual = this.fActual;
        } else {
            expected = this.fExpected.substring(i2, j2 + 1);
            actual = this.fActual.substring(i2, k + 1);
            if (i2 <= end && i2 > 0) {
                expected = "..." + expected;
                actual = "..." + actual;
            }
            if (j2 < this.fExpected.length() - 1) {
                expected = String.valueOf(expected) + "...";
            }
            if (k < this.fActual.length() - 1) {
                actual = String.valueOf(actual) + "...";
            }
        }
        return Assert.format(super.getMessage(), expected, actual);
    }
}

