/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AbortFlag;
import cyberlink.AppRenderer;
import cyberlink.ConfigInfo;
import cyberlink.CurrentKeyStatus;
import cyberlink.CyberLink;
import cyberlink.CyberLinkClient;
import cyberlink.EncoderException;
import cyberlink.FileManager;
import cyberlink.InputCanceledException;
import cyberlink.KeySessionHandler;
import cyberlink.KeyStatus;
import cyberlink.LastCardInfo;
import cyberlink.LastKeyInfo;
import cyberlink.MainFrame;
import cyberlink.NotificationManager;
import cyberlink.ServerProperties;
import cyberlink.ServiceException;
import cyberlink.StatusProcessor;
import cyberlink.UIHandler;
import cyberlink.Util;
import java.io.IOException;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class WorkerThread
extends Thread {
    public static final int ENTERPRISE = 1;
    public static final int PROFESSIONAL = 2;
    public static final int LITE = 3;
    public CyberLink encoder;
    public CyberLinkClient webService;
    private boolean stop = false;
    private String voltage = "";
    private KeyStatus KS;
    public KeySessionHandler keySession;
    private boolean doUpdate;
    private int requestedVersion;
    private KeyStatus initialStatus;
    public String currentLinkID;
    private String currentKeyID;
    private byte[] currentKeyStatus;
    public NotificationManager NM;
    private Object obj;
    public ServerProperties serverProps;
    public static byte[] configBytesFromServer;
    public static int linkDiscoveryReTries;
    public static boolean isRFIDMode;
    public static int FIRMWARE_108;
    public static int FIRMWARE_109;
    public static int FIRMWARE_110;
    public static int SOFTWARE_113;
    public static int HARDWARE_113;
    public static boolean ALLOWKEYUPDATING;
    public static boolean ALLOWISSUEWITHKEY;
    public static boolean USEWRITEFILEWORKAROUND;
    public FileManager fileManager;
    public AbortFlag flag;
    public UIHandler uiHandler;
    public LastKeyInfo lastKeyInfo;
    public LastCardInfo lastCardInfo;
    public boolean wasDisabled = false;
    private boolean firstVaultContact = false;
    public boolean startingOver;
    public String lastKnownIssueNumber = null;

    public WorkerThread(CyberLink encoder) {
        this.encoder = encoder;
        this.uiHandler = encoder.getUIHandler();
        this.flag = new AbortFlag(false);
        this.fileManager = null;
        this.obj = new Object();
        linkDiscoveryReTries = 0;
        if (CyberLink.noPrompt) {
            this.NM = new NotificationManager(encoder);
        }
        encoder.getFrameRef().setViewVaultInfoVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentVariables(String link, byte[] status) {
        Object object = this.obj;
        synchronized (object) {
            if (status != null) {
                this.currentKeyID = new KeyStatus(status).getKeyID();
                this.currentLinkID = link;
                this.currentKeyStatus = status;
            } else {
                this.currentKeyID = null;
                this.currentLinkID = null;
                this.currentKeyStatus = null;
            }
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCurrentVariables() {
        byte[] tempVar;
        Object object = this.obj;
        synchronized (object) {
            tempVar = this.currentKeyStatus;
        }
        return tempVar;
    }

    private ServerProperties initializeProperties() throws Exception {
        ServerProperties props;
        this.initialStatus = this.fileManager.readStatus();
        this.uiHandler.postOperation(AppRenderer.instance.render("message.connect"));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.wait"));
        int USBFWV = this.initialStatus.getUSBLinkFirmwareVer();
        int WEBFWV = this.initialStatus.getWEBLinkFirmwareVer();
        int RFIDFWV = this.initialStatus.getRFIDFirmwareVer();
        String oldLinkID = this.initialStatus.getLinkID();
        try {
            props = this.webService.getServerProperties(USBFWV);
        }
        catch (Exception ex) {
            this.uiHandler.connectionError(this.translateException(ex));
            throw ex;
        }
        if (this.initialStatus.isUSBStation && USBFWV <= 7) {
            return props;
        }
        FIRMWARE_108 = props.firmware_108;
        FIRMWARE_109 = props.firmware_109;
        FIRMWARE_110 = props.firmware_110;
        SOFTWARE_113 = props.software_113;
        HARDWARE_113 = props.hardware_113;
        ALLOWKEYUPDATING = props.allowKeyUpdating == 1;
        ALLOWISSUEWITHKEY = props.issueWithKey == 1;
        USEWRITEFILEWORKAROUND = props.useCopyBypass == 1;
        if (this.initialStatus.isUSBKey) {
            return props;
        }
        int USBVersion = 0;
        String USBPath = null;
        int WEBVersion = 0;
        String WEBPath = null;
        int RFIDVersion = 0;
        String RFIDPath = null;
        if (this.initialStatus.isEncoder) {
            USBVersion = props.encoderFWVer;
            USBPath = props.encoderFWPath;
        } else if (this.initialStatus.isUSBStation) {
            USBVersion = props.stationFWVer;
            USBPath = props.stationFWPath;
        } else if (this.initialStatus.isWEBStation) {
            USBVersion = props.stationFWVer;
            USBPath = props.stationFWPath;
            WEBVersion = props.webstationFWVer;
            WEBPath = props.webstationFWPath;
        } else if (this.initialStatus.isVault) {
            USBVersion = props.vaultUSBFWVer;
            USBPath = props.vaultUSBFWPath;
            WEBVersion = props.vaultWEBFWVer;
            WEBPath = props.vaultWEBFWPath;
            RFIDVersion = props.vaultRFIDFWVer;
            RFIDPath = props.vaultRFIDFWPath;
        } else if (this.initialStatus.isCardReader) {
            USBVersion = props.vaultUSBFWVer;
            USBPath = props.vaultUSBFWPath;
            RFIDVersion = props.vaultRFIDFWVer;
            RFIDPath = props.vaultRFIDFWPath;
        }
        this.uiHandler.postStatus(AppRenderer.instance.render("message.updates"));
        if (USBVersion > USBFWV || WEBVersion > WEBFWV || RFIDVersion > RFIDFWV) {
            if (USBVersion > USBFWV) {
                this.performUpdate(USBPath, false);
                if (this.fileManager.isMac && !this.initialStatus.isWEBStation && !this.initialStatus.isCardReader) {
                    Thread.sleep(3000L);
                    this.encoder.showMacExitDialog();
                    System.exit(0);
                } else {
                    Thread.sleep(12000L);
                }
            }
            if ((this.initialStatus.isWEBStation || this.initialStatus.isVault) && WEBVersion > WEBFWV) {
                this.performUpdate(WEBPath, true);
                if (this.fileManager.isMac && !this.initialStatus.isVault) {
                    Thread.sleep(3000L);
                    this.encoder.showMacExitDialog();
                    System.exit(0);
                } else {
                    Thread.sleep(30000L);
                }
            }
            if ((this.initialStatus.isVault || this.initialStatus.isCardReader) && RFIDVersion > RFIDFWV) {
                this.performUpdate(RFIDPath, true);
                if (this.fileManager.isMac) {
                    Thread.sleep(3000L);
                    this.encoder.showMacExitDialog();
                    System.exit(0);
                } else {
                    Thread.sleep(30000L);
                }
            }
            this.fileManager = new FileManager(this);
            try {
                this.initialStatus = this.fileManager.readStatus();
                String newLinkID = this.initialStatus.getLinkID();
                if (!oldLinkID.equals(newLinkID)) {
                    throw new Exception(AppRenderer.instance.render("error.cyberlink.id"));
                }
                if (this.initialStatus.getUSBLinkFirmwareVer() != USBVersion) {
                    throw new Exception(AppRenderer.instance.render("warning.update.unplug"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception(AppRenderer.instance.render("error.update.unplug"));
            }
        }
        this.uiHandler.postError("");
        return props;
    }

    private void performUpdate(String firmwarePath, boolean isWebStationUpdate) throws Exception {
        this.uiHandler.postOperation(AppRenderer.instance.render("cyberlink.update.title"));
        this.uiHandler.postStatus(AppRenderer.instance.render("cyberlink.update.download"));
        byte[] newFW = this.webService.downloadCurrentEncoderFirmware(firmwarePath);
        this.uiHandler.postStatus(AppRenderer.instance.render("cyberlink.update.inprogress"));
        if (isWebStationUpdate) {
            this.fileManager.writeWEBStationFirmwareUpgrade(newFW);
        } else {
            this.fileManager.writeFirmwareUpgrade(newFW);
        }
    }

    public void initMessagesAndProgressBar() {
        this.uiHandler.setBarColor(-1);
        this.uiHandler.setPRBarIndeterminate(false);
        this.uiHandler.updateProgressBar(0);
        this.uiHandler.stopTimer();
        this.uiHandler.postVoltage("");
        this.uiHandler.postKeyname("");
        this.uiHandler.postError("");
        this.uiHandler.postCardID("");
        this.uiHandler.postStatus("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.uiHandler.allowAbort(false);
        this.uiHandler.setPRBarIndeterminate(false);
        while (!this.stop) {
            block63: {
                try {
                    this.flag.abort = false;
                    if (this.currentLinkID != null) {
                        this.setCurrentVariables(this.currentLinkID, null);
                    } else {
                        this.setCurrentVariables(null, null);
                    }
                    this.initMessagesAndProgressBar();
                    if (this.fileManager == null || !this.fileManager.isDevicePresent()) {
                        this.fileManager = null;
                        this.initMessagesAndProgressBar();
                        this.uiHandler.postStatus("");
                        this.uiHandler.postOperation(AppRenderer.instance.render("cyberlink.search"));
                        this.fileManager = new FileManager(this);
                        this.firstVaultContact = false;
                        KeyStatus tempStatus = this.fileManager.readStatus();
                        if (tempStatus.isVault || tempStatus.isWEBStation) {
                            this.firstVaultContact = true;
                        }
                    }
                    this.setCurrentVariables(this.fileManager.getLinkID(), null);
                    if (CyberLink.serverURL != null) {
                        this.uiHandler.allowAbort(false);
                        this.webService = new CyberLinkClient(this.uiHandler, this.fileManager.getLinkID());
                        if (this.serverProps == null) {
                            this.serverProps = this.initializeProperties();
                        }
                        KeyStatus currentStatus = this.fileManager.readStatus();
                        this.encoder.getFrameRef().setViewVaultInfoVisible(currentStatus.isVault);
                        this.encoder.getFrameRef().setCardScannerVisible(currentStatus.isVault);
                        this.encoder.getFrameRef().setViewNetworkInfoVisible(currentStatus.isWEBStation);
                        this.encoder.getFrameRef().setViewKeyInfoVisible(!currentStatus.isCardReader && CyberLink.cardScanningMode == false);
                        this.encoder.getFrameRef().setViewCardInfoVisible(currentStatus.isCardReader || CyberLink.cardScanningMode != false);
                        if (!(currentStatus.isVault || currentStatus.isCardReader || CyberLink.cardScanningMode.booleanValue())) {
                            this.encoder.getFrameRef().setCurrentKeyStatusOnVisible(true);
                            this.encoder.getFrameRef().setCurrentKeyStatusOffVisible(false);
                        }
                        this.setCurrentVariables(this.fileManager.getLinkID(), currentStatus.getRawData());
                        this.keySession = new KeySessionHandler(this.fileManager, this.flag, this);
                        this.keySession.deleteKeyConfig();
                        this.uiHandler.updateProgressBar(0);
                        if (CyberLink.noPrompt) {
                            this.NM.setSessionHandler(this.keySession);
                        }
                        if (currentStatus.isVault && !currentStatus.bitDemoMode) {
                            this.keySession.sendDemoModeOnCommand();
                        }
                        try {
                            String addr = this.webService.getCurrentServerAddress();
                            boolean okToCheckCellnode = true;
                            if (addr.contains("FW_Upgrade") || addr.contains("GM_Factory") || currentStatus.isCardReader) {
                                okToCheckCellnode = false;
                            }
                            if (okToCheckCellnode) {
                                this.confirmCyberLinkExistence(currentStatus);
                                if (this.firstVaultContact) {
                                    if (currentStatus.isVault) {
                                        this.configureWebStation(this.fileManager.getLinkID(), true);
                                    } else {
                                        this.configureWebStation(this.fileManager.getLinkID(), false);
                                    }
                                    this.firstVaultContact = false;
                                }
                            }
                        }
                        catch (InputCanceledException ice) {
                            throw new EncoderException(EncoderException.ErrorCode.ABORT);
                        }
                        this.setCurrentVariables(this.fileManager.getLinkID(), currentStatus.getRawData());
                        if (!this.startingOver) {
                            if (currentStatus.isVault && CyberLink.cardScanningMode.booleanValue() || currentStatus.isCardReader) {
                                this.uiHandler.postOperation(AppRenderer.instance.render("status.cardreader.message.ready"));
                            } else {
                                this.uiHandler.postOperation(AppRenderer.instance.render("status.message.ready"));
                            }
                            if (currentStatus.isEncoder) {
                                this.uiHandler.postStatus(AppRenderer.instance.render("status.encoder.presentkey"));
                            } else if (currentStatus.isVault) {
                                if (CyberLink.cardScanningMode.booleanValue()) {
                                    this.uiHandler.postStatus(AppRenderer.instance.render("status.cardreader.presentcard"));
                                } else if (CyberLink.needsDedicatedKeyForVault) {
                                    this.uiHandler.postStatus(AppRenderer.instance.render("status.vault.presentDedicatedkey"));
                                } else {
                                    this.uiHandler.postStatus(AppRenderer.instance.render("status.vault.generic.message"));
                                }
                            } else if (currentStatus.isCardReader) {
                                this.uiHandler.postStatus(AppRenderer.instance.render("status.cardreader.presentcard"));
                            } else if (!currentStatus.isUSBKey) {
                                this.uiHandler.postStatus(AppRenderer.instance.render("status.station.presentkey"));
                            }
                        } else {
                            this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.updatewait"));
                        }
                        this.lastCardInfo = new LastCardInfo(currentStatus);
                        this.KS = this.keySession.connectToKey();
                        this.encoder.getFrameRef().showApp();
                        this.setCurrentVariables(this.fileManager.getLinkID(), this.KS.getRawData());
                        this.uiHandler.postOperation(AppRenderer.instance.render("status.key.found") + " " + this.KS.getKeyID());
                        this.uiHandler.postStatus("");
                        this.uiHandler.postError("");
                        if (CyberLink.serverURL.toString().contains("FW_Upgrade") && (this.KS.getPID() == 108 || this.KS.getPID() == 109)) {
                            this.uiHandler.postStatus(AppRenderer.instance.render("status.firmware.update"));
                        } else if (CyberLink.serverURL.toString().contains("GM_Factory") && this.KS.getPID() == 106) {
                            this.uiHandler.postStatus(AppRenderer.instance.render("status.master.factory"));
                        } else {
                            this.uiHandler.postStatus(AppRenderer.instance.render("status.download.audit"));
                        }
                        this.voltage = this.KS.getVoltage();
                        this.uiHandler.postVoltage(AppRenderer.instance.render("status.battery.voltage") + " " + this.voltage);
                        this.uiHandler.allowAbort(false);
                        if (CyberLink.noPrompt) {
                            this.NM.sendKeyIn(this.KS.getKeyIDBytes(), this.KS.getMillivolts(), this.KS.isGrandMaster, this.KS.isProgrammer);
                        }
                        this.processKey();
                        break block63;
                    }
                    this.uiHandler.postOperation(AppRenderer.instance.render("status.welcome"));
                    this.uiHandler.postStatus(AppRenderer.instance.render("status.server.url"));
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e2) {
                    if (e2 instanceof EncoderException) {
                        EncoderException ex = (EncoderException)e2;
                        if (ex.errorCode == EncoderException.ErrorCode.WEB_STATION_CONFIG_NEEDED) {
                            try {
                                KeyStatus KS = this.fileManager.readStatus();
                                this.configureWebStation(this.fileManager.getLinkID(), KS.isVault);
                                continue;
                            }
                            catch (Exception exx) {
                                exx.printStackTrace();
                            }
                        } else {
                            if (ex.errorCode == EncoderException.ErrorCode.VAULT_NETWORK_RESPONSE) continue;
                            if (ex.errorCode == EncoderException.ErrorCode.KEY_STATUS_MODE_ON) {
                                this.encoder.getFrameRef().setCurrentKeyStatusOnVisible(false);
                                this.encoder.getFrameRef().setCurrentKeyStatusOffVisible(true);
                                CurrentKeyStatus CKS = new CurrentKeyStatus(this);
                                continue;
                            }
                            if (ex.errorCode == EncoderException.ErrorCode.ABORT) {
                                this.uiHandler.postOperation(AppRenderer.instance.render("input.error.cancel"));
                                this.uiHandler.postStatus(AppRenderer.instance.render("status.client.generic.not.issued"));
                                this.stopWorking();
                                continue;
                            }
                        }
                    }
                    if (this.stop || this.flag.abort) break block63;
                    String msg = this.translateException(e2);
                    if (msg.equals(AppRenderer.instance.render("input.error.cancel"))) {
                        this.uiHandler.postOperation(msg);
                    }
                    if (msg.equals(AppRenderer.instance.render("message.error.vault.key.valid")) || msg.equals(AppRenderer.instance.render("message.error.vault.key.invalid")) || msg.equals(AppRenderer.instance.render("message.error.vault.key.in.active.mission"))) {
                        this.uiHandler.postOperation(AppRenderer.instance.render("status.message.ready"));
                        this.uiHandler.postKeyname(msg);
                        this.uiHandler.postStatus(AppRenderer.instance.render("status.vault.generic.message"));
                    }
                    if (msg.equals(AppRenderer.instance.render("message.error.addkey"))) {
                        this.uiHandler.postError(msg);
                        if (this.wasDisabled) {
                            this.uiHandler.postStatus(AppRenderer.instance.render("message.key.disabled"));
                        }
                    }
                    if (msg.equals(AppRenderer.instance.render("message.error.dedicated.vault"))) {
                        this.uiHandler.postStatus(msg);
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (msg.equals("LINK_NOT_FOUND")) break block63;
                    this.uiHandler.postError(msg);
                    this.encoder.getFrameRef().setLastError(msg, e2);
                }
            }
            if (this.stop || this.fileManager == null) continue;
            try {
                this.uiHandler.allowAbort(false);
                this.uiHandler.setPRBarIndeterminate(false);
                this.uiHandler.updateProgressBar(0);
                if (this.startingOver) continue;
                KeyStatus KS = this.fileManager.readStatus();
                if (KS.isStation && (KS.isStealthKey || KS.isBluetoothKey) || KS.isUSBKey) {
                    this.fileManager.waitForChargingKeyToLeave(this);
                } else {
                    this.uiHandler.postStatus(AppRenderer.instance.render("status.remove.key"));
                    this.fileManager.waitForAllKeysToLeave(this.flag);
                }
                if (CyberLink.noPrompt) {
                    this.NM.sendKeyOut();
                }
                WorkerThread workerThread = this;
                synchronized (workerThread) {
                    this.notify();
                }
            }
            catch (InterruptedException ignore) {
            }
            catch (EncoderException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateException(Exception e2) {
        block52: {
            block51: {
                if (!(e2 instanceof EncoderException)) break block51;
                EncoderException ex = (EncoderException)e2;
                if (ex.errorCode == EncoderException.ErrorCode.STATUSFILE_NOT_FOUND) {
                    return AppRenderer.instance.render("message.error.nostatusfile");
                }
                if (ex.errorCode == EncoderException.ErrorCode.EVENTFILE_NOT_FOUND) {
                    return AppRenderer.instance.render("message.error.noeventfile");
                }
                if (ex.errorCode == EncoderException.ErrorCode.LINK_NOT_FOUND) {
                    this.fileManager = null;
                    if (++linkDiscoveryReTries == 4) {
                        this.uiHandler.LinkNotFoundError();
                        linkDiscoveryReTries = 0;
                    }
                    break block52;
                } else {
                    if (ex.errorCode == EncoderException.ErrorCode.WRONG_LINK) {
                        this.fileManager = null;
                        return AppRenderer.instance.render("message.error.linktype");
                    }
                    if (ex.errorCode == EncoderException.ErrorCode.CONFIGFILE_PROBLEM) {
                        String line1 = AppRenderer.instance.render("message.error.config1");
                        String line2 = AppRenderer.instance.render("message.error.config2");
                        String message = this.buildMessageString(50, line1, line2);
                        if (this.KS == null) return message + " - code " + Integer.toHexString(ex.statusCode & 0xFF).toUpperCase() + "\n";
                        try {
                            this.webService.addCellnodeEvent(this.KS.getKeyID(), 400);
                            return message + " - code " + Integer.toHexString(ex.statusCode & 0xFF).toUpperCase() + "\n";
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                        return message + " - code " + Integer.toHexString(ex.statusCode & 0xFF).toUpperCase() + "\n";
                    }
                    if (ex.errorCode == EncoderException.ErrorCode.INVALID_KEY) {
                        String line1 = AppRenderer.instance.render("message.error.invalid1");
                        String line2 = AppRenderer.instance.render("message.error.invalid2");
                        String message = this.buildMessageString(28, line1, line2);
                        return message + "\n";
                    }
                    if (ex.errorCode == EncoderException.ErrorCode.OLD_KEY) {
                        short PID = this.KS.getPID();
                        String line1 = AppRenderer.instance.render("message.error.invalid3", Integer.toString(PID));
                        String line2 = AppRenderer.instance.render("message.error.invalid2");
                        String message = this.buildMessageString(28, line1, line2);
                        return message + "\n";
                    }
                    if (ex.errorCode == EncoderException.ErrorCode.USB_WRITE_ERROR) {
                        return AppRenderer.instance.render("message.error.usb_write_error");
                    }
                    if (ex.errorCode != EncoderException.ErrorCode.ALREADY_CONFIGURED) return ex.errorCode.toString();
                    return AppRenderer.instance.render("message.error.key.already.configured");
                }
            }
            if (e2 instanceof SSLHandshakeException) {
                return AppRenderer.instance.render("message.error.ssl");
            }
            if (e2 instanceof IOException) {
                IOException ioe = (IOException)e2;
                if (ioe.getMessage().equals("Connection refused: connect")) {
                    return AppRenderer.instance.render("message.error.refused");
                }
                if (!ioe.getMessage().equals("No route to host: connect")) return AppRenderer.instance.render("message.error.io") + " " + ioe.getMessage();
                return AppRenderer.instance.render("message.error.route");
            }
            if (e2 instanceof InterruptedException) {
                InterruptedException ie = (InterruptedException)e2;
                if (ie.getMessage().equals("timeout")) {
                    try {
                        this.webService.addCellnodeEvent(this.currentKeyID, 401);
                        return AppRenderer.instance.render("message.error.timeout");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return AppRenderer.instance.render("message.error.timeout");
                }
                if (ie.getMessage().equals("GM_Factory")) {
                    return AppRenderer.instance.render("message.error.masterurl");
                }
                if (ie.getMessage().equals("FW_Upgrade")) {
                    return AppRenderer.instance.render("message.error.firmwareup");
                }
                if (ie.getMessage().equals("FW_Upgrade_USB")) {
                    return AppRenderer.instance.render("message.error.firmwareup.usbkey");
                }
            } else {
                if (e2 instanceof ServiceException) {
                    ServiceException ex = (ServiceException)e2;
                    if (ex.friendlyMessage != null) {
                        return ex.friendlyMessage;
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.HIGH_SECURITY_BIT_SET) {
                        return AppRenderer.instance.render("message.error.differentdb");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.CATALOG_DOESNT_EXIST) {
                        return AppRenderer.instance.render("message.error.nodatabase");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_ADDITION_DENIED) {
                        return AppRenderer.instance.render("message.error.addkey");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.USER_NOT_LOGGED_IN) {
                        return AppRenderer.instance.render("message.error.loginrequired");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                        return AppRenderer.instance.render("message.error.nokey");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.NEW_LOCK_ADD_DENIED) {
                        return AppRenderer.instance.render("message.error.addlock");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.IRLINK_NOT_ENABLED) {
                        if (!this.fileManager.getLinkID().startsWith("V")) return AppRenderer.instance.render("message.error.station.disabled");
                        return AppRenderer.instance.render("message.error.encoder.disabled");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.REMOTE_ACCESS_DENIED) {
                        return AppRenderer.instance.render("message.error.noremoteaccess");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.UNSECURE_ACCESS_DENIED) {
                        return AppRenderer.instance.render("message.error.nounsecureaccess");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.FIRMWARE_UPGRADE_DENIED) {
                        return AppRenderer.instance.render("message.error.upgradedenied");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.WEBSTATION_NOT_ENABLED) {
                        return AppRenderer.instance.render("message.error.webstation.disabled");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.USBSTATION_NOT_ENABLED) {
                        return AppRenderer.instance.render("message.error.usbstation.disabled");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.VAULT1_NOT_ENABLED) {
                        return AppRenderer.instance.render("message.error.vault.disabled");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_VALID_FOR_VAULT) {
                        return AppRenderer.instance.render("message.error.vault.key.valid");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_IN_VAULT_INVALID) {
                        return AppRenderer.instance.render("message.error.vault.key.invalid");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_IN_ACTIVE_MISSION) {
                        return AppRenderer.instance.render("message.error.vault.key.in.active.mission");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.LOCKLIST_EVENTS_MISMATCH) {
                        String line1 = AppRenderer.instance.render("message.error.config1");
                        String line2 = AppRenderer.instance.render("message.error.config2");
                        return this.buildMessageString(50, line1, line2);
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.KEY_DOWNLOAD_INVALID) {
                        return AppRenderer.instance.render("message.error.key.data.error");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.GENERAL_DATA_ERROR) {
                        return AppRenderer.instance.render("message.error.general.data.error");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.RETURN_TO_DEDICATED_VAULT) {
                        return AppRenderer.instance.render("message.error.dedicated.vault");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.NO_SERVER_URL) {
                        return AppRenderer.instance.render("message.error.no.server.url");
                    }
                    if (ex.errorCode == ServiceException.ErrorCode.LOCKLIST_TOO_LARGE) {
                        return AppRenderer.instance.render("message.error.locklist.too.large");
                    }
                    if (ex.errorCode != ServiceException.ErrorCode.NO_OWNER_ISSUE_DENIED) return ex.toString();
                    return AppRenderer.instance.render("message.error.system.key.issue.denied");
                }
                if (e2 instanceof InputCanceledException) {
                    if (e2.getMessage().equals("LOGIN_NUMBER_REQUIRED")) {
                        this.uiHandler.postStatus(AppRenderer.instance.render("message.grandmaster.login.required"));
                    }
                    if (!e2.getMessage().equals("PIN does not match")) return AppRenderer.instance.render("input.error.cancel");
                    try {
                        this.webService.addCellnodeEvent(this.KS.getKeyID(), 402);
                        return AppRenderer.instance.render("input.error.cancel");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return AppRenderer.instance.render("input.error.cancel");
                }
                e2.printStackTrace();
            }
        }
        if (e2.getMessage() == null) return e2.toString();
        return e2.getMessage();
    }

    private String buildMessageString(int space, String line1, String line2) {
        int loop;
        StringBuilder line;
        int pad;
        if (line1.length() < space) {
            pad = space - line1.length();
            line = new StringBuilder();
            pad /= 2;
            for (loop = 0; loop < pad; ++loop) {
                line.append(" ");
            }
            line.append(line1);
            line1 = line.toString();
        }
        if (line2.length() < space) {
            pad = space - line2.length();
            line = new StringBuilder();
            pad /= 2;
            for (loop = 0; loop < pad; ++loop) {
                line.append(" ");
            }
            line.append(line2);
            line2 = line.toString();
        }
        return line1 + "\n" + line2;
    }

    /*
     * Unable to fully structure code
     */
    public void processKey() throws Exception {
        block74: {
            Thread.sleep(250L);
            this.startingOver = false;
            PID = this.KS.getPID();
            SWV = this.KS.getSWV();
            HWV = this.KS.getHWV();
            if (PID < 102) {
                throw new EncoderException(EncoderException.ErrorCode.OLD_KEY);
            }
            if (PID == 66 || PID == 114 || this.KS.isInvalidGMKey) {
                throw new EncoderException(EncoderException.ErrorCode.INVALID_KEY);
            }
            keyStatus = this.KS.getRawData();
            this.uiHandler.setPRBarIndeterminate(true);
            if (this.KS.isGrandMaster) {
                this.uiHandler.setKeyType(3);
            } else if (this.KS.isProgrammer) {
                this.uiHandler.setKeyType(2);
            } else {
                this.uiHandler.setKeyType(1);
            }
            this.wasDisabled = false;
            this.doProgressBar();
            events = KeySessionHandler.getEventFileWithConfirmation(null);
            if (this.KS.isVault && this.isVaultNetworkResponse(events)) {
                this.keySession.getRestartKeyHandling();
                throw new EncoderException(EncoderException.ErrorCode.VAULT_NETWORK_RESPONSE);
            }
            if (events == null) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.remove5"));
                this.uiHandler.postError(AppRenderer.instance.render("message.key.commproblem"));
                if (this.KS.isStation) {
                    v0 = this;
                    v0.keySession.sendKeyReady();
                }
                if (this.keySession.isKeyGone()) {
                    return;
                }
            }
            if (CyberLink.serverURL.toString().contains("GM_Factory")) {
                if (PID != 106) {
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.master.resetremove"));
                    throw new InterruptedException("GM_Factory");
                }
                this.doGrandMasterFactorySettings(keyStatus);
                if (this.KS.isStation) {
                    v1 = this;
                    v1.keySession.sendKeyReady();
                }
                return;
            }
            lockListBytes = null;
            if (this.KS.isProgrammer || this.KS.isConfigureKey || this.KS.isGrandMaster) {
                lockListRequestCommand = this.getLockListRequestCommand(this.currentKeyID, keyStatus);
                lockListBytes = this.keySession.sendLocklistCommand(lockListRequestCommand);
            }
            if (CyberLink.serverURL.toString().contains("FW_Upgrade")) {
                if (PID != 108 && PID != 109 && PID != 110 && PID != 113) {
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.updateremove"));
                    throw new InterruptedException("FW_Upgrade");
                }
                if (this.KS.isUSBKey && !this.isUSBKeyWithCable(this.KS)) {
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.updateremove"));
                    throw new InterruptedException("FW_Upgrade_USB");
                }
                version = new Integer(this.KS.getSWV()).toString();
                if (PID == 113) {
                    swv = new Integer(this.KS.getSWV()).toString();
                    hwv = new Integer(this.KS.getHardwareByte()).toString();
                    if (hwv.length() == 1) {
                        hwv = "0" + hwv;
                    }
                    version = swv + hwv;
                }
                this.encoder.frame.showUpdateModal(version, PID);
                if (this.doUpdate) {
                    this.upgradeFirmware(this.KS, events, lockListBytes, false);
                    if (this.KS.isProgrammer) {
                        ProgConfig = this.webService.getProgConfig(this.KS.getRawData(), false);
                        this.keySession.sendKeyConfigOnly(ProgConfig);
                    }
                } else {
                    this.uiHandler.postOperation(AppRenderer.instance.render("message.key.cancel"));
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.cancelremove"));
                }
                this.doUpdate = false;
                this.requestedVersion = 0;
                if (this.KS.isStation) {
                    v2 = this;
                    v2.keySession.sendKeyReady();
                }
                return;
            }
            if ((WorkerThread.ALLOWKEYUPDATING && !this.KS.isUSBKey || this.isUSBKeyWithCable(this.KS)) && (PID == 108 && SWV < WorkerThread.FIRMWARE_108 || PID == 109 && SWV < WorkerThread.FIRMWARE_109 || PID == 110 && SWV < WorkerThread.FIRMWARE_110 || PID == 113 && SWV < WorkerThread.SOFTWARE_113 || PID == 113 && HWV < WorkerThread.HARDWARE_113)) {
                switch (PID) {
                    case 108: {
                        this.requestedVersion = WorkerThread.FIRMWARE_108;
                        break;
                    }
                    case 109: {
                        this.requestedVersion = WorkerThread.FIRMWARE_109;
                        break;
                    }
                    case 110: {
                        this.requestedVersion = WorkerThread.FIRMWARE_110;
                        break;
                    }
                    case 113: {
                        this.requestedVersion = this.getUSBKeyFirmwareVersion(WorkerThread.SOFTWARE_113, WorkerThread.HARDWARE_113);
                    }
                }
                title = AppRenderer.instance.render("firmware.update.title");
                message = new String[]{AppRenderer.instance.render("firmware.update.firstline"), " ", AppRenderer.instance.render("firmware.update.secondline"), " "};
                result = JOptionPane.showConfirmDialog(this.encoder.getFrameRef(), message, title, 0, 3, new ImageIcon(MainFrame.class.getResource("about.png")));
                switch (result) {
                    case 0: {
                        while (true) {
                            try {
                                this.upgradeFirmware(this.KS, events, lockListBytes, true);
                            }
                            catch (ServiceException ex) {
                                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                                    this.issueCellnode(this.webService, keyStatus);
                                    continue;
                                }
                                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                                    this.issueKey(this.webService, keyStatus, this.KS.getKeyID());
                                    continue;
                                }
                                throw ex;
                                if (!this.flag.abort) continue;
                            }
                            break;
                        }
                        if (this.KS.isProgrammer) {
                            ProgConfig = this.webService.getProgConfig(this.KS.getRawData(), true);
                            this.keySession.sendKeyConfigOnly(ProgConfig);
                        }
                        this.keySession.deleteFirmwareConfig();
                        this.uiHandler.postOperation(AppRenderer.instance.render("firmware.update.start.over"));
                        this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.updatewait"));
                        this.startingOver = true;
                        return;
                    }
                }
                this.requestedVersion = 0;
            }
            this.checkCanTouchKey(keyStatus, this.KS.getKeyID());
            programmerCode = -2147483648;
            configNeeded = true;
            while (configNeeded) {
                this.KS = this.fileManager.readStatus();
                this.flag.check();
                if (this.KS.isProgrammer || this.KS.isGrandMaster && programmerCode == -2147483648) {
                    try {
                        programmerCode = this.getJobOrAdminNumber(false);
                    }
                    catch (InputCanceledException exx) {
                        programmerCode = -1;
                    }
                }
                if (events != null) {
                    while (true) {
                        this.flag.check();
                        try {
                            this.synchronizeKey(this.currentKeyID, events, lockListBytes, keyStatus, this.keySession.expectedEventTime, programmerCode);
                        }
                        catch (ServiceException se) {
                            if (se.errorCode == ServiceException.ErrorCode.PROG_JOB_NOT_FOUND) {
                                programmerCode = this.getJobOrAdminNumber(true);
                                continue;
                            }
                            if (se.errorCode == ServiceException.ErrorCode.KEY_DOWNLOAD_INVALID && !this.isUSBKeyWithCable(this.KS)) {
                                reason = se.invalid_reason;
                                if (reason < 8) ** break;
                                continue;
                                this.keySession.resetKey();
                                Thread.sleep(2000L);
                                this.uiHandler.postError(AppRenderer.instance.render("message.error.keycommfail"));
                                return;
                            }
                            throw se;
                        }
                        break;
                    }
                    events = null;
                    lockListBytes = null;
                }
                Thread.sleep(750L);
                this.flag.check();
                try {
                    extraInfo = new ConfigInfo();
                    keyConfigFile = this.getKeyConfig(this.currentKeyID, this.KS, programmerCode, extraInfo);
                }
                catch (InputCanceledException ice) {
                    if (ice.getMessage().equals("PROG_JOB_NOT_FOUND")) {
                        if (this.KS.isStation) {
                            v3 = this;
                            v3.keySession.sendKeyReady();
                        }
                        return;
                    }
                    if (this.wasDisabled) break;
                    throw ice;
                }
                this.uiHandler.postKeyname(extraInfo.getKeyName());
                if (extraInfo.pinRequired()) {
                    if (this.KS.isStation) {
                        this.keySession.sendKeyDisable();
                    }
                    try {
                        this.processPIN(extraInfo.getPINBytes());
                    }
                    catch (InputCanceledException ice) {
                        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.pincancel"));
                        throw ice;
                    }
                }
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.sendconfig"));
                this.flag.check();
                events = this.keySession.sendKeyConfigGetEvents(keyConfigFile, WorkerThread.configBytesFromServer);
                if (events == null) {
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.key.remove5"));
                    this.uiHandler.postError(AppRenderer.instance.render("message.key.commproblem"));
                    if (this.KS.isStation) {
                        KeySessionHandler.sendKeyReady();
                    }
                    return;
                }
                this.webService.saveKeyEvents(events, null, this.currentKeyID);
                events = null;
                configNeeded = this.wasDisabled = extraInfo.getDeletedFlag();
                this.lastKeyInfo = new LastKeyInfo(this.KS, extraInfo.getKeyName());
            }
            if ((this.KS.getSWV() & 127) > 22 || this.KS.getPID() >= 106) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.verify"));
                start = System.currentTimeMillis();
                Thread.sleep(2000L);
                do {
                    this.flag.check();
                    this.KS = this.fileManager.readStatus();
                    configBytesFromStatus = this.KS.getFileConfigBytes();
                    if (Arrays.equals(configBytesFromStatus, WorkerThread.configBytesFromServer)) {
                        CyberLink.lastConfigID = Util.BEBytesToInt(WorkerThread.configBytesFromServer);
                        CyberLink.writePrefs();
                        break block74;
                    }
                    Thread.sleep(1000L);
                } while (System.currentTimeMillis() - start <= 15000L);
                throw new InterruptedException("timeout");
            }
        }
        if (this.KS.isStation) {
            v4 = this;
            v4.keySession.sendKeyReady();
        }
        this.uiHandler.setPRBarIndeterminate(false);
        this.uiHandler.postOperation(AppRenderer.instance.render("message.key.configured"));
        this.uiHandler.postStatus("");
        if (CyberLink.noPrompt) {
            this.NM.sendKeyVerify();
        }
        if (this.wasDisabled) {
            if (this.KS.isGrandMaster) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.master.reset"));
            } else {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.disabled"));
            }
        } else {
            this.uiHandler.updateProgressBar(0);
            if ((this.KS.getSWV() & 127) <= 12 && this.KS.getPID() < 106) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.remove8"));
            } else if (!(this.KS.isStealthKey || this.KS.isUSBKey || this.KS.isBluetoothKey)) {
                this.uiHandler.postStatus(AppRenderer.instance.render("status.key.remove"));
            } else if (this.KS.isStation && (this.KS.isStealthKey || this.KS.isBluetoothKey) || this.KS.isUSBKey) {
                this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.status"));
            } else {
                this.uiHandler.postStatus(AppRenderer.instance.render("status.key.remove"));
            }
        }
    }

    private boolean isUSBKeyWithCable(KeyStatus KS) {
        if (KS.isUSBKey) {
            return KS.getLinkID().startsWith("Z");
        }
        return false;
    }

    private int getUSBKeyFirmwareVersion(int swv, int hwv) {
        String swPart = Integer.toString(swv);
        String hwPart = Integer.toString(hwv);
        if (hwPart.length() == 1) {
            hwPart = "0" + hwPart;
        }
        return Integer.parseInt(swPart + hwPart);
    }

    private int[] getUSBKeyRequestedVersions() {
        int[] versions = new int[2];
        switch (this.requestedVersion) {
            case 203: {
                versions[0] = 2;
                versions[1] = 3;
                break;
            }
            case 208: {
                versions[0] = 2;
                versions[1] = 8;
                break;
            }
            case 303: {
                versions[0] = 3;
                versions[1] = 3;
                break;
            }
            case 305: {
                versions[0] = 3;
                versions[1] = 5;
                break;
            }
            case 307: {
                versions[0] = 3;
                versions[1] = 7;
                break;
            }
            case 308: {
                versions[0] = 3;
                versions[1] = 8;
                break;
            }
            case 309: {
                versions[0] = 3;
                versions[1] = 9;
                break;
            }
            case 310: {
                versions[0] = 3;
                versions[1] = 10;
                break;
            }
            case 311: {
                versions[0] = 3;
                versions[1] = 11;
                break;
            }
            case 312: {
                versions[0] = 3;
                versions[1] = 12;
                break;
            }
            case 314: {
                versions[0] = 3;
                versions[1] = 14;
                break;
            }
            case 315: {
                versions[0] = 3;
                versions[1] = 15;
                break;
            }
            case 800: {
                versions[0] = 8;
                versions[1] = 0;
                break;
            }
            case 801: {
                versions[0] = 8;
                versions[1] = 1;
            }
        }
        return versions;
    }

    private void checkCanTouchKey(byte[] keyStatus, String keySerial) throws Exception {
        while (true) {
            try {
                this.webService.checkCanTouchKey(keyStatus);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(this.webService, keyStatus);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    System.out.println("ISSUE GM KEY");
                    this.issueKey(this.webService, keyStatus, keySerial);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private void synchronizeKey(String keySerial, byte[] events, byte[] lockListBytes, byte[] keyStatus, int expTime, int programmerCode) throws Exception {
        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.audit"));
        int mismatchCount = 0;
        while (true) {
            this.flag.check();
            try {
                byte[] cmd = this.webService.getSynchronizationCmd(keySerial, events, lockListBytes, keyStatus, expTime, programmerCode);
                this.uiHandler.postStatus(AppRenderer.instance.render("message.key.sync"));
                this.keySession.sendKeyConfigGetEvents(cmd);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED || ex.errorCode == ServiceException.ErrorCode.KEY_DATA_MISMATCH || ex.errorCode == ServiceException.ErrorCode.BAD_DATA_FILE) {
                    if (++mismatchCount == 1) {
                        this.initializeKey(this.webService, keySerial, keyStatus);
                        Thread.sleep(500L);
                        continue;
                    }
                    throw ex;
                }
                if (ex.errorCode == ServiceException.ErrorCode.NEED_LOGIN_NUM_4_EVENTS) {
                    this.uiHandler.postError(AppRenderer.instance.render("message.grandmaster.login.required"));
                    try {
                        programmerCode = this.getJobOrAdminNumber(true);
                        this.uiHandler.postError("");
                    }
                    catch (InputCanceledException ice) {
                        throw new InputCanceledException("LOGIN_NUMBER_REQUIRED");
                    }
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public void doProgressBar() throws InterruptedException {
        int eventCount = this.KS.getNumEvents();
        int now = Util.getVidexTime();
        int elapsedTimeInSeconds = now - this.keySession.expectedEventTime;
        if (this.KS.getLinkID().startsWith("Z")) {
            eventCount = 0;
        }
        int sleepTime = this.KS.isEncoder ? new Double(1000.0 * ((double)eventCount * 0.005 + 5.0)).intValue() : new Double(1000.0 * ((double)eventCount * 0.001 + 4.0)).intValue();
        if ((sleepTime -= 1000 * elapsedTimeInSeconds) > 0) {
            this.uiHandler.setPRBarMinMaxValue(0, sleepTime);
            this.uiHandler.setPRBarIndeterminate(false);
            this.uiHandler.updateProgressBar(0);
            int sleepIncrement = 250;
            while (sleepTime > sleepIncrement && !this.flag.abort) {
                Thread.sleep(sleepIncrement);
                sleepTime -= sleepIncrement;
                this.uiHandler.advancePRBarValueByAmount(sleepIncrement);
            }
            if (sleepTime > 0) {
                Thread.sleep(sleepTime);
                this.uiHandler.advancePRBarValueByAmount(sleepTime);
            }
        }
        this.uiHandler.setPRBarIndeterminate(true);
    }

    public byte[] getVaultNetworkSettings() throws Exception {
        return this.keySession.getNetworkSettings();
    }

    public byte[] getWSNetworkSettings() throws Exception {
        return this.keySession.getWSNetworkSettings();
    }

    private void doGrandMasterFactorySettings(byte[] keyStatus) throws Exception {
        byte[] GMInfoCommand = this.getGMInfoCommand(this.webService, keyStatus, this.currentKeyID);
        byte[] GMInfo = this.keySession.sendKeyConfigGetEvents(GMInfoCommand);
        byte[] GMFactoryConfig = this.webService.getGMFactoryConfig(this.currentKeyID, keyStatus, GMInfo);
        this.keySession.sendKeyConfigOnly(GMFactoryConfig);
        this.uiHandler.setPRBarIndeterminate(false);
        this.uiHandler.updateProgressBar(100);
        this.uiHandler.postOperation(AppRenderer.instance.render("message.master.reset"));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.master.remove"));
        Thread.sleep(2000L);
    }

    public void setUpgradeValues(boolean doUpdate, int version) {
        this.doUpdate = doUpdate;
        this.requestedVersion = version;
    }

    private void upgradeFirmware(KeyStatus ks, byte[] events, byte[] locklist, boolean doLatestFirmware) throws Exception {
        int tries;
        for (tries = 2; tries > 0; --tries) {
            this.flag.check();
            byte[] FWBytes = this.webService.getFirmware(this.requestedVersion, ks.getRawData(), events, locklist, doLatestFirmware);
            Thread.sleep(2000L);
            this.fileManager.writeFirmware(FWBytes);
            this.uiHandler.postOperation(AppRenderer.instance.render("message.recharge.update"));
            this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.updatewait"));
            Thread.sleep(16000L);
            this.fileManager.deleteFirmwareConfig();
            this.fileManager.deleteKeyConfig();
            boolean success = ks.isUSBKey ? this.verifyUSBKeyUpdate() : this.verifyUpdate();
            if (!success) {
                continue;
            }
            this.uiHandler.postOperation(AppRenderer.instance.render("message.recharge.updatefinish"));
            this.uiHandler.postStatus("");
            break;
        }
        if (tries == 0) {
            throw new InterruptedException(AppRenderer.instance.render("message.recharge.updatefail"));
        }
    }

    private boolean verifyUpdate() throws Exception {
        this.KS = this.keySession.connectToKey();
        return this.KS.getSWV() == this.requestedVersion && this.KS.getSWV() == this.KS.getkeyConfigBytes()[1];
    }

    private boolean verifyUSBKeyUpdate() throws Exception {
        Thread.sleep(6000L);
        KeyStatus KS = this.fileManager.readStatus();
        int[] versions = this.getUSBKeyRequestedVersions();
        return KS.getSWV() == versions[0] && KS.getHWV() == versions[1];
    }

    private boolean isVaultNetworkResponse(byte[] eventFile) {
        return eventFile[0] != 0 && eventFile[48] == 127;
    }

    private int getJobOrAdminNumber(boolean isInvalid) throws InputCanceledException {
        boolean isPro = this.serverProps.productLevel == 2;
        int jobOrAdminNumber = 0;
        int codeType = 0;
        codeType = this.KS.isProgrammer ? 3 : 5;
        if (CyberLink.noPrompt) {
            jobOrAdminNumber = this.NM.sendPromptRequest(NotificationManager.promptType.JOBADMIN, isInvalid);
            if (jobOrAdminNumber == -1) {
                jobOrAdminNumber = Integer.parseInt(this.uiHandler.getUserInput(codeType, isInvalid, isPro));
            }
        } else {
            jobOrAdminNumber = Integer.parseInt(this.uiHandler.getUserInput(codeType, isInvalid, isPro));
        }
        return jobOrAdminNumber;
    }

    private void configureWebStation(String linkID, boolean isVault) throws Exception {
        while (true) {
            try {
                byte[] webConfig = this.webService.getWebStationConfig(linkID);
                if (isVault) {
                    this.uiHandler.postOperation(AppRenderer.instance.render("message.vault.configure"));
                } else {
                    this.uiHandler.postOperation(AppRenderer.instance.render("message.web.configure"));
                }
                this.uiHandler.postStatus(AppRenderer.instance.render("message.wait"));
                byte[] eventFile = this.keySession.sendKeyConfigGetEvents(webConfig);
                this.webService.sendWebStationConfigConfirm(linkID, eventFile);
                KeySessionHandler.needsWebConfig = false;
                StatusProcessor.pausingForWebConfig = false;
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    throw ex;
                }
                this.issueCellnode(this.webService, this.KS.getRawData());
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getEventRequest(CyberLinkClient webService, String keySerial, byte[] keyStatus) throws Exception {
        while (true) {
            try {
                return webService.getEventRequest(keySerial, keyStatus);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(webService, keyStatus);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(webService, keyStatus, keySerial);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(webService, keySerial, keyStatus);
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getLockListRequestCommand(String keySerial, byte[] keyStatus) throws Exception {
        while (true) {
            try {
                return this.webService.getLockListRequestCommand(keySerial, keyStatus);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(this.webService, keyStatus);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    this.issueKey(this.webService, keyStatus, keySerial);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_UNINITIALIZED) {
                    this.initializeKey(this.webService, keySerial, keyStatus);
                    Thread.sleep(500L);
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getKeyConfig(String keySerial, KeyStatus KS, int programmerCode, ConfigInfo extraInfo) throws Exception {
        String PIN = null;
        while (true) {
            try {
                this.uiHandler.postOperation(AppRenderer.instance.render("message.key.process") + " " + keySerial);
                this.uiHandler.postStatus(AppRenderer.instance.render("message.status.server_comm"));
                return this.webService.getKeyConfig2(KS.getRawData(), programmerCode, extraInfo, PIN);
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    this.issueCellnode(this.webService, KS.getRawData());
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.KEY_DOESNT_EXIST) {
                    byte[] freshStatus;
                    if (this.isUSBKeyWithCable(KS)) {
                        freshStatus = KS.getRawData();
                    } else {
                        KeyStatus keyStatus = KeySessionHandler.getFreshStatusFile();
                        freshStatus = keyStatus.getRawData();
                    }
                    this.issueKey(this.webService, freshStatus, keySerial);
                    continue;
                }
                if (ex.errorCode == ServiceException.ErrorCode.PIN_INPUT_REQUIRED) {
                    try {
                        PIN = this.getNewPIN();
                        this.uiHandler.postError("");
                    }
                    catch (InputCanceledException ice) {
                        throw new InputCanceledException("NEW_PIN_REQUIRED");
                    }
                } else {
                    throw ex;
                }
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void initializeKey(CyberLinkClient webService, String currentKey, byte[] status) throws Exception, ServiceException {
        byte[] GMInfo = null;
        while (true) {
            try {
                if (this.KS.isGrandMaster) {
                    byte[] GMInfoCommand = this.getGMInfoCommand(webService, status, currentKey);
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.master.inspect"));
                    GMInfo = this.keySession.sendKeyConfigGetEvents(GMInfoCommand);
                }
                webService.initializeKey(currentKey, status, GMInfo);
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    throw ex;
                }
                this.issueCellnode(webService, status);
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private byte[] getGMInfoCommand(CyberLinkClient webService, byte[] status, String currentKey) throws Exception {
        while (true) {
            try {
                return webService.getGMBytesRequestCommand(currentKey);
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) {
                    throw ex;
                }
                this.issueCellnode(webService, status);
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    public void sendCardData() throws IOException {
        this.webService.sendCardData(this.lastCardInfo);
    }

    private void issueCellnode(CyberLinkClient webService, byte[] status) throws Exception {
        boolean isInvalid = false;
        boolean triedAutoIssueWithKey = false;
        KeyStatus KS = new KeyStatus(status);
        while (true) {
            try {
                String issuePassword = System.getProperty("issuePassword");
                if (issuePassword == null) {
                    issuePassword = System.getProperty("jnlp.issuePassword");
                }
                if (issuePassword != null && issuePassword.trim().length() > 0) {
                    webService.issueCellNode(issuePassword, status);
                } else if (KS.isVault || KS.isWEBStation) {
                    String numberStr;
                    if (CyberLink.noPrompt) {
                        int temp = this.NM.sendPromptRequest(NotificationManager.promptType.CELLISSUE, isInvalid);
                        if (temp == -1) {
                            numberStr = this.uiHandler.getUserInput(10, true, false);
                            webService.issueCellNode(new Integer(numberStr), status);
                        } else {
                            numberStr = new Integer(temp).toString();
                            isInvalid = true;
                        }
                    } else {
                        numberStr = this.uiHandler.getUserInput(10, true, false);
                        webService.issueCellNode(new Integer(numberStr), status);
                    }
                    this.lastKnownIssueNumber = numberStr;
                } else if (ALLOWISSUEWITHKEY && !triedAutoIssueWithKey) {
                    triedAutoIssueWithKey = true;
                    if (KS.getKeyID().equals("K00000000")) {
                        return;
                    }
                    webService.issueCellNode(KS.getKeyID(), status);
                } else {
                    String numberStr;
                    if (CyberLink.noPrompt) {
                        int temp = this.NM.sendPromptRequest(NotificationManager.promptType.CELLISSUE, isInvalid);
                        if (temp == -1) {
                            numberStr = this.uiHandler.getUserInput(10, true, false);
                            webService.issueCellNode(new Integer(numberStr), status);
                        } else {
                            numberStr = new Integer(temp).toString();
                            isInvalid = true;
                        }
                    } else {
                        numberStr = this.uiHandler.getUserInput(10, true, false);
                        webService.issueCellNode(new Integer(numberStr), status);
                    }
                    this.lastKnownIssueNumber = numberStr;
                }
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode != ServiceException.ErrorCode.UNKNOWN_ISSUE_NUMBER && ex.errorCode != ServiceException.ErrorCode.AUTO_ISSUE_DENIED) {
                    throw ex;
                }
                System.clearProperty("issuePassword");
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    public void confirmCyberLinkExistence(KeyStatus status) throws Exception {
        while (true) {
            try {
                this.webService.confirmStatus(status.getRawData());
                return;
            }
            catch (ServiceException ex) {
                block5: {
                    block6: {
                        block4: {
                            if (ex.errorCode != ServiceException.ErrorCode.CELLNODE_DOESNT_EXIST) break block4;
                            this.issueCellnode(this.webService, status.getRawData());
                            if (ALLOWISSUEWITHKEY) break block5;
                            break block6;
                        }
                        throw ex;
                    }
                    this.uiHandler.postStatus(AppRenderer.instance.render("message.cyberlink.issued"));
                    Thread.sleep(2000L);
                    if (!this.flag.abort) continue;
                }
                if (ALLOWISSUEWITHKEY) {
                    return;
                }
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void issueKey(CyberLinkClient webService, byte[] keyStatus, String keySerial) throws Exception {
        boolean isInvalid = false;
        String numberStr = "-1";
        byte[] GMInfo = null;
        if (this.KS.isGrandMaster) {
            byte[] GMInfoCommand = this.getGMInfoCommand(webService, keyStatus, keySerial);
            this.uiHandler.postStatus(AppRenderer.instance.render("message.master.inspect"));
            GMInfo = this.keySession.sendKeyConfigGetEvents(GMInfoCommand);
        } else if (this.serverProps.productLevel == 3) {
            throw new ServiceException(ServiceException.ErrorCode.KEY_DOESNT_EXIST);
        }
        while (true) {
            try {
                webService.issueKey(numberStr, keyStatus, keySerial, GMInfo);
                return;
            }
            catch (ServiceException ex) {
                if (ex.errorCode == ServiceException.ErrorCode.UNKNOWN_ISSUE_NUMBER) {
                    if (CyberLink.noPrompt) {
                        int temp = this.NM.sendPromptRequest(NotificationManager.promptType.KEYMISSIONISSUE, isInvalid);
                        if (temp == -1) {
                            numberStr = this.uiHandler.getUserInput(1, isInvalid, this.serverProps.productLevel == 2);
                            isInvalid = true;
                            continue;
                        }
                        numberStr = new Integer(temp).toString();
                        isInvalid = true;
                        continue;
                    }
                    if (this.lastKnownIssueNumber != null) {
                        numberStr = this.lastKnownIssueNumber;
                        this.lastKnownIssueNumber = null;
                        isInvalid = false;
                        continue;
                    }
                    numberStr = this.uiHandler.getUserInput(1, isInvalid, this.serverProps.productLevel == 2);
                    isInvalid = true;
                    continue;
                }
                throw ex;
                if (!this.flag.abort) continue;
                throw new Exception("aborted");
            }
            break;
        }
    }

    private void processPIN(byte[] requiredPIN) throws Exception {
        boolean isInvalid = false;
        do {
            int temp;
            String pinStr = CyberLink.noPrompt ? ((temp = this.NM.sendPromptRequest(NotificationManager.promptType.PIN, isInvalid)) == -1 ? this.uiHandler.getUserInput(2, isInvalid, false) : new Integer(temp).toString()) : this.uiHandler.getUserInput(2, isInvalid, false);
            byte[] pin = Util.stringPinToBytes(pinStr);
            if (Arrays.equals(pin, requiredPIN)) {
                return;
            }
            isInvalid = true;
        } while (!this.flag.abort);
        throw new Exception("aborted");
    }

    private String getNewPIN() throws Exception {
        boolean isInvalid = false;
        do {
            String pinStr = null;
            if (!CyberLink.noPrompt) {
                pinStr = this.uiHandler.getUserInput(7, isInvalid, false);
            }
            if (pinStr != null) {
                return pinStr;
            }
            isInvalid = true;
        } while (!this.flag.abort);
        throw new Exception("aborted");
    }

    public void stopWorking() {
        this.stop = true;
        this.flag.abort = true;
    }

    public void signalReset() {
        this.flag.abort = true;
    }

    public String getConnectedEncoderID() {
        if (this.fileManager != null) {
            return this.fileManager.getLinkID();
        }
        return null;
    }

    public boolean stopping() {
        return this.stop;
    }

    static {
        isRFIDMode = false;
    }
}

