/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Util {
    public static final int beginTimeSecs = 820454400;
    static final int VIDEX_MAX_DATE_UTC = 2147385600;

    public static void Log(String s) {
        String fileName = "USBKEYEVENTDEBUG.txt";
        try {
            FileWriter fw = new FileWriter(fileName, true);
            fw.write(s + "\n");
            fw.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : bytes) {
            String temp = Integer.toHexString(b2 & 0xFF).toUpperCase(Locale.US);
            if (temp.length() == 1) {
                temp = '0' + temp;
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public static void printHexBytes(byte[] b2) {
        int l = b2.length;
        if (l == 0) {
            System.out.println("no bytes to print!");
            return;
        }
        for (int k = 0; k < l; ++k) {
            if (k % 16 == 0 && k != 0) {
                System.out.print("\n");
            }
            Util.printHexByte(b2[k]);
            System.out.print(" ");
        }
        System.out.print("\n");
    }

    public static void printHexByte(byte b2) {
        String s = Integer.toHexString(b2 & 0xFF).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        System.out.print(s);
    }

    public static String makeKeyIDFromLong(long keyIDLong) {
        byte[] temp = Util.longToFourBEBytes(keyIDLong);
        return Util.makeStringID("K", temp);
    }

    public static String makeStringID(String productID, byte[] kid) {
        String fourth;
        String third;
        String second;
        String ID = productID;
        String first = Integer.toHexString(kid[0] & 0xFF).toUpperCase();
        if (first.length() == 1) {
            first = "0" + first;
        }
        if ((second = Integer.toHexString(kid[1] & 0xFF).toUpperCase()).length() == 1) {
            second = "0" + second;
        }
        if ((third = Integer.toHexString(kid[2] & 0xFF).toUpperCase()).length() == 1) {
            third = "0" + third;
        }
        if ((fourth = Integer.toHexString(kid[3] & 0xFF).toUpperCase()).length() == 1) {
            fourth = "0" + fourth;
        }
        ID = ID + first + second + third + fourth;
        return ID;
    }

    public static byte[] intToTwoBEBytes(int i2) {
        byte b1 = (byte)(i2 >> 8 & 0xFF);
        byte b2 = (byte)(i2 & 0xFF);
        return new byte[]{b1, b2};
    }

    public static byte[] longToEightBEBytes(long i2) {
        byte[] byteArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.putLong(i2);
        int j2 = 0;
        for (int k = 0; k < 8; ++k) {
            byteArray[j2++] = bbuf.get(k);
        }
        return byteArray;
    }

    public static byte[] longToFourBEBytes(long i2) {
        byte[] byteArray = new byte[]{0, 0, 0, 0};
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.putLong(i2);
        int j2 = 0;
        for (int k = 4; k < 8; ++k) {
            byteArray[j2++] = bbuf.get(k);
        }
        return byteArray;
    }

    public static long fourBEBytesToLong(byte[] b2) {
        byte[] bb = new byte[]{b2[3], b2[2], b2[1], b2[0], 0, 0, 0, 0};
        return Util.LEBytesToLong(bb);
    }

    public static long LEBytesToLong(byte[] b2) {
        if (b2.length != 8) {
            return 0L;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        return bbuf.getLong();
    }

    public static short BEBytesToShort(byte[] b2) {
        if (b2.length != 2) {
            return 0;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        return bbuf.getShort();
    }

    public static int LEBytesToInt(byte b1, byte b2) {
        byte[] leBytes = new byte[4];
        leBytes[0] = b1;
        leBytes[1] = b2;
        ByteBuffer bbuf = ByteBuffer.wrap(leBytes);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        return bbuf.getInt();
    }

    public static int twoBEBytesToInt(byte[] b2) {
        byte[] bb = new byte[]{0, 0, b2[0], b2[1]};
        return Util.BEBytesToInt(bb);
    }

    public static int twoLEBytesToInt(byte[] b2) {
        byte[] bb = new byte[]{0, 0, b2[1], b2[0]};
        return Util.BEBytesToInt(bb);
    }

    public static int BEBytesToInt(byte[] b2) {
        if (b2.length != 4) {
            return 0;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(b2);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        return bbuf.getInt();
    }

    public static String getKey() {
        return System.getProperty("user.name") + "Z4NeedlePoint";
    }

    public static long fourLEBytesToLong(byte[] b2) {
        byte[] bb = new byte[]{b2[0], b2[1], b2[2], b2[3], 0, 0, 0, 0};
        return Util.LEBytesToLong(bb);
    }

    public static int getVidexTime() {
        GregorianCalendar now = new GregorianCalendar();
        long tempSecs = now.getTimeInMillis() / 1000L;
        long videxSecs = tempSecs - 820454400L;
        if (videxSecs > 2147385600L) {
            return 2147385600;
        }
        return (int)videxSecs;
    }

    public static int secondsUTCFromUTCGC(GregorianCalendar G) {
        G.setTimeZone(TimeZone.getTimeZone("GMT"));
        long tempsecs = G.getTimeInMillis() / 1000L;
        long videxsecs = tempsecs - 820454400L;
        if (videxsecs > 2147385600L) {
            return 2147385600;
        }
        return (int)videxsecs;
    }

    public static int decodeOffset(int encodedOffset) {
        if (encodedOffset == 0) {
            return 0;
        }
        short calcOff = encodedOffset < 49 ? (short)(-(encodedOffset * 15)) : (short)((96 - encodedOffset) * 15);
        return calcOff;
    }

    public static byte[] stringPinToBytes(String pin) {
        ByteBuffer asciiBytes = Charset.forName("ASCII").encode(pin);
        try {
            return MessageDigest.getInstance("SHA-1").digest(asciiBytes.array());
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static int mkBin(char ch) {
        if (ch == '0') {
            ch = '\u0000';
        }
        if (ch == '1') {
            ch = '\u0001';
        }
        if (ch == '2') {
            ch = (char)2;
        }
        if (ch == '3') {
            ch = (char)3;
        }
        if (ch == '4') {
            ch = (char)4;
        }
        if (ch == '5') {
            ch = (char)5;
        }
        if (ch == '6') {
            ch = (char)6;
        }
        if (ch == '7') {
            ch = (char)7;
        }
        if (ch == '8') {
            ch = (char)8;
        }
        if (ch == '9') {
            ch = (char)9;
        }
        if (ch == 'A' || ch == 'a') {
            ch = (char)10;
        }
        if (ch == 'B' || ch == 'b') {
            ch = (char)11;
        }
        if (ch == 'C' || ch == 'c') {
            ch = (char)12;
        }
        if (ch == 'D' || ch == 'd') {
            ch = (char)13;
        }
        if (ch == 'E' || ch == 'e') {
            ch = (char)14;
        }
        if (ch == 'F' || ch == 'f') {
            ch = (char)15;
        }
        return ch;
    }

    public static byte[] binaryToHexAscii(byte[] b2) {
        int i2 = 0;
        int count = b2.length;
        byte[] retVal = new byte[count * 2];
        for (int k = 0; k < count; ++k) {
            String s = Integer.toHexString(b2[k] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                s = "0" + s;
            }
            retVal[i2++] = (byte)s.charAt(0);
            retVal[i2++] = (byte)s.charAt(1);
        }
        return retVal;
    }

    public static byte[] hexAsciiToBinary(byte[] b2) {
        int i2 = 0;
        int count = b2.length;
        byte[] retVal = new byte[count / 2];
        for (int k = 0; k < count; k += 2) {
            char first = (char)b2[k];
            char second = (char)b2[k + 1];
            retVal[i2++] = (byte)((Util.mkBin(first) << 4) + Util.mkBin(second));
        }
        return retVal;
    }

    public static short ByteToShort(byte b2) {
        return Util.getUnsignedByte(b2);
    }

    public static short getUnsignedByte(byte _b) {
        return (short)(_b & 0xFF);
    }

    public static int getUnsignedShort(short _s) {
        return _s & 0xFFFF;
    }

    public static byte[] makeCRC16(byte[] b2, int length) {
        byte[] newFileBytes = new byte[length + 2];
        int item0 = -1;
        int item1 = -1;
        for (int k = 0; k < length; ++k) {
            int temp = newFileBytes[k] = b2[k];
            temp = (byte)(temp ^ item0);
            item0 = item1;
            item1 = temp;
            item1 = item1 < 0 ? (int)((byte)(item1 ^ (byte)(item1 + 256 << 4))) : (int)((byte)(item1 ^ (byte)(item1 << 4)));
            item0 = item1 < 0 ? (int)((byte)(item0 ^ (byte)(item1 + 256 >>> 4))) : (int)((byte)(item0 ^ (byte)(item1 >>> 4)));
            item0 = item1 < 0 ? (int)((byte)(item0 ^ (byte)(item1 + 256 << 3))) : (int)((byte)(item0 ^ (byte)(item1 << 3)));
            item1 = item1 < 0 ? (int)((byte)(item1 ^ (byte)(item1 + 256 >>> 5))) : (int)((byte)(item1 ^ (byte)(item1 >>> 5)));
        }
        newFileBytes[k++] = (byte)(~item0);
        newFileBytes[k++] = (byte)(~item1);
        return newFileBytes;
    }

    public static byte CRC8(byte[] b2, int count) {
        short crc = 0;
        if (count > b2.length) {
            return 0;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            short byte2 = b2[i2];
            for (int j2 = 0; j2 < 8; ++j2) {
                short f2 = (short)(1 & (byte2 ^ crc));
                crc = (short)(crc >> 1);
                byte2 = (short)(byte2 >> 1);
                if (f2 == 0) continue;
                crc = (short)(crc ^ 0x8C);
            }
        }
        return (byte)crc;
    }

    public static boolean checkIrDaCRC16(byte[] b2, int length) {
        int item0 = -1;
        int item1 = -1;
        for (int k = 0; k < length; ++k) {
            int temp = b2[k];
            temp = (byte)(temp ^ item0);
            item0 = item1;
            item1 = temp;
            item1 = item1 < 0 ? (int)((byte)(item1 ^ (byte)(item1 + 256 << 4))) : (int)((byte)(item1 ^ (byte)(item1 << 4)));
            item0 = item1 < 0 ? (int)((byte)(item0 ^ (byte)(item1 + 256 >>> 4))) : (int)((byte)(item0 ^ (byte)(item1 >>> 4)));
            item0 = item1 < 0 ? (int)((byte)(item0 ^ (byte)(item1 + 256 << 3))) : (int)((byte)(item0 ^ (byte)(item1 << 3)));
            item1 = item1 < 0 ? (int)((byte)(item1 ^ (byte)(item1 + 256 >>> 5))) : (int)((byte)(item1 ^ (byte)(item1 >>> 5)));
        }
        return item0 == -72 && item1 == -16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBinaryFileToDisk(File fileName, byte[] b2) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(b2);
        }
        catch (Exception e2) {
            System.out.println("error while writing file to disk: " + e2.toString());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("error while closing config file: " + ioe.toString());
            }
        }
    }
}

