/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.WorkerThread;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateDialog
extends JDialog {
    private String[] serverVersions;
    private WorkerThread wt;
    private JButton proceedButton;
    private JButton cancelButton;
    private JComboBox versionCombo;
    private JLabel titleLabel;
    private JLabel downloadVersionLabel;
    private JLabel currentVersionLabel;
    private JLabel currentVersion;
    private JPanel buttonPanel = new JPanel(new FlowLayout(1));
    private JPanel titlePanel = new JPanel(new FlowLayout(1));
    private JPanel currentPanel = new JPanel(new FlowLayout(1));
    private JPanel installPanel = new JPanel(new FlowLayout(1));

    public UpdateDialog(Frame parent, boolean modal, String SWV, int PID, WorkerThread wt) {
        super(parent, modal);
        if (PID == 108) {
            this.serverVersions = new String[]{"16", "15", "14", "12", "10", "8", "7"};
        } else if (PID == 109) {
            this.serverVersions = new String[]{"16", "15", "12", "11", "10", "9", "8", "7"};
        } else if (PID == 110) {
            this.serverVersions = new String[]{"19", "18", "16", "15", "14"};
        } else if (PID == 113) {
            this.serverVersions = new String[]{"315", "314", "311", "310", "309", "308", "307", "305", "303", "800", "801"};
        }
        this.initComponents();
        this.wt = wt;
        this.currentVersion.setText(SWV);
        this.pack();
    }

    private void initComponents() {
        this.proceedButton = new JButton();
        this.cancelButton = new JButton();
        this.titleLabel = new JLabel();
        this.versionCombo = new JComboBox();
        this.downloadVersionLabel = new JLabel();
        this.currentVersionLabel = new JLabel();
        this.currentVersion = new JLabel();
        this.setDefaultCloseOperation(2);
        this.proceedButton.setText(AppRenderer.instance.render("button.proceed"));
        this.proceedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.ProceedAction(evt);
            }
        });
        this.cancelButton.setText(AppRenderer.instance.render("button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpdateDialog.this.CancelAction(evt);
            }
        });
        this.titleLabel.setFont(new Font("Tahoma", 1, 14));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(AppRenderer.instance.render("firmware.installer.title"));
        this.versionCombo.setModel(new DefaultComboBoxModel<String>(this.serverVersions));
        this.downloadVersionLabel.setText(AppRenderer.instance.render("firmware.installer.info") + " ");
        this.currentVersionLabel.setText(AppRenderer.instance.render("firmware.installer.version") + " ");
        this.titlePanel.add(this.titleLabel);
        this.currentPanel.add(this.currentVersionLabel);
        this.currentPanel.add(this.currentVersion);
        this.installPanel.add(this.downloadVersionLabel);
        this.installPanel.add(this.versionCombo);
        this.buttonPanel.add(this.proceedButton);
        this.buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridLayout(4, 1));
        contentPane.add(this.titlePanel);
        contentPane.add(this.currentPanel);
        contentPane.add(this.installPanel);
        contentPane.add(this.buttonPanel);
    }

    private void CancelAction(ActionEvent evt) {
        this.wt.setUpgradeValues(false, 0);
        this.dispose();
    }

    private void ProceedAction(ActionEvent evt) {
        try {
            int version = Integer.parseInt((String)this.versionCombo.getSelectedItem());
            this.wt.setUpgradeValues(true, version);
            this.dispose();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }
}

