/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.BaseDialog;
import cyberlink.CyberLink;
import cyberlink.GenericIssueDialog;
import cyberlink.GrandmasterDialog;
import cyberlink.IRLinkIssueDialog;
import cyberlink.InputCanceledException;
import cyberlink.KeyIssueDialog;
import cyberlink.MainFrame;
import cyberlink.NewPINDialog;
import cyberlink.PinNumberDialog;
import cyberlink.ProgrammerDialog;
import cyberlink.SKCabinetIssueDialog;
import cyberlink.StationIssueDialog;
import cyberlink.USBKeyClientIssueDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UIHandler {
    public static final int SERVER_URL = 0;
    public static final int KEY_ISSUE_NUMBER = 1;
    public static final int PIN_NUMBER = 2;
    public static final int PROGRAMMER_CODE = 3;
    public static final int CN_ISSUE_NUMBER = 4;
    public static final int GRANDMASTER_CODE = 5;
    public static final int ST_ISSUE_NUMBER = 6;
    public static final int NEW_PIN_NUMBER = 7;
    public static final int SKL_ISSUE_NUMBER = 8;
    public static final int USBKEYCLIENT_ISSUE_NUMBER = 9;
    public static final int GENERIC_ISSUE_NUMBER = 10;
    public static final int KEYTYPE_USER = 1;
    public static final int KEYTYPE_PROGRAMMER = 2;
    public static final int KEYTYPE_GRANDMASTER = 3;
    private MainFrame frame;
    private int keyType;
    private String lowVoltage;
    private Timer timer;
    ActionListener FlashPerformer = new ActionListener(){
        boolean off = true;

        public void actionPerformed(ActionEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (this.isOff()) {
                        ((UIHandler)UIHandler.this).frame.lblLowVoltage.setText(UIHandler.this.lowVoltage);
                    } else {
                        ((UIHandler)UIHandler.this).frame.lblLowVoltage.setText(null);
                    }
                }
            });
        }

        private boolean isOff() {
            this.off = !this.off;
            return this.off;
        }
    };

    public UIHandler(MainFrame frame) {
        this.frame = frame;
        int delay = 500;
        this.timer = new Timer(delay, this.FlashPerformer);
    }

    public void startTimer() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void stopTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.lblLowVoltage.setText(null);
            }
        });
    }

    public void postOperation(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.lblOperation.setText(msg);
            }
        });
    }

    public void postStatus(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.lblStatus.setText(msg);
            }
        });
    }

    public void postKeyname(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.lblKeyname.setText(msg);
            }
        });
    }

    public void postCardID(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.lblKeyname.setText(msg);
            }
        });
        if (message.length() > 0) {
            this.smart_sleep(2000L);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((UIHandler)UIHandler.this).frame.lblKeyname.setText("");
                }
            });
        }
    }

    private void smart_sleep(long millis) {
        while (millis > 0L && !CyberLink.wt.stopping()) {
            try {
                Thread.sleep(125L);
                millis -= 125L;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void postError(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.btnCancel.setVisible(false);
                ((UIHandler)UIHandler.this).frame.txtErrors.setText(msg);
            }
        });
        if (message.length() > 0) {
            this.smart_sleep(3000L);
        }
    }

    public void postVoltage(String voltage) {
        final String msg = voltage;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (msg.contains("LOW BATTERY")) {
                    String[] parts = msg.split("-");
                    ((UIHandler)UIHandler.this).frame.lblVoltage.setText(parts[0].trim());
                    UIHandler.this.lowVoltage = " " + parts[1].trim();
                    UIHandler.this.startTimer();
                } else {
                    ((UIHandler)UIHandler.this).frame.lblVoltage.setText(msg);
                }
            }
        });
    }

    public void appendError(String message) {
        final String msg = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.txtErrors.setText(((UIHandler)UIHandler.this).frame.txtErrors.getText() + '\n' + msg);
            }
        });
    }

    public void allowAbort(boolean allowed) {
        final boolean value = allowed;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((UIHandler)UIHandler.this).frame.pnlCancel.add(((UIHandler)UIHandler.this).frame.btnCancel);
                ((UIHandler)UIHandler.this).frame.btnCancel.setVisible(value);
            }
        });
    }

    public void updateProgressBar(int value) {
        final int updateVal = value;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIHandler.this.frame.updateBar(updateVal);
            }
        });
    }

    public void setBarColor(int value) {
        final int updateVal = value;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIHandler.this.frame.setBarColor(updateVal);
            }
        });
    }

    public void setPRBarIndeterminate(boolean value) {
        final boolean boolValue = value;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIHandler.this.frame.setPRBarIndeterminate(boolValue);
            }
        });
    }

    public void setPRBarMinMaxValue(int min, int max) {
        final int minVal = min;
        final int maxVal = max;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIHandler.this.frame.setPRBarMinMaxValue(minVal, maxVal);
            }
        });
    }

    public void advancePRBarValueByAmount(int amount) {
        final int updateVal = amount;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UIHandler.this.frame.advancePRBarValueByAmount(updateVal);
            }
        });
    }

    public void setKeyType(int keyType2) {
        this.keyType = keyType2;
    }

    public String getUserInput(int mode, boolean isInvalid, boolean isPro) throws InputCanceledException {
        this.frame.showApp();
        BaseDialog dialog = null;
        NewPINDialog newPinDialog = null;
        switch (mode) {
            case 6: {
                dialog = new StationIssueDialog();
                break;
            }
            case 4: {
                dialog = new IRLinkIssueDialog();
                break;
            }
            case 8: {
                dialog = new SKCabinetIssueDialog();
                break;
            }
            case 1: {
                if (this.keyType == 3) {
                    dialog = new KeyIssueDialog(AppRenderer.instance.render("master.issue.title"));
                    break;
                }
                if (isPro) {
                    dialog = new KeyIssueDialog(AppRenderer.instance.render("key.issue.title.pro"));
                    break;
                }
                dialog = new KeyIssueDialog(AppRenderer.instance.render("key.issue.title"));
                break;
            }
            case 3: {
                dialog = new ProgrammerDialog();
                break;
            }
            case 2: {
                dialog = new PinNumberDialog();
                break;
            }
            case 5: {
                dialog = new GrandmasterDialog();
                break;
            }
            case 7: {
                newPinDialog = new NewPINDialog();
                break;
            }
            case 9: {
                dialog = new USBKeyClientIssueDialog();
                break;
            }
            case 10: {
                dialog = new GenericIssueDialog();
            }
        }
        block44: while (true) {
            switch (mode) {
                case 10: {
                    int value;
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("cyberlink.error.unkown"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c2 = text.charAt(0);
                            if (c2 == 'U' || c2 == 'u' || c2 == 'C' || c2 == 'c') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 6: {
                    int value;
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("station.error.unkown"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c3 = text.charAt(0);
                            if (c3 == 'U' || c3 == 'u') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 4: {
                    int value;
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("encoder.error.unkown"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c4 = text.charAt(0);
                            if (c4 == 'C' || c4 == 'c') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("encoder.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("encoder.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 8: {
                    int value;
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("locker.error.unkown"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c5 = text.charAt(0);
                            if (c5 == 'U' || c5 == 'u') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 1: {
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        if (this.keyType == 3) {
                            if (isInvalid) {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.notfound"));
                            } else {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.unknown"));
                            }
                        } else if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.notfound"));
                        } else if (isPro) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.unknown.pro"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.unknown"));
                        }
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c6 = text.charAt(0);
                            if (c6 == 'U' || c6 == 'u') {
                                text = text.substring(1);
                            }
                            if (Pattern.matches("\\p{Digit}{4,8}", text)) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("key.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 9: {
                    int value;
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        dialog.setPrompt(AppRenderer.instance.render("irlink.title"));
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            if (text.length() == 0) {
                                throw new NumberFormatException();
                            }
                            char c7 = text.charAt(0);
                            if (c7 == 'U' || c7 == 'u') {
                                text = text.substring(1);
                            }
                            if ((text = Integer.toString(value = Integer.parseInt(text.trim()))).length() == 8 || value == 0) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("station.error.format"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException();
                }
                case 3: {
                    if (dialog.getPrompt().equals("")) {
                        if (isPro) {
                            if (isInvalid) {
                                dialog.setPrompt(AppRenderer.instance.render("programmer.error.pro.notfound"));
                            } else {
                                dialog.setPrompt(AppRenderer.instance.render("programmer.job.pro.prompt"));
                            }
                        } else if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.error.notfound"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.job.prompt"));
                        }
                    }
                    boolean ok = dialog.showDialog(this.frame);
                    String text = dialog.getInput();
                    if (ok && text.length() != 0 && !text.equals("")) {
                        try {
                            int value = Integer.parseInt(text.trim());
                            text = Integer.toString(value);
                            if (text.length() != 8) {
                                dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                                continue block44;
                            }
                            return text;
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                            continue block44;
                        }
                    }
                    throw new InputCanceledException();
                }
                case 2: {
                    String text;
                    boolean ok;
                    if (dialog.getPrompt().equals("")) {
                        if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pininvalid"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pinrequired"));
                        }
                    }
                    if (ok = dialog.showDialog(this.frame)) {
                        text = dialog.getInput();
                        try {
                            text = text.trim();
                            Integer.parseInt(text);
                            if (text.length() >= 4 && text.length() <= 8) {
                                return text;
                            }
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                        }
                        continue block44;
                    }
                    throw new InputCanceledException("PIN does not match");
                }
                case 7: {
                    boolean ok;
                    if (newPinDialog.getPrompt().equals("")) {
                        if (isInvalid) {
                            newPinDialog.setPrompt(AppRenderer.instance.render("key.error.pininvalid"));
                        } else {
                            newPinDialog.setPrompt(AppRenderer.instance.render("key.error.new.pinrequired"));
                        }
                    }
                    if (ok = newPinDialog.showDialog(this.frame)) {
                        String inputText = newPinDialog.getInput();
                        String confirmText = newPinDialog.getConfirm();
                        try {
                            inputText = inputText.trim();
                            Integer.parseInt(inputText);
                            confirmText = confirmText.trim();
                            Integer.parseInt(confirmText);
                            if (inputText.length() >= 4 && inputText.length() <= 8 && confirmText.length() >= 4 && confirmText.length() <= 8 && inputText.equals(confirmText)) {
                                return inputText;
                            }
                            newPinDialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                            return null;
                        }
                        catch (NumberFormatException ex) {
                            newPinDialog.setPrompt(AppRenderer.instance.render("key.error.pindigits"));
                            return null;
                        }
                    }
                    throw new InputCanceledException("PIN does not match");
                }
                case 5: {
                    if (dialog.getPrompt().equals("")) {
                        if (isPro) {
                            if (isInvalid) {
                                dialog.setPrompt(AppRenderer.instance.render("master.error.pro.jobinvalid"));
                            } else {
                                dialog.setPrompt(AppRenderer.instance.render("master.job.pro.prompt"));
                            }
                        } else if (isInvalid) {
                            dialog.setPrompt(AppRenderer.instance.render("master.error.jobinvalid"));
                        } else {
                            dialog.setPrompt(AppRenderer.instance.render("master.job.prompt"));
                        }
                    }
                    boolean ok = dialog.showDialog(this.frame);
                    String text = dialog.getInput();
                    if (ok && text.length() != 0 && !text.equals("")) {
                        try {
                            int value = Integer.parseInt(text.trim());
                            text = Integer.toString(value);
                            if (text.length() != 8) {
                                dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                                continue block44;
                            }
                            return text;
                        }
                        catch (NumberFormatException ex) {
                            dialog.setPrompt(AppRenderer.instance.render("programmer.error.format"));
                            continue block44;
                        }
                    }
                    throw new InputCanceledException();
                }
            }
        }
    }

    public void connectionError(String error) {
        if (!this.frame.showingSettings && !this.frame.wt.stopping()) {
            String msg = AppRenderer.instance.render("connect.error.comm") + error;
            Object[] options = new Object[]{AppRenderer.instance.render("connect.title"), AppRenderer.instance.render("connect.retry"), AppRenderer.instance.render("connect.exit")};
            int n = JOptionPane.showOptionDialog(this.frame, msg, AppRenderer.instance.render("connect.error"), 1, 2, null, options, options[0]);
            if (n == 0) {
                this.frame.showSettingsModal();
            } else if (n == 2) {
                CyberLink.wt.stopWorking();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((UIHandler)UIHandler.this).frame.cyberLink.shutdown();
                    }
                });
            }
        }
    }

    public void LinkNotFoundError() {
        if (!this.frame.showingSettings && !this.frame.wt.stopping()) {
            String msg = AppRenderer.instance.render("cyberlink.error.notfound");
            Object[] options = new Object[]{AppRenderer.instance.render("cyberlink.retry"), AppRenderer.instance.render("cyberlink.exit")};
            int choice = JOptionPane.showOptionDialog(this.frame, msg, AppRenderer.instance.render("cyberlink.error.title"), 0, 2, null, options, options[0]);
            if (choice == 1) {
                CyberLink.wt.stopWorking();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((UIHandler)UIHandler.this).frame.cyberLink.shutdown();
                    }
                });
            }
        }
    }
}

