/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

class Status {
    private static int[] badStatusTypes = new int[]{67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78};
    public static final int NOERROR = 0;
    public static final int KEYSTATUSDATA = 0;
    public static final int KEYEVENTDOWNLOAD = 1;
    public static final int KEYMEMORYDUMP = 2;
    public static final int KEYLOCKLIST = 4;
    public static final int KEYCLOCKSTOP = 128;
    public static final int KEYDIRECTACCESS = 7;
    public static final int KFDISCONNECTED = 64;
    public static final int KFENCODERRESET = 65;
    public static final int KFFILENOTREADY = 66;
    public static final int KFWRONGKEYID = 67;
    public static final int KFWRONGKEYPW = 68;
    public static final int KFILEDISABLED = 69;
    public static final int KFBADFILEID = 70;
    public static final int KFOLDERFILE = 71;
    public static final int KFFILETOOLARGE = 72;
    public static final int KFBADFILE = 73;
    public static final int KFTOOMANYFILES = 74;
    public static final int KFWRITEFAILED = 75;
    public static final int KFNOENCRYPTDACC = 76;
    public static final int KFNODIRACCCMD = 77;
    public static final int KFWRONGKEYCMD = 78;

    Status() {
    }

    public static boolean isStatusBad(int status) {
        for (int k = 0; k < 12; ++k) {
            if (badStatusTypes[k] != status) continue;
            return true;
        }
        return false;
    }

    public static String getStatus(int s) {
        String output = null;
        switch (s) {
            case 0: {
                output = "Status file.";
                break;
            }
            case 1: {
                output = "Event download file.";
                break;
            }
            case 2: {
                output = "Memory dump.file.";
                break;
            }
            case 4: {
                output = "Lock list file.";
                break;
            }
            case 128: {
                output = "Clock stopped.";
                break;
            }
            case 7: {
                output = "Direct access file.";
                break;
            }
            case 64: {
                output = "Disconnected - no key present.";
                break;
            }
            case 65: {
                output = "Encoder reset";
                break;
            }
            case 66: {
                output = "File not ready - still downloading.";
                break;
            }
            case 67: {
                output = "Config sent the wrong key id.";
                break;
            }
            case 68: {
                output = "Config file sent the wrong key password.";
                break;
            }
            case 69: {
                output = "File is disabled.";
                break;
            }
            case 70: {
                output = "Config file has bad file id.";
                break;
            }
            case 71: {
                output = "Config file sent is older file.";
                break;
            }
            case 72: {
                output = "Config file sent is too large";
                break;
            }
            case 73: {
                output = "Config sent bad file.";
                break;
            }
            case 74: {
                output = "Key already has too many files";
                break;
            }
            case 75: {
                output = "Config file failed to write to key.";
                break;
            }
            case 76: {
                output = "No encrypted download access.";
                break;
            }
            case 77: {
                output = "There is no direct access command.";
                break;
            }
            case 78: {
                output = "Config file contains wrong key command.";
            }
        }
        return output;
    }
}

