/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.CyberLink;
import cyberlink.InputCanceledException;
import cyberlink.KeySessionHandler;
import cyberlink.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class NotificationManager {
    private Socket sock;
    private DataInputStream in;
    private DataOutputStream out;
    private byte[] sizeBytes;
    private byte[] keyBytes;
    private KeySessionHandler sessionHandler;
    private CyberLink cyberlink;

    public NotificationManager(CyberLink cl) {
        this.cyberlink = cl;
        this.connectToServer();
        this.sizeBytes = new byte[4];
        this.keyBytes = new byte[8];
    }

    private void connectToServer() {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
            this.sock = new Socket(InetAddress.getLocalHost(), 17295);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
        }
        catch (UnknownHostException ex) {
            System.out.println("unable to locate host to make connection");
            JOptionPane.showMessageDialog(this.cyberlink.getFrameRef(), AppRenderer.instance.render("nm.message.no.host"), AppRenderer.instance.render("nm.message.title"), 1);
            this.cyberlink.shutdown();
        }
        catch (IOException ex) {
            System.out.println("There was a problem with establishing a notification socket");
            JOptionPane.showMessageDialog(this.cyberlink.getFrameRef(), AppRenderer.instance.render("nm.message.bad.socket"), AppRenderer.instance.render("nm.message.title"), 1);
            this.cyberlink.shutdown();
        }
    }

    public void setSessionHandler(KeySessionHandler handler) {
        this.sessionHandler = handler;
    }

    public void sendStartUp() {
        int response = 0;
        byte[] message = new byte[5];
        message[0] = (byte)messageType.STARTED.ordinal();
        for (int k = 0; k < 4; ++k) {
            message[k + 1] = 0;
        }
        try {
            System.out.println("sending start up message");
            this.sendMessage(message);
            byte temp = this.in.readByte();
            if (temp < 0) {
                response = 256 + temp;
            }
            if (response == 0) {
                System.out.println("start was sent sucessfully");
            } else {
                System.out.println("start got a different response than 0 " + response);
            }
            this.out.flush();
            return;
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a start message.");
            return;
        }
    }

    public void sendShutdown() {
        int response = 0;
        byte[] message = new byte[5];
        message[0] = (byte)messageType.SHUT_DOWN.ordinal();
        for (int k = 0; k < 4; ++k) {
            message[k + 1] = 0;
        }
        try {
            System.out.println("sending shut down message");
            this.sendMessage(message);
            byte temp = this.in.readByte();
            if (temp < 0) {
                response = 256 + temp;
            }
            if (response == 0) {
                System.out.println("shut down was sent sucessfully");
            } else {
                System.out.println("shut down got a different response than 0 " + response);
            }
            this.out.flush();
            return;
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a shut down message. " + ex);
            return;
        }
    }

    public void sendKeyIn(byte[] idBytes, String millivolts, boolean isGM, boolean isProg) {
        int k;
        this.keyBytes = idBytes;
        int response = 0;
        byte[] message = new byte[18];
        message[0] = (byte)messageType.KEY_IN.ordinal();
        this.sizeBytes = Util.longToFourBEBytes(13L);
        for (k = 0; k < 4; ++k) {
            message[k + 1] = this.sizeBytes[k];
        }
        for (k = 0; k < 8; ++k) {
            message[k + 5] = idBytes[k];
        }
        byte[] voltBytes = millivolts.getBytes();
        for (int k2 = 0; k2 < 4; ++k2) {
            message[k2 + 13] = voltBytes[k2];
        }
        message[17] = isGM ? (byte)keyType.GM.ordinal() : (isProg ? (byte)keyType.PROG.ordinal() : (byte)keyType.USER.ordinal());
        try {
            System.out.println("sending key in message");
            this.sendMessage(message);
            byte temp = this.in.readByte();
            if (temp < 0) {
                response = 256 + temp;
            }
            if (response == 0) {
                System.out.println("key_in was sent sucessfully");
            } else {
                System.out.println("key_in got a different response than 0 " + response);
            }
            return;
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a key_in message." + ex);
            return;
        }
    }

    public void sendKeyOut() {
        int k;
        int response = 0;
        byte[] message = new byte[13];
        message[0] = (byte)messageType.KEY_OUT.ordinal();
        this.sizeBytes = Util.longToFourBEBytes(8L);
        for (k = 0; k < 4; ++k) {
            message[k + 1] = this.sizeBytes[k];
        }
        for (k = 0; k < 8; ++k) {
            message[k + 5] = this.keyBytes[k];
        }
        for (k = 0; k < 8; ++k) {
            this.keyBytes[k] = 0;
        }
        try {
            System.out.println("sending key out message");
            this.sendMessage(message);
            byte temp = this.in.readByte();
            if (temp < 0) {
                response = 256 + temp;
            }
            if (response == 0) {
                System.out.println("key_out was sent sucessfully");
            } else {
                System.out.println("key_out got a different response than 0 " + response);
            }
            this.out.flush();
            return;
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a key_out message." + ex);
            return;
        }
    }

    public void sendKeyVerify() {
        int response = 0;
        byte[] message = new byte[5];
        message[0] = (byte)messageType.VERIFY.ordinal();
        for (int k = 0; k < 4; ++k) {
            message[k + 1] = 0;
        }
        try {
            System.out.println("sending key verified message");
            this.sendMessage(message);
            byte temp = this.in.readByte();
            if (temp < 0) {
                response = 256 + temp;
            }
            if (response == 0) {
                System.out.println("key verified was sent sucessfully");
            } else {
                System.out.println("key verified got a different response than 0 " + response);
            }
            this.out.flush();
            return;
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a key verified message.");
            return;
        }
    }

    public int sendPromptRequest(promptType type, boolean isInvalid) throws InputCanceledException {
        int response = 0;
        byte[] message = new byte[6];
        message[0] = (byte)messageType.PROMPT.ordinal();
        this.sizeBytes = Util.longToFourBEBytes(1L);
        for (int k = 0; k < 4; ++k) {
            message[k + 1] = this.sizeBytes[k];
        }
        message[5] = isInvalid ? (byte)promptType.INVALID.ordinal() : (byte)type.ordinal();
        try {
            while (true) {
                boolean done;
                System.out.println("sending prompt request message");
                this.sendMessage(message);
                response = this.in.readByte();
                System.out.println("response was " + response);
                switch (response) {
                    case 0: {
                        this.out.flush();
                        return -1;
                    }
                    case 1: {
                        response = this.in.readInt();
                        System.out.println("returned prompt = " + response);
                        this.out.flush();
                        done = true;
                        break;
                    }
                    case 2: {
                        this.out.flush();
                        throw new InputCanceledException();
                    }
                    case 3: {
                        try {
                            System.out.println("is key gone?");
                            if (this.sessionHandler.isKeyGoneAskOnce()) {
                                System.out.println("yes, sending key out...");
                                this.out.flush();
                                this.sendKeyOut();
                                done = true;
                                break;
                            }
                            done = false;
                            System.out.println("going around again...");
                            break;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    default: {
                        this.out.flush();
                        return -1;
                    }
                }
                if (!done) {
                    System.out.println("bottom of while loop...");
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            System.out.println("There was a problem sending a prompt request message.");
        }
        return response;
    }

    public void sendMessage(byte[] message) {
        while (true) {
            try {
                this.out.write(message);
                return;
            }
            catch (IOException ex) {
                System.out.println("There was a problem sending a message, re-connecting.");
                this.connectToServer();
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum promptType {
        JOBADMIN,
        CELLISSUE,
        KEYMISSIONISSUE,
        PIN,
        INVALID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum keyType {
        USER,
        PROG,
        GM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum messageType {
        STARTED,
        SHUT_DOWN,
        KEY_IN,
        KEY_OUT,
        PROMPT,
        VERIFY;

    }
}

