/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.Util;

public class NetworkSettings {
    public String UnitIPStr;
    public String SubnetStr;
    public String GatewayStr;
    public String DNSStr;
    public String ServerIPStr;
    public String ServerName;
    public String Account;
    public String RootDir;
    public int Port;
    public boolean usesDHCP;
    public byte[] rawBytes;
    public byte[] content;
    public boolean isVault;

    public NetworkSettings(byte[] bytes, boolean isVault) {
        this.rawBytes = bytes;
        this.isVault = isVault;
        this.parse();
    }

    private void parse() {
        this.content = new byte[150];
        if (this.isVault) {
            System.arraycopy(this.rawBytes, 87, this.content, 0, 150);
        } else {
            System.arraycopy(this.rawBytes, 75, this.content, 0, 150);
        }
        byte[] temp = new byte[4];
        System.arraycopy(this.content, 0, temp, 0, 4);
        this.usesDHCP = this.isZero(temp);
        this.UnitIPStr = this.makeIPString(temp);
        System.arraycopy(this.content, 4, temp, 0, 4);
        this.SubnetStr = this.makeIPString(temp);
        System.arraycopy(this.content, 8, temp, 0, 4);
        this.GatewayStr = this.makeIPString(temp);
        System.arraycopy(this.content, 12, temp, 0, 4);
        this.DNSStr = this.makeIPString(temp);
        System.arraycopy(this.content, 16, temp, 0, 4);
        this.ServerIPStr = this.makeIPString(temp);
        byte[] temp64 = new byte[64];
        System.arraycopy(this.content, 20, temp64, 0, 64);
        this.ServerName = this.makeName(temp64);
        byte[] temp32 = new byte[32];
        System.arraycopy(this.content, 84, temp32, 0, 32);
        this.Account = this.makeName(temp32);
        System.arraycopy(this.content, 116, temp32, 0, 32);
        this.RootDir = this.makeName(temp32);
        byte[] temp2 = new byte[2];
        System.arraycopy(this.content, 148, temp2, 0, 2);
        this.Port = Util.twoLEBytesToInt(temp2);
    }

    private boolean isZero(byte[] bytes) {
        for (byte b2 : bytes) {
            if (b2 == 0) continue;
            return false;
        }
        return true;
    }

    private String makeIPString(byte[] bytes) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (byte b2 : bytes) {
            String temp = Integer.toString(b2 & 0xFF);
            sb.append(temp);
            if (count < 3) {
                sb.append(".");
            }
            ++count;
        }
        return sb.toString();
    }

    private String makeName(byte[] bytes) {
        return new String(bytes).trim();
    }
}

