/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import cyberlink.AppRenderer;
import cyberlink.CyberLink;
import cyberlink.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class MainFrame_SettingsBox
extends JDialog
implements ActionListener {
    XYLayout xYLayout1 = new XYLayout();
    JLabel portLabel = new JLabel();
    JTextField txtPort = new JTextField();
    JCheckBox chbxAuth = new JCheckBox();
    JLabel usernameLabel = new JLabel();
    JLabel passwordLabel = new JLabel();
    JTextField txtUsername = new JTextField();
    JPasswordField jPasswordField1 = new JPasswordField();
    JTextField txtHost = new JTextField();
    JButton OKButton = new JButton();
    JButton CancelButton = new JButton();
    JLabel serverLabel = new JLabel();
    JTextField txtServer = new JTextField();
    JCheckBox chbxProxy = new JCheckBox();
    JLabel hostLabel = new JLabel();
    JLabel exampleLabel = new JLabel();
    CyberLink capc;
    JLabel lblCatName = new JLabel();
    JTextField txtCatalog = new JTextField();
    JLabel lblTimeout = new JLabel();
    JTextField txtTimeout = new JTextField();
    JLabel errorLabel = new JLabel();

    public MainFrame_SettingsBox(Frame parent) {
        super(parent);
        this.capc = ((MainFrame)parent).cyberLink;
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.synchSettings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.xYLayout1.setWidth(520);
        this.xYLayout1.setHeight(435);
        this.getContentPane().setLayout(this.xYLayout1);
        this.setModal(true);
        this.setResizable(false);
        this.chbxProxy.setText(AppRenderer.instance.render("proxy.title"));
        this.chbxProxy.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    MainFrame_SettingsBox.this.txtHost.setEnabled(true);
                    MainFrame_SettingsBox.this.txtHost.setBackground(Color.lightGray);
                    MainFrame_SettingsBox.this.txtPort.setEnabled(true);
                    MainFrame_SettingsBox.this.txtPort.setBackground(Color.lightGray);
                    MainFrame_SettingsBox.this.chbxAuth.setEnabled(true);
                } else {
                    MainFrame_SettingsBox.this.txtHost.setEnabled(false);
                    MainFrame_SettingsBox.this.txtHost.setText("");
                    MainFrame_SettingsBox.this.txtHost.setBackground(Color.gray);
                    MainFrame_SettingsBox.this.txtPort.setEnabled(false);
                    MainFrame_SettingsBox.this.txtPort.setText("");
                    MainFrame_SettingsBox.this.txtPort.setBackground(Color.gray);
                    MainFrame_SettingsBox.this.chbxAuth.setEnabled(false);
                }
            }
        });
        this.hostLabel.setText(AppRenderer.instance.render("proxy.host"));
        this.portLabel.setText(AppRenderer.instance.render("proxy.port"));
        this.txtPort.setBackground(Color.gray);
        this.txtPort.setEnabled(false);
        this.txtPort.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtPort.setText("");
        this.chbxAuth.setText(AppRenderer.instance.render("proxy.auth"));
        this.chbxAuth.setEnabled(false);
        this.chbxAuth.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    MainFrame_SettingsBox.this.txtUsername.setEnabled(true);
                    MainFrame_SettingsBox.this.txtUsername.setBackground(Color.lightGray);
                    MainFrame_SettingsBox.this.jPasswordField1.setEnabled(true);
                    MainFrame_SettingsBox.this.jPasswordField1.setBackground(Color.lightGray);
                } else {
                    MainFrame_SettingsBox.this.txtUsername.setText("");
                    MainFrame_SettingsBox.this.txtUsername.setEnabled(false);
                    MainFrame_SettingsBox.this.txtUsername.setBackground(Color.gray);
                    MainFrame_SettingsBox.this.jPasswordField1.setEnabled(false);
                    MainFrame_SettingsBox.this.jPasswordField1.setText("");
                    MainFrame_SettingsBox.this.jPasswordField1.setBackground(Color.gray);
                }
            }
        });
        this.usernameLabel.setText(AppRenderer.instance.render("proxy.user"));
        this.passwordLabel.setText(AppRenderer.instance.render("proxy.password"));
        this.txtUsername.setBackground(Color.gray);
        this.txtUsername.setEnabled(false);
        this.txtUsername.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtUsername.setText("");
        this.jPasswordField1.setBackground(Color.gray);
        this.jPasswordField1.setEnabled(false);
        this.jPasswordField1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPasswordField1.setText("");
        this.txtHost.setBackground(Color.gray);
        this.txtHost.setEnabled(false);
        this.txtHost.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtHost.setText("");
        this.OKButton.setText(AppRenderer.instance.render("button.ok"));
        this.OKButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.OKButton);
        this.CancelButton.setText(AppRenderer.instance.render("button.cancel"));
        this.CancelButton.addActionListener(this);
        this.serverLabel.setText(AppRenderer.instance.render("server.url"));
        this.txtServer.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txtServer.setText("");
        this.txtServer.setBackground(Color.lightGray);
        this.exampleLabel.setText(AppRenderer.instance.render("server.example"));
        this.lblCatName.setText(AppRenderer.instance.render("server.account"));
        this.txtCatalog.setText("");
        this.lblTimeout.setText(AppRenderer.instance.render("server.timeout"));
        this.txtTimeout.setText("");
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("");
        this.getContentPane().add((Component)this.serverLabel, new XYConstraints(59, 40, 83, -1));
        this.getContentPane().add((Component)this.txtServer, new XYConstraints(140, 38, 322, -1));
        this.getContentPane().add((Component)this.chbxProxy, new XYConstraints(27, 94, 98, -1));
        this.getContentPane().add((Component)this.errorLabel, new XYConstraints(300, 105, 150, -1));
        this.getContentPane().add((Component)this.hostLabel, new XYConstraints(65, 134, 95, -1));
        this.getContentPane().add((Component)this.txtHost, new XYConstraints(140, 131, 322, -1));
        this.getContentPane().add((Component)this.portLabel, new XYConstraints(65, 166, 75, -1));
        this.getContentPane().add((Component)this.txtPort, new XYConstraints(140, 163, 322, -1));
        this.getContentPane().add((Component)this.chbxAuth, new XYConstraints(27, 215, 153, -1));
        this.getContentPane().add((Component)this.usernameLabel, new XYConstraints(29, 255, 110, -1));
        this.getContentPane().add((Component)this.txtUsername, new XYConstraints(140, 252, 322, -1));
        this.getContentPane().add((Component)this.passwordLabel, new XYConstraints(29, 288, 111, -1));
        this.getContentPane().add((Component)this.jPasswordField1, new XYConstraints(140, 285, 322, 23));
        this.getContentPane().add((Component)this.OKButton, new XYConstraints(127, 368, 87, -1));
        this.getContentPane().add((Component)this.CancelButton, new XYConstraints(281, 368, 87, -1));
        this.getContentPane().add((Component)this.exampleLabel, new XYConstraints(140, 12, 355, -1));
        this.getContentPane().add((Component)this.lblCatName, new XYConstraints(70, 63, -1, -1));
        this.getContentPane().add((Component)this.txtCatalog, new XYConstraints(140, 63, 154, -1));
        this.getContentPane().add((Component)this.lblTimeout, new XYConstraints(310, 63, 50, -1));
        this.getContentPane().add((Component)this.txtTimeout, new XYConstraints(360, 63, 70, -1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean ok;
        if (actionEvent.getSource() == this.CancelButton) {
            this.dispose();
        }
        if (actionEvent.getSource() == this.OKButton && (ok = this.assignSettings())) {
            this.capc.writeSettings();
            this.dispose();
        }
    }

    private void synchSettings() {
        if (CyberLink.serverURL != null) {
            this.txtServer.setText(CyberLink.serverURL.toString());
        }
        if (CyberLink.account != null) {
            this.txtCatalog.setText(CyberLink.account);
        }
        this.txtTimeout.setText(Integer.toString(CyberLink.timeout));
        if (CyberLink.proxyHost != null && CyberLink.proxyPort != 0) {
            this.chbxProxy.setEnabled(true);
            this.chbxProxy.setSelected(true);
            this.txtHost.setBackground(Color.lightGray);
            this.txtHost.setText(CyberLink.proxyHost);
            this.txtPort.setBackground(Color.lightGray);
            this.txtPort.setText(Integer.toString(CyberLink.proxyPort));
        }
        if (CyberLink.proxyUserName != null && CyberLink.proxyPassword != null && !CyberLink.proxyUserName.equals("") && !CyberLink.proxyPassword.equals("")) {
            this.chbxAuth.setEnabled(true);
            this.chbxAuth.setSelected(true);
            this.txtUsername.setEnabled(true);
            this.txtUsername.setBackground(Color.lightGray);
            this.txtUsername.setText(CyberLink.proxyUserName);
            this.jPasswordField1.setEnabled(true);
            this.jPasswordField1.setBackground(Color.lightGray);
            this.jPasswordField1.setText(CyberLink.proxyPassword);
        }
    }

    private boolean assignSettings() {
        String text = this.txtServer.getText();
        if (text != null && text.length() > 0) {
            try {
                CyberLink.serverURL = new URL(text.trim());
                CyberLink.connectionSettingsChanged();
            }
            catch (MalformedURLException ex) {}
        } else {
            CyberLink.serverURL = null;
        }
        CyberLink.account = (text = this.txtCatalog.getText().trim()).length() > 0 ? text : null;
        text = this.txtTimeout.getText();
        if (text != null && text.length() > 0) {
            try {
                int timeout = Integer.parseInt(text.trim());
                if (timeout < 0) {
                    this.errorLabel.setText(AppRenderer.instance.render("error.timeout.negative"));
                    return false;
                }
                CyberLink.timeout = timeout;
            }
            catch (NumberFormatException n) {
                this.errorLabel.setText(AppRenderer.instance.render("error.timeout.number"));
                return false;
            }
        } else {
            CyberLink.timeout = 5;
        }
        text = this.txtHost.getText();
        CyberLink.proxyHost = text != null && text.length() > 0 ? text.trim() : null;
        text = this.txtPort.getText();
        if (text != null && text.length() > 0) {
            try {
                int port = Integer.parseInt(text.trim());
                if (port < 0) {
                    this.errorLabel.setText(AppRenderer.instance.render("error.proxyport.negative"));
                    return false;
                }
                CyberLink.proxyPort = port;
            }
            catch (NumberFormatException n) {
                this.errorLabel.setText(AppRenderer.instance.render("error.proxyport.number"));
                return false;
            }
        } else {
            CyberLink.proxyPort = 0;
        }
        text = this.txtUsername.getText();
        CyberLink.proxyUserName = text != null && text.length() > 0 ? text.trim() : null;
        text = new String(this.jPasswordField1.getPassword());
        CyberLink.proxyPassword = text != null && text.length() > 0 ? text.trim() : null;
        return true;
    }
}

