/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.CurrentKeyStatus;
import cyberlink.CyberLink;
import cyberlink.EncoderException;
import cyberlink.KeySessionHandler;
import cyberlink.KeyStatus;
import cyberlink.MainFrame_AboutBox;
import cyberlink.MainFrame_SettingsBox;
import cyberlink.MainFrame_jMenuHelpAbout_ActionAdapter;
import cyberlink.MainFrame_jMenuItem1_actionAdapter;
import cyberlink.NetworkSettings;
import cyberlink.SingleKeyCabinet;
import cyberlink.UpdateDialog;
import cyberlink.WorkerThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MainFrame
extends JFrame
implements ItemListener {
    public WorkerThread wt;
    public boolean showingSettings = false;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenu1 = new JMenu();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel pnlTop = new JPanel();
    JPanel pnlBottom = new JPanel();
    JPanel pnlLeft = new JPanel();
    JPanel pnlRight = new JPanel();
    JTextPane txtErrors = new JTextPane();
    GridLayout gridLayout1 = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    JLabel lblOperation = new JLabel();
    JLabel lblStatus = new JLabel();
    JLabel lblKeyname = new JLabel();
    JLabel lblVoltage = new JLabel();
    JLabel lblLowVoltage = new JLabel();
    CyberLink cyberLink;
    JPanel pnlCancel = new JPanel();
    JButton btnCancel = new JButton();
    ImageIcon image1 = new ImageIcon();
    JMenuItem mnuSettings = new JMenuItem();
    JCheckBoxMenuItem cardScanner = new JCheckBoxMenuItem();
    JProgressBar bar = new JProgressBar(0, 100);
    FlowLayout flowLayout1 = new FlowLayout();
    JMenuItem mnuShowError = new JMenuItem();
    JMenuItem mnuLastKeyInfo = new JMenuItem();
    JMenuItem mnuLastCardInfo = new JMenuItem();
    JMenuItem mnuCabinetInfo = new JMenuItem();
    JMenuItem mnuNetworkInfo = new JMenuItem();
    JMenuItem mnuCurrentKeyStatusOn = new JMenuItem();
    JMenuItem mnuCurrentKeyStatusOff = new JMenuItem();
    private String lastError;

    public MainFrame(CyberLink cyberLink) {
        this.cyberLink = cyberLink;
        try {
            this.setDefaultCloseOperation(0);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLastError(null, null);
    }

    public void updateBar(int updateValue) {
        final int finalUpdateValue = updateValue;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.bar.setValue(finalUpdateValue);
                }
            });
        }
        catch (NullPointerException ne) {
            System.out.println(ne);
            ne.printStackTrace();
        }
    }

    public void setBarColor(int percent) {
        Color c2 = null;
        switch (percent) {
            case -1: {
                c2 = Color.white;
                break;
            }
            case 0: {
                c2 = Color.red;
                break;
            }
            case 25: {
                c2 = Color.yellow;
                break;
            }
            case 50: {
                c2 = Color.yellow;
                break;
            }
            case 75: {
                c2 = Color.green;
                break;
            }
            case 100: {
                c2 = Color.blue;
            }
        }
        final Color color = c2;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.bar.setBackground(color);
                }
            });
        }
        catch (NullPointerException ne) {
            System.out.println(ne);
            ne.printStackTrace();
        }
    }

    public void setPRBarIndeterminate(boolean value) {
        final boolean finalValue = value;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.bar.setIndeterminate(finalValue);
                }
            });
        }
        catch (NullPointerException ne) {
            System.out.println(ne);
            ne.printStackTrace();
        }
    }

    public void setPRBarMinMaxValue(int min, int max) {
        final int minValue = min;
        final int maxValue = max;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.bar.setMinimum(minValue);
                    MainFrame.this.bar.setMaximum(maxValue);
                }
            });
        }
        catch (NullPointerException ne) {
            System.out.println(ne);
            ne.printStackTrace();
        }
    }

    public void advancePRBarValueByAmount(int a2) {
        final int amount = a2;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.bar.setValue(MainFrame.this.bar.getValue() + amount);
                }
            });
        }
        catch (NullPointerException ne) {
            System.out.println(ne);
            ne.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setIconImage(null);
        this.setResizable(false);
        this.setSize(new Dimension(380, 250));
        this.setTitle("CyberLink");
        this.image1 = new ImageIcon(MainFrame.class.getResource("about.png"));
        this.setIconImage(this.image1.getImage());
        this.jMenuFile.setText("File");
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new MainFrame_jMenuHelpAbout_ActionAdapter(this));
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new MainFrame_jMenuItem1_actionAdapter(this));
        this.jMenu1.setText("Options");
        this.btnCancel.setText("Cancel");
        this.jMenuFile.setMnemonic('F');
        this.jMenu1.setMnemonic('O');
        this.jMenuHelp.setMnemonic('H');
        String OS = System.getProperty("os.name");
        if (OS.indexOf("Mac") != -1) {
            this.jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        } else {
            this.jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        }
        this.jMenuHelpAbout.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.mnuSettings.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mnuLastKeyInfo.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.mnuCurrentKeyStatusOn.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mnuCurrentKeyStatusOff.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.mnuLastCardInfo.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.mnuCabinetInfo.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.mnuShowError.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.mnuNetworkInfo.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.pnlTop.setMinimumSize(new Dimension(73, 150));
        this.pnlTop.setOpaque(false);
        this.pnlTop.setPreferredSize(new Dimension(10, 180));
        this.pnlTop.setLayout(this.gridLayout1);
        this.pnlBottom.setLayout(new FlowLayout(0));
        this.pnlBottom.setOpaque(false);
        this.pnlBottom.setPreferredSize(new Dimension(10, 25));
        this.pnlLeft.setOpaque(false);
        this.pnlLeft.setPreferredSize(new Dimension(10, 50));
        this.pnlRight.setOpaque(false);
        this.pnlRight.setPreferredSize(new Dimension(10, 50));
        this.txtErrors.setBackground(UIManager.getColor("PasswordField.inactiveBackground"));
        this.txtErrors.setEnabled(false);
        this.txtErrors.setForeground(SystemColor.windowText);
        this.txtErrors.setBorder(null);
        this.txtErrors.setOpaque(false);
        this.txtErrors.setDisabledTextColor(Color.red);
        this.txtErrors.setEditable(false);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(5);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.lblOperation.setFont(new Font("Default", 1, 18));
        this.lblOperation.setForeground(Color.white);
        this.lblOperation.setBorder(null);
        this.lblOperation.setHorizontalAlignment(0);
        this.lblStatus.setFont(new Font("Default", 0, 14));
        this.lblStatus.setForeground(Color.white);
        this.lblStatus.setHorizontalAlignment(0);
        this.lblKeyname.setFont(new Font("Default", 0, 14));
        this.lblKeyname.setForeground(Color.white);
        this.lblKeyname.setHorizontalAlignment(0);
        this.lblVoltage.setFont(new Font("Default", 0, 14));
        this.lblVoltage.setForeground(Color.white);
        this.lblVoltage.setBorder(null);
        this.lblVoltage.setHorizontalAlignment(0);
        this.lblLowVoltage.setFont(new Font("Default", 0, 14));
        this.lblLowVoltage.setForeground(Color.red);
        this.lblLowVoltage.setBorder(null);
        this.lblLowVoltage.setHorizontalAlignment(0);
        this.contentPane.setBackground(new Color(0, 0, 128));
        this.contentPane.setMinimumSize(new Dimension(58, 10));
        this.contentPane.setPreferredSize(new Dimension(50, 50));
        this.pnlCancel.setMinimumSize(new Dimension(50, 125));
        this.pnlCancel.setOpaque(false);
        this.pnlCancel.setPreferredSize(new Dimension(50, 125));
        this.pnlCancel.setLayout(this.flowLayout1);
        this.mnuSettings.setActionCommand("Settings...");
        this.mnuSettings.setText("Settings...");
        this.mnuSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuSettings_actionPerformed(e2);
            }
        });
        this.cardScanner.setActionCommand("Card Scanner");
        this.cardScanner.setText("Card Scanner Mode");
        this.cardScanner.addItemListener(this);
        this.mnuShowError.setText("View last error message...");
        this.mnuShowError.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuShowError_actionPerformed(e2);
            }
        });
        this.mnuLastKeyInfo.setText("View last key information...");
        this.mnuLastKeyInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuLastKeyInfo_actionPerformed(e2);
            }
        });
        this.mnuCurrentKeyStatusOn.setText("Turn On Key Status Mode");
        this.mnuCurrentKeyStatusOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuCurrentKeyStatusOn_actionPerformed(e2);
            }
        });
        this.mnuCurrentKeyStatusOff.setText("Turn Off Key Status Mode");
        this.mnuCurrentKeyStatusOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuCurrentKeyStatusOff_actionPerformed(e2);
            }
        });
        this.mnuNetworkInfo.setText("View webstation network info...");
        this.mnuNetworkInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuNetworkInfo_actionPerformed(e2);
            }
        });
        this.mnuLastCardInfo.setText("View last card information...");
        this.mnuLastCardInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuLastCardInfo_actionPerformed(e2);
            }
        });
        this.mnuCabinetInfo.setText("View cabinet information.");
        this.mnuCabinetInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.mnuCabinetInfo_actionPerformed(e2);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                MainFrame.this.btnCancel_actionPerformed(e2);
            }
        });
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenu1.add(this.mnuSettings);
        this.jMenu1.add(this.mnuShowError);
        this.jMenu1.add(this.mnuLastKeyInfo);
        this.jMenu1.add(this.mnuLastCardInfo);
        this.jMenu1.add(this.mnuCabinetInfo);
        this.jMenu1.add(this.cardScanner);
        this.jMenu1.add(this.mnuNetworkInfo);
        this.jMenu1.add(this.mnuCurrentKeyStatusOn);
        this.jMenu1.add(this.mnuCurrentKeyStatusOff);
        this.contentPane.add((Component)this.pnlLeft, "West");
        this.contentPane.add((Component)this.pnlRight, "East");
        this.pnlCancel.add(this.txtErrors);
        this.pnlTop.add(this.lblOperation);
        this.pnlTop.add(this.lblKeyname);
        this.pnlTop.add(this.lblStatus);
        JPanel barPanel = new JPanel();
        barPanel.setOpaque(false);
        barPanel.add(this.bar);
        this.pnlTop.add(barPanel);
        this.pnlTop.add(this.pnlCancel);
        this.pnlBottom.add(this.lblVoltage);
        this.pnlBottom.add(this.lblLowVoltage);
        this.contentPane.add((Component)this.pnlBottom, "South");
        this.contentPane.add((Component)this.pnlTop, "North");
        this.setJMenuBar(this.jMenuBar1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                MainFrame.this.iconifyOrExit();
            }
        });
    }

    public void itemStateChanged(ItemEvent e2) {
        boolean checkedState = e2.getStateChange() == 1;
        CyberLink.cardScanningMode = checkedState;
    }

    private void iconifyOrExit() {
        if (this.getState() == 0) {
            this.iconifyFrame();
        } else {
            this.cyberLink.shutdown();
        }
    }

    private void iconifyFrame() {
        this.setState(1);
    }

    void mnuCabinetInfo_actionPerformed(ActionEvent e2) {
        SingleKeyCabinet.pauseReadStatus = true;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.showCabinetInfo();
        SingleKeyCabinet.pauseReadStatus = false;
    }

    void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        this.cyberLink.shutdown();
    }

    void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void mnuSettings_actionPerformed(ActionEvent e2) {
        this.showSettingsModal();
    }

    public void mnuLastKeyInfo_actionPerformed(ActionEvent e2) {
        this.showLastKeyInfo();
    }

    public void mnuCurrentKeyStatusOn_actionPerformed(ActionEvent e2) {
        KeySessionHandler.KeyStatusModeOn = true;
    }

    public void mnuCurrentKeyStatusOff_actionPerformed(ActionEvent e2) {
        KeySessionHandler.KeyStatusModeOn = false;
    }

    public void mnuNetworkInfo_actionPerformed(ActionEvent e2) {
        SingleKeyCabinet.pauseReadStatus = true;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.showNetworkInfo();
        SingleKeyCabinet.pauseReadStatus = false;
    }

    public void mnuLastCardInfo_actionPerformed(ActionEvent e2) {
        this.showLastCardInfo();
    }

    public void showSettingsModal() {
        this.showingSettings = true;
        String title = "Server and Proxy Settings";
        MainFrame_SettingsBox settingsDialog = new MainFrame_SettingsBox(this);
        settingsDialog.setTitle(title);
        Dimension dlgSize = settingsDialog.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        settingsDialog.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, loc.y);
        settingsDialog.setModal(true);
        settingsDialog.pack();
        settingsDialog.setVisible(true);
        this.showingSettings = false;
    }

    public void showUpdateModal(String SWV, int PID) {
        String title = "CyberKey Firmware Install";
        UpdateDialog updateDialog = new UpdateDialog(this, true, SWV, PID, this.wt);
        updateDialog.setTitle(title);
        updateDialog.setSize(380, 185);
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        updateDialog.setLocation((frmSize.width - frmSize.width) / 2 + loc.x, (frmSize.height - frmSize.height) / 2 + loc.y);
        updateDialog.setVisible(true);
    }

    public void showLastKeyInfo() {
        String info = this.getLastKeyInfo();
        JTextArea text = new JTextArea(info, 8, 40);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        JOptionPane.showMessageDialog(this, new JScrollPane(text), "Last Key Information", 1, new ImageIcon(this.image1.getImage()));
    }

    public void showCurrentKeyStatus() {
        CurrentKeyStatus CKS = new CurrentKeyStatus(this.wt);
        String status = CKS.getCurrentStatus();
        JTextArea text = new JTextArea(status, 8, 40);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        JOptionPane.showMessageDialog(this, new JScrollPane(text), "Current Key Status", 1, new ImageIcon(this.image1.getImage()));
    }

    public void showLastCardInfo() {
        String info = this.getLastCardInfo();
        JTextArea text = new JTextArea(info, 8, 50);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        JOptionPane.showMessageDialog(this, new JScrollPane(text), "Last Card Information", 1, new ImageIcon(this.image1.getImage()));
    }

    public void showCabinetInfo() {
        String info = this.getSingleKeyCabinetInfo();
        JTextArea text = new JTextArea(info, 25, 30);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        JOptionPane.showMessageDialog(this, new JScrollPane(text), "Current Cabinet Information", 1, new ImageIcon(this.image1.getImage()));
    }

    public void showNetworkInfo() {
        String info = this.getNetworkInfo();
        JTextArea text = new JTextArea(info, 25, 30);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        JOptionPane.showMessageDialog(this, new JScrollPane(text), "Network Information", 1, new ImageIcon(this.image1.getImage()));
    }

    public void setViewVaultInfoVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuCabinetInfo.setVisible(b2);
            }
        });
    }

    public void setCardScannerVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.cardScanner.setVisible(b2);
            }
        });
    }

    public void setViewKeyInfoVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuLastKeyInfo.setVisible(b2);
            }
        });
    }

    public void setViewCardInfoVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuLastCardInfo.setVisible(b2);
            }
        });
    }

    public void setViewNetworkInfoVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuNetworkInfo.setVisible(b2);
            }
        });
    }

    public void setCurrentKeyStatusOnVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuCurrentKeyStatusOn.setVisible(b2);
            }
        });
    }

    public void setCurrentKeyStatusOffVisible(final boolean b2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuCurrentKeyStatusOff.setVisible(b2);
            }
        });
    }

    public void setWorkerThreadReference(WorkerThread wt) {
        this.wt = wt;
    }

    public void btnCancel_actionPerformed(ActionEvent e2) {
        this.lblOperation.setText("Aborting...");
        this.lblStatus.setText("");
        this.wt.signalReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showApp() {
        this.setState(0);
        this.setVisible(true);
        this.toFront();
        String OS = System.getProperty("os.name");
        if (OS.indexOf("Mac") != -1) {
            String command = "tell application \"System Events\"\rtell (every application process whose name is \"java\")\rset frontmost to true\rend tell\rend tell";
            String[] scriptArray = new String[]{"osascript", "-e", command};
            Process result = null;
            try {
                result = Runtime.getRuntime().exec(scriptArray);
                result.waitFor();
            }
            catch (Exception e2) {}
        } else if (OS.indexOf("Windows") != -1) {
            this.setAlwaysOnTop(true);
            InputStream in = null;
            File scriptFile = null;
            try {
                scriptFile = File.createTempFile("showApp", ".wsf");
                in = CyberLink.class.getResourceAsStream("showApp.wsf");
                if (in == null) {
                    System.out.println("can't read the script as resource stream");
                }
                byte[] b2 = new byte[1024];
                int numRead = in.read(b2);
                FileWriter fw = new FileWriter(scriptFile);
                for (int k = 0; k < numRead; ++k) {
                    fw.write((char)b2[k]);
                }
                fw.close();
                in.close();
                Process result = Runtime.getRuntime().exec("cscript " + scriptFile.getAbsolutePath());
                result.waitFor();
            }
            catch (Exception ioe) {
                System.out.println("error " + ioe);
            }
            finally {
                if (scriptFile != null) {
                    scriptFile.delete();
                }
            }
            this.setAlwaysOnTop(false);
        }
    }

    public String getNetworkInfo() {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] netsettings = this.wt.getWSNetworkSettings();
            NetworkSettings ns = new NetworkSettings(netsettings, false);
            sb.append("\n\nNetwork Settings\n");
            if (ns.usesDHCP) {
                sb.append("\nDevice uses DHCP settings");
            }
            sb.append("\nDevice IP: " + ns.UnitIPStr);
            sb.append("\nSubnet: " + ns.SubnetStr);
            sb.append("\nGateway: " + ns.GatewayStr);
            sb.append("\nDNS1: " + ns.DNSStr);
            sb.append("\nServer IP: " + ns.ServerIPStr);
            if (ns.ServerName.length() > 0) {
                sb.append("\nServer Name: " + ns.ServerName);
            } else {
                sb.append("\nServer Name: None");
            }
            sb.append("\nAccount: " + ns.Account);
            sb.append("\nRoot Directory: " + ns.RootDir);
            sb.append("\nPort: " + ns.Port);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            sb.append("Failed to read network settings from Web station.\n");
        }
        return sb.toString();
    }

    public String getLastKeyInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.wt.lastKeyInfo != null) {
            sb.append("  Key Type: " + this.wt.lastKeyInfo.lastKeyType + "\n");
            sb.append("  Key ID: " + this.wt.lastKeyInfo.lastID + "\n");
            sb.append("  Key Name: " + this.wt.lastKeyInfo.lastName + "\n");
            sb.append("  Battery voltage: " + this.wt.lastKeyInfo.lastVoltage + "\n");
            sb.append("  " + this.wt.lastKeyInfo.lastLowBatt + "\n");
        } else {
            sb.append("\n");
            sb.append("\tNo information available.\n");
            sb.append("\n");
            sb.append("\n");
            sb.append("\n");
        }
        String info = sb.toString();
        return info;
    }

    public String getLastCardInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.wt.lastCardInfo != null) {
            String typeStr;
            switch (this.wt.lastCardInfo.lastCardType) {
                case 1: {
                    typeStr = "13.56MHz - ISO/IEC 14443 Type A format";
                    break;
                }
                case 2: {
                    typeStr = "13.56MHz - ISO/IEC 14443 Type B format";
                    break;
                }
                case 3: {
                    typeStr = "13.56MHz - ISO 15693 format";
                    break;
                }
                default: {
                    typeStr = "unknown";
                }
            }
            if (this.wt.lastCardInfo.lastRFID == null) {
                sb.append("  Card RFID: None\n");
            } else {
                sb.append("  Card RFID: " + this.wt.lastCardInfo.lastRFID + "\n");
            }
            sb.append("  Card type(" + this.wt.lastCardInfo.lastCardType + "): " + typeStr + "\n");
            if (this.wt.lastCardInfo.lastCardIDBytes == null) {
                sb.append("  Data read from card: None\n");
            } else {
                sb.append("  Data read from card: " + this.wt.lastCardInfo.lastCardIDBytes + "\n");
            }
            sb.append("  Reader firmware: " + this.wt.lastCardInfo.readerUSBVersion + " - " + this.wt.lastCardInfo.readerRFIDVersion + "\n");
        } else {
            sb.append("\n");
            sb.append("\tNo information available.\n");
            sb.append("\n");
            sb.append("\n");
        }
        String info = sb.toString();
        return info;
    }

    public String getSingleKeyCabinetInfo() {
        StringBuilder sb = new StringBuilder();
        try {
            KeyStatus KS = this.wt.fileManager.readStatus();
            sb.append("Single Key Cabinet serial: " + KS.getLinkID() + "\n");
            sb.append("RFIDFirmware version: " + KS.RFIDFirmware + "\n");
            if (KS.isRFIDCardPresent) {
                sb.append("\nRFID card type: " + KS.RFIDCardType + "\n");
                sb.append("This card was last read " + KS.timeSinceCardLastRead + " seconds ago.\n");
                sb.append("RFID Card ID: " + KS.RFCardID + "\n");
            } else {
                sb.append("\nNo card present.\n");
            }
            if (KS.doorOpen) {
                sb.append("Door has been open for " + KS.timeSinceDoorStatusChange + " seconds.\n");
            } else {
                sb.append("Door has been closed for " + KS.timeSinceDoorStatusChange + " seconds.\n");
            }
            sb.append("\n\nThe cabinet information bytes: " + KS.theSevenByteString + "\n");
            sb.append("\nKey Connected: " + KS.bitKeyConnected);
            sb.append("\nRFID Reader: " + KS.bitRFIDReader);
            sb.append("\nNetwork Connected: " + KS.bitNetwork);
            sb.append("\nHub Ready: " + KS.bitHubReady);
            sb.append("\nKey Ready: " + KS.bitKeyReady);
            sb.append("\nKey Charging: " + KS.bitKeyCharging);
            sb.append("\nKey Charge Complete: " + KS.bitChargeDone);
            sb.append("\nKey Disabled: " + KS.bitDisableKey + "\n");
            sb.append("\nHost Firmware: " + KS.bitHostFirmware);
            sb.append("\nConfiguration Error: " + KS.bitConfigError);
            sb.append("\nHost Parameter: " + KS.bitHostParameter);
            sb.append("\nDownload Ready: " + KS.bitDLoadReady);
            sb.append("\nResult Ready: " + KS.bitResultReady);
            sb.append("\nGot RFID: " + KS.bitGotRFID);
            sb.append("\nDoor Open: " + KS.bitDoorOpen);
            sb.append("\nSolenoid Enabled: " + KS.bitEnableSolenoid + "\n");
            sb.append("\nUSB Ready: " + KS.bitUSBReady);
            sb.append("\nEnable Charge: " + KS.bitEnableCharge);
            sb.append("\nStop Charge: " + KS.bitStopCharge);
            sb.append("\nControl Beeper: " + KS.bitCtrlBeep);
            sb.append("\nDisable Key: " + KS.bitHDDisableKey);
            sb.append("\nSystem Reset: " + KS.bitSystemReset);
            sb.append("\nBeeper Disabled: " + KS.bitDisableBeep);
            sb.append("\nDemo Mode: " + KS.bitDemoMode);
            sb.append("\nSecurity Mode: " + KS.bitSecurityMode + "\n");
            byte[] netsettings = this.wt.getVaultNetworkSettings();
            NetworkSettings ns = new NetworkSettings(netsettings, true);
            sb.append("\n\nNetwork Settings\n");
            if (ns.usesDHCP) {
                sb.append("\nDevice uses DHCP settings");
            }
            sb.append("\nDevice IP: " + ns.UnitIPStr);
            sb.append("\nSubnet: " + ns.SubnetStr);
            sb.append("\nGateway: " + ns.GatewayStr);
            sb.append("\nDNS1: " + ns.DNSStr);
            sb.append("\nServer IP: " + ns.ServerIPStr);
            if (ns.ServerName.length() > 0) {
                sb.append("\nServer Name: " + ns.ServerName);
            } else {
                sb.append("\nServer Name: None");
            }
            sb.append("\nAccount: " + ns.Account);
            sb.append("\nRoot Directory: " + ns.RootDir);
            sb.append("\nPort: " + ns.Port);
        }
        catch (EncoderException e2) {
            sb.append("Failed to read status from Cabinet.\n");
        }
        catch (Exception ex) {
            sb.append("Failed to read network settings from Cabinet.\n");
        }
        String info = sb.toString();
        return info;
    }

    public void mnuShowError_actionPerformed(ActionEvent e2) {
        if (this.lastError != null) {
            JTextArea text = new JTextArea(this.lastError, 5, 60);
            text.setEditable(false);
            text.setForeground(Color.RED);
            JOptionPane.showMessageDialog(this, new JScrollPane(text), AppRenderer.instance.render("last.error"), 2);
        }
    }

    public void setLastError(String txt, Throwable stackTrace) {
        if (txt != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(txt);
            String ln = System.getProperty("line.separator");
            sb.append(ln);
            if (stackTrace != null) {
                StringWriter sw = new StringWriter();
                stackTrace.printStackTrace(new PrintWriter(sw));
                sb.append(ln);
                sb.append(AppRenderer.instance.render("last.error.info"));
                sb.append(ln);
                sb.append(sw.getBuffer().toString());
            }
            this.lastError = sb.toString();
        } else {
            this.lastError = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.mnuShowError.setEnabled(MainFrame.this.lastError != null);
            }
        });
    }
}

