/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MacRawDiskReader {
    private File file;
    private FileInputStream fileInput;
    private BufferedInputStream buffStream;
    static final byte ATTR_READ_ONLY = 1;
    static final byte ATTR_HIDDEN = 2;
    static final byte ATTR_SYSTEM = 4;
    static final byte ATTR_VOLUME_ID = 8;
    static final byte ATTR_DIRECTORY = 16;
    static final byte ATTR_ARCHIVE = 32;
    static final byte ATTR_LONG_NAME = 15;
    static final byte ATTR_LONG_NAME_MASK = 63;
    private int bpb_Bytes_Per_Sec;
    private int bpb_Sec_Per_Clus;
    private int bpb_Rsvd_Sec_Cnt;
    private int bpb_Num_Fats;
    private int bpb_Root_Ent_Cnt;
    private int bpb_Fat_Sz16;
    private int root_Dir_Sectors;
    private int first_Data_Cluster;

    public MacRawDiskReader(String devFileAbsolutePath) throws IOException {
        this.file = new File(devFileAbsolutePath);
        this.initBuffer();
        this.readBPB();
        this.root_Dir_Sectors = (this.bpb_Root_Ent_Cnt * 32 + (this.bpb_Bytes_Per_Sec - 1)) / this.bpb_Bytes_Per_Sec;
        this.first_Data_Cluster = this.bpb_Rsvd_Sec_Cnt + this.bpb_Num_Fats * this.bpb_Fat_Sz16 + this.root_Dir_Sectors;
    }

    private void initBuffer() throws IOException {
        if (this.buffStream != null) {
            this.closeBuffStream();
        }
        this.fileInput = new FileInputStream(this.file);
        this.buffStream = new BufferedInputStream(this.fileInput);
        this.buffStream.mark(512000);
    }

    public void closeBuffStream() throws IOException {
        this.buffStream.close();
    }

    public byte[] getUSBMacFile(String theFileName) throws IOException {
        long bytesSkipped;
        this.initBuffer();
        if (theFileName.endsWith(".")) {
            throw new IOException("Illegal file name.\n'" + theFileName + "' can't end with a dot.");
        }
        String convertedUserFileName = this.convertToDirEntryName(theFileName);
        byte[] dirEntry = this.getDirEntryForFile(this.buffStream, convertedUserFileName);
        if (null == dirEntry) {
            throw new FileNotFoundException("File not found: '" + theFileName + "'");
        }
        int clusterNumber = dirEntry[27] & 0xFF;
        clusterNumber = clusterNumber << 8 | dirEntry[26] & 0xFF;
        int fileSize = dirEntry[31] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[30] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[29] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[28] & 0xFF;
        byte[] dataCluster = new byte[fileSize];
        int bytesLeft = fileSize;
        int sector = this.firstSectorOfCluster(clusterNumber);
        this.buffStream.reset();
        for (long bytePos = (long)(sector * this.bpb_Bytes_Per_Sec); bytePos > 0L; bytePos -= bytesSkipped) {
            bytesSkipped = this.buffStream.skip(bytePos);
        }
        int bytesRead = 0;
        while (bytesLeft > 0) {
            bytesRead = this.buffStream.read(dataCluster, bytesRead, bytesLeft);
            bytesLeft -= bytesRead;
        }
        return dataCluster;
    }

    public byte[] getMacFile(String theFileName) throws IOException {
        this.initBuffer();
        if (theFileName.endsWith(".")) {
            throw new IOException("Illegal file name.\n'" + theFileName + "' can't end with a dot.");
        }
        String convertedUserFileName = this.convertToDirEntryName(theFileName);
        byte[] dirEntry = this.getDirEntryForFile(this.buffStream, convertedUserFileName);
        if (null == dirEntry) {
            throw new FileNotFoundException("File not found: '" + theFileName + "'");
        }
        int clusterNumber = dirEntry[27] & 0xFF;
        clusterNumber = clusterNumber << 8 | dirEntry[26] & 0xFF;
        int fileSize = dirEntry[31] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[30] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[29] & 0xFF;
        fileSize = fileSize << 8 | dirEntry[28] & 0xFF;
        byte[] dataCluster = new byte[fileSize];
        int numExtents = (fileSize + this.bpb_Bytes_Per_Sec - 1) / this.bpb_Bytes_Per_Sec;
        int bytesLeft = fileSize;
        for (int currentExtent = 1; currentExtent <= numExtents; ++currentExtent) {
            int newBytesRead;
            int bytesRead;
            long bytesSkipped;
            int sector = this.firstSectorOfCluster(clusterNumber);
            this.buffStream.reset();
            for (long bytePos = (long)(sector * this.bpb_Bytes_Per_Sec); bytePos > 0L; bytePos -= bytesSkipped) {
                bytesSkipped = this.buffStream.skip(bytePos);
            }
            if (bytesLeft <= this.bpb_Bytes_Per_Sec) {
                bytesRead = this.buffStream.read(dataCluster, (currentExtent - 1) * this.bpb_Bytes_Per_Sec, bytesLeft);
                if (bytesLeft == bytesRead || bytesLeft == bytesRead + (newBytesRead = this.buffStream.read(dataCluster, bytesRead, bytesLeft - bytesRead))) continue;
                throw new IOException("Error reading a Cluster.\nTrying to read " + bytesLeft + ",\n" + "but only read " + bytesRead + newBytesRead);
            }
            bytesRead = this.buffStream.read(dataCluster, (currentExtent - 1) * this.bpb_Bytes_Per_Sec, this.bpb_Bytes_Per_Sec);
            if (this.bpb_Bytes_Per_Sec != bytesRead && this.bpb_Bytes_Per_Sec != bytesRead + (newBytesRead = this.buffStream.read(dataCluster, bytesRead, this.bpb_Bytes_Per_Sec - bytesRead))) {
                throw new IOException("Error reading a Cluster.\nTrying to read " + bytesLeft + ",\n" + "but only read " + bytesRead + newBytesRead);
            }
            bytesLeft -= this.bpb_Bytes_Per_Sec;
            clusterNumber = this.getClusterFromFAT(clusterNumber, this.buffStream);
        }
        return dataCluster;
    }

    private byte[] getDirEntryForFile(BufferedInputStream buffStream, String fileNameToFind) throws IOException {
        buffStream.reset();
        for (long bytesSkipped = 0L; bytesSkipped != (long)((this.bpb_Rsvd_Sec_Cnt + this.bpb_Num_Fats * this.bpb_Fat_Sz16) * this.bpb_Bytes_Per_Sec); bytesSkipped += buffStream.skip((long)((this.bpb_Rsvd_Sec_Cnt + this.bpb_Num_Fats * this.bpb_Fat_Sz16) * this.bpb_Bytes_Per_Sec) - bytesSkipped)) {
        }
        for (int dirEntryCounter = 0; dirEntryCounter < this.bpb_Root_Ent_Cnt; ++dirEntryCounter) {
            int newBytesRead;
            byte[] dirEntry = new byte[32];
            int bytesRead = 0;
            try {
                bytesRead = buffStream.read(dirEntry, 0, 32);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            if (32 != bytesRead && 32 != bytesRead + (newBytesRead = buffStream.read(dirEntry, bytesRead, 32 - bytesRead))) {
                throw new IOException("Error reading 32 byte directory entry.\nWanted to read 32 bytes.\nOnly read " + (bytesRead + newBytesRead) + ".");
            }
            if (-1 == dirEntry[0]) {
                return null;
            }
            if (229 == dirEntry[0]) continue;
            String DIR_Name = new String("");
            for (int i2 = 0; i2 < 11; ++i2) {
                DIR_Name = DIR_Name + (char)dirEntry[i2];
            }
            if (!DIR_Name.equals(fileNameToFind)) continue;
            return dirEntry;
        }
        return null;
    }

    private String convertToDirEntryName(String userName) {
        if (userName.length() > 12) {
            return userName;
        }
        if ('.' == userName.charAt(0)) {
            return userName;
        }
        int charCounter = 0;
        String newString = "";
        int maxRead = 8;
        if (userName.length() < 8) {
            maxRead = userName.length();
        }
        while (charCounter < maxRead && '.' != userName.charAt(charCounter)) {
            newString = newString + userName.charAt(charCounter);
            ++charCounter;
        }
        for (int i2 = charCounter; i2 < 8; ++i2) {
            newString = newString + " ";
        }
        if (userName.length() > charCounter) {
            newString = newString + userName.substring(charCounter + 1, userName.length());
        }
        while (newString.length() < 11) {
            newString = newString + " ";
        }
        return newString.toUpperCase();
    }

    private int getClusterFromFAT(int cluster, BufferedInputStream buff) throws IOException {
        int returnAddress = 0;
        int theFATOffset = cluster + cluster / 2;
        int thisFATSecNum = this.bpb_Rsvd_Sec_Cnt + theFATOffset / this.bpb_Bytes_Per_Sec;
        int thisFATEntOffset = theFATOffset % this.bpb_Bytes_Per_Sec;
        int absoluteOffset = thisFATSecNum * this.bpb_Bytes_Per_Sec + thisFATEntOffset;
        buff.reset();
        buff.skip(absoluteOffset);
        returnAddress = this.readTwoBytes(buff);
        returnAddress = 0 == cluster % 2 ? (returnAddress &= 0xFFF) : (returnAddress >>= 4);
        return returnAddress;
    }

    private void readBPB() throws IOException {
        int i2;
        this.buffStream.reset();
        int bytesRead = this.buffStream.read();
        bytesRead = this.buffStream.read();
        bytesRead = this.buffStream.read();
        String OEMName = new String("");
        for (i2 = 0; i2 < 8; ++i2) {
            OEMName = OEMName + (char)this.buffStream.read();
        }
        this.bpb_Bytes_Per_Sec = this.readTwoBytes(this.buffStream);
        this.bpb_Sec_Per_Clus = this.buffStream.read();
        this.bpb_Rsvd_Sec_Cnt = this.readTwoBytes(this.buffStream);
        this.bpb_Num_Fats = this.buffStream.read();
        this.bpb_Root_Ent_Cnt = this.readTwoBytes(this.buffStream);
        int BPB_TotSec16 = this.readTwoBytes(this.buffStream);
        int BPB_Media = this.buffStream.read();
        this.bpb_Fat_Sz16 = this.readTwoBytes(this.buffStream);
        int BPB_SecPerTrk = this.readTwoBytes(this.buffStream);
        int BPB_NumHeads = this.readTwoBytes(this.buffStream);
        int BPB_HiddSec = this.readFourBytes(this.buffStream);
        int BPB_TotSec32 = this.readFourBytes(this.buffStream);
        int BS_DrvNum = this.buffStream.read();
        int BS_Reserved1 = this.buffStream.read();
        int BS_BootSig = this.buffStream.read();
        int BS_VolID = 0;
        String BS_VolLab = new String("");
        String BS_FilSysType = new String("");
        if (41 == BS_BootSig) {
            BS_VolID = this.readFourBytes(this.buffStream);
            for (i2 = 0; i2 < 11; ++i2) {
                BS_VolLab = BS_VolLab + (char)this.buffStream.read();
            }
            for (i2 = 0; i2 < 8; ++i2) {
                BS_FilSysType = BS_FilSysType + (char)this.buffStream.read();
            }
        }
    }

    private int firstSectorOfCluster(int cluster) {
        return (cluster - 2) * this.bpb_Sec_Per_Clus + this.first_Data_Cluster;
    }

    private int readTwoBytes(BufferedInputStream buff) throws IOException {
        int newBytesRead;
        byte[] b2 = new byte[2];
        int i2 = 0;
        int bytesRead = buff.read(b2, 0, 2);
        if (2 != bytesRead && 2 != bytesRead + (newBytesRead = buff.read(b2, bytesRead, 2 - bytesRead))) {
            throw new IOException("Tried to read 2 bytes, but only read " + (bytesRead + newBytesRead));
        }
        i2 |= b2[1] & 0xFF;
        i2 <<= 8;
        return i2 |= b2[0] & 0xFF;
    }

    private int readFourBytes(BufferedInputStream buff) throws IOException {
        int newBytesRead;
        byte[] b2 = new byte[4];
        int i2 = 0;
        int bytesRead = buff.read(b2, 0, 4);
        if (4 != bytesRead && 4 != bytesRead + (newBytesRead = buff.read(b2, bytesRead, 4 - bytesRead))) {
            throw new IOException("Tried to read 4 bytes, but only read " + (bytesRead + newBytesRead));
        }
        i2 |= b2[3] & 0xFF;
        i2 <<= 8;
        i2 |= b2[2] & 0xFF;
        i2 <<= 8;
        i2 |= b2[1] & 0xFF;
        i2 <<= 8;
        return i2 |= b2[0] & 0xFF;
    }
}

