/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.CyberLink;
import cyberlink.Util;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;

public class KeyStatus {
    private byte[] rawData;
    private short PID;
    private short HWV;
    private short SWV;
    private byte[] keyIDBytes;
    private String keyID;
    public byte[] RFIDFirmwareBytes;
    public String RFIDFirmware;
    public boolean isRFIDCardPresent;
    public int RFIDCardType;
    public int timeSinceCardLastRead;
    private int USBFirmwareVer;
    private int WEBFirmwareVer;
    private int RFIDFirmwareVer;
    private String linkID;
    private int keyTime;
    private short Offset;
    private short Index;
    private short keyType;
    private byte[] fileConfigBytes;
    private long currentKeySettingID;
    private int numEvents;
    private int eventAddr;
    private short downloadStatus;
    private int realNumEvents;
    private String voltage;
    private String millivolts;
    private int charged;
    private byte[] keyConfig;
    private int numLocks;
    private long downloadFileID;
    private int fileStartAddr;
    private int fileBytesRemaining;
    private short numberOfFiles;
    private short numberOfDownloads;
    private short currentFileIndex;
    private short currentFileOPMode;
    private int fileCRC;
    public boolean isGrandMaster;
    public boolean isProgrammer;
    public boolean isConfigureKey;
    public boolean isEncoder;
    public boolean isStation;
    public boolean isUSBStation;
    public boolean isWEBStation;
    public boolean fromAuthorizer;
    public boolean isStealthKey;
    public boolean isInvalidGMKey;
    public boolean isRolloverSet;
    public boolean isLowBattery;
    public boolean isBluetoothKey;
    public boolean isVault;
    public boolean isCardReader;
    public boolean isHighSecurityBitSet;
    public boolean isUSBKey;
    public byte[] RFCardIDBytes;
    public byte RFIDStatusByte;
    public String RFCardID;
    public String rawRFIDField;
    public byte[] doorStatusBytes;
    public boolean doorOpen;
    public int timeSinceDoorStatusChange;
    public byte[] theSevenBytes;
    public String theSevenByteString;
    public boolean bitKeyConnected;
    public boolean bitRFIDReader;
    public boolean bitNetwork;
    public boolean bitHubReady;
    public boolean bitKeyReady;
    public boolean bitKeyCharging;
    public boolean bitChargeDone;
    public boolean bitDisableKey;
    public boolean bitHostFirmware;
    public boolean bitConfigError;
    public boolean bitHostParameter;
    public boolean bitDLoadReady;
    public boolean bitResultReady;
    public boolean bitGotRFID;
    public boolean bitDoorOpen;
    public boolean bitEnableSolenoid;
    public boolean bitUSBReady;
    public boolean bitEnableCharge;
    public boolean bitStopCharge;
    public boolean bitCtrlBeep;
    public boolean bitHDDisableKey;
    public boolean bitSystemReset;
    public boolean bitDisableBeep;
    public boolean bitDemoMode;
    public boolean bitSecurityMode;

    public KeyStatus(byte[] status) {
        this.rawData = status;
        this.processStatus();
    }

    public byte getHardwareByte() {
        return this.rawData[2];
    }

    public String getLinkID() {
        return this.linkID;
    }

    public int getUSBLinkFirmwareVer() {
        return this.USBFirmwareVer;
    }

    public int getWEBLinkFirmwareVer() {
        return this.WEBFirmwareVer;
    }

    public int getRFIDFirmwareVer() {
        return this.RFIDFirmwareVer;
    }

    public short getDownloadStatus() {
        return this.downloadStatus;
    }

    public String getKeyID() {
        return this.keyID;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public byte[] getkeyConfigBytes() {
        return this.keyConfig;
    }

    public byte[] getFileConfigBytes() {
        return this.fileConfigBytes;
    }

    public int getRealNumEvents() {
        return this.realNumEvents;
    }

    public int getNumEvents() {
        return this.numEvents;
    }

    public int getNumLocks() {
        return this.numLocks;
    }

    public long getCurrentKeySetting() {
        return this.currentKeySettingID;
    }

    public short getSWV() {
        return this.SWV;
    }

    public short getHWV() {
        return this.HWV;
    }

    public short getPID() {
        return this.PID;
    }

    public String getVoltage() {
        return this.voltage;
    }

    public String getMillivolts() {
        return this.millivolts;
    }

    public int chargeStatus() {
        return this.charged;
    }

    public byte[] getKeyIDBytes() {
        return this.keyIDBytes;
    }

    private void processStatus() {
        int k;
        byte[] packet1 = new byte[24];
        byte[] packet2 = new byte[25];
        byte[] packet3 = new byte[26];
        byte[] packet4 = new byte[14];
        for (k = 0; k < 24; ++k) {
            packet1[k] = this.rawData[k];
        }
        for (k = 24; k < 49; ++k) {
            packet2[k - 24] = this.rawData[k];
        }
        for (k = 49; k < 75; ++k) {
            packet3[k - 49] = this.rawData[k];
        }
        for (k = 75; k < 89; ++k) {
            packet4[k - 75] = this.rawData[k];
        }
        this.processPacketOne(packet1);
        this.processPacketTwo(packet2);
        this.processPacketThree(packet3);
        this.processPacketFour(packet4);
        this.isGM();
    }

    public boolean validateFile() {
        boolean isValidFile = true;
        if (this.rawData.length != 89 && this.rawData.length != 120) {
            isValidFile = false;
        } else if (this.keyID.equals("K00000000")) {
            isValidFile = false;
        } else if (this.rawData[0] == 113) {
            if (this.rawData[49] != this.rawData[0]) {
                isValidFile = false;
            }
        } else if (this.rawData[0] != 113 && (this.rawData[49] != this.rawData[0] || (this.rawData[50] & 0x7F) != (this.rawData[1] & 0x7F))) {
            isValidFile = false;
        } else if (!Util.checkIrDaCRC16(this.rawData, this.rawData.length)) {
            isValidFile = false;
        } else if (this.keyIDBytes[7] != Util.CRC8(this.keyIDBytes, this.keyIDBytes.length - 1)) {
            isValidFile = false;
        }
        return isValidFile;
    }

    public boolean validateCabinetFile() {
        boolean isValidFile = true;
        if (this.rawData.length != 120) {
            isValidFile = false;
        } else if (this.keyID.equals("K00000000")) {
            isValidFile = false;
        } else if (this.rawData[49] != this.rawData[0] || (this.rawData[50] & 0x7F) != (this.rawData[1] & 0x7F)) {
            isValidFile = false;
        } else if (!Util.checkIrDaCRC16(this.rawData, this.rawData.length)) {
            isValidFile = false;
        } else if (this.keyIDBytes[7] != Util.CRC8(this.keyIDBytes, this.keyIDBytes.length - 1)) {
            isValidFile = false;
        }
        return isValidFile;
    }

    private void processPacketOne(byte[] packet1) {
        int k;
        this.isEncoder = false;
        this.isUSBStation = false;
        this.isWEBStation = false;
        this.isVault = false;
        this.keyIDBytes = new byte[8];
        for (int k2 = 0; k2 < 8; ++k2) {
            this.keyIDBytes[k2] = packet1[k2];
        }
        this.PID = Util.ByteToShort(packet1[0]);
        this.SWV = Util.ByteToShort((byte)(packet1[1] & 0x7F));
        this.HWV = Util.ByteToShort(packet1[2]);
        this.isStealthKey = this.PID == 108;
        this.isInvalidGMKey = this.PID == 106 && (packet1[1] & 0x80) > 0;
        this.isBluetoothKey = this.PID == 110;
        this.isUSBKey = this.PID == 113;
        byte[] b2 = new byte[]{packet1[3], packet1[4], packet1[5], packet1[6]};
        this.keyID = Util.makeStringID("K", b2);
        byte[] hexAsciiBytes = new byte[16];
        for (int k3 = 8; k3 < 24; ++k3) {
            hexAsciiBytes[k3 - 8] = packet1[k3];
        }
        byte[] tempBinaryBytes = new byte[8];
        for (int k4 = 8; k4 < 16; ++k4) {
            tempBinaryBytes[k4 - 8] = packet1[k4];
        }
        this.isCardReader = tempBinaryBytes[0] == 99;
        this.isVault = this.checkForSingleKeyLocker(tempBinaryBytes);
        byte[] binaryBytes = this.isVault || this.isCardReader ? tempBinaryBytes : Util.hexAsciiToBinary(hexAsciiBytes);
        this.USBFirmwareVer = binaryBytes[1];
        byte[] encoderIDBytes = new byte[4];
        for (k = 3; k < 7; ++k) {
            encoderIDBytes[k - 3] = binaryBytes[k];
        }
        if (this.isUSBKey) {
            if (CyberLink.usbKeyCommId == 0L) {
                long randomLong;
                CyberLink.usbKeyCommId = randomLong = new Random().nextLong();
                CyberLink.writePrefs();
            }
            String h2 = System.getProperty("user.home");
            String n = System.getProperty("user.name");
            String m = h2 + n;
            int mHash = m.hashCode();
            long merged = CyberLink.usbKeyCommId + (long)mHash;
            String mergedByteStr = Util.bytesToHexString(Util.longToEightBEBytes(merged));
            this.linkID = "Z" + mergedByteStr;
        }
        if (binaryBytes[0] == 86) {
            this.linkID = Util.makeStringID("V", encoderIDBytes);
            this.isEncoder = true;
        } else if (binaryBytes[0] == 99) {
            this.linkID = Util.makeStringID("c", encoderIDBytes);
        } else if (binaryBytes[0] == 118) {
            this.linkID = Util.makeStringID("v", encoderIDBytes);
            this.isUSBStation = true;
        } else if (binaryBytes[0] == 87) {
            this.linkID = Util.makeStringID("W", encoderIDBytes);
            this.WEBFirmwareVer = binaryBytes[2];
            if (!this.isVault) {
                this.isWEBStation = true;
            }
        }
        if (this.isUSBStation || this.isWEBStation) {
            this.isStation = true;
        }
        if (this.isVault || this.isCardReader) {
            int k5;
            this.RFIDFirmwareBytes = new byte[4];
            for (k = 16; k < 20; ++k) {
                this.RFIDFirmwareBytes[k - 16] = packet1[k];
            }
            this.RFIDFirmware = "c" + Integer.toHexString(this.RFIDFirmwareBytes[1] & 0xFF) + Integer.toHexString(this.RFIDFirmwareBytes[2] & 0xFF) + Integer.toHexString(this.RFIDFirmwareBytes[3] & 0xFF);
            this.RFIDFirmwareVer = this.RFIDFirmwareBytes[1];
            this.theSevenBytes = new byte[7];
            for (k = 0; k < 7; ++k) {
                this.theSevenBytes[k] = this.rawData[k + 87];
            }
            StringBuilder sbb = new StringBuilder();
            for (k5 = 0; k5 < 7; ++k5) {
                String tempSevenByte = Integer.toHexString(this.theSevenBytes[k5] & 0xFF).toUpperCase();
                if (tempSevenByte.length() == 1) {
                    tempSevenByte = "0" + tempSevenByte;
                }
                sbb.append(tempSevenByte);
                if (k5 >= 6) continue;
                sbb.append(" ");
            }
            this.theSevenByteString = sbb.toString();
            this.bitKeyConnected = (this.theSevenBytes[0] & 1) > 0;
            this.bitRFIDReader = (this.theSevenBytes[0] & 2) > 0;
            this.bitNetwork = (this.theSevenBytes[0] & 4) > 0;
            this.bitHubReady = (this.theSevenBytes[0] & 8) > 0;
            this.bitKeyReady = (this.theSevenBytes[0] & 0x10) > 0;
            this.bitKeyCharging = (this.theSevenBytes[0] & 0x20) > 0;
            this.bitChargeDone = (this.theSevenBytes[0] & 0x40) > 0;
            this.bitDisableKey = (this.theSevenBytes[0] & 0x80) > 0;
            this.bitHostFirmware = (this.theSevenBytes[1] & 1) > 0;
            this.bitConfigError = (this.theSevenBytes[1] & 2) > 0;
            this.bitHostParameter = (this.theSevenBytes[1] & 4) > 0;
            this.bitDLoadReady = (this.theSevenBytes[1] & 8) > 0;
            this.bitResultReady = (this.theSevenBytes[1] & 0x10) > 0;
            this.bitGotRFID = (this.theSevenBytes[1] & 0x20) > 0;
            this.bitDoorOpen = (this.theSevenBytes[1] & 0x40) > 0;
            this.bitEnableSolenoid = (this.theSevenBytes[1] & 0x80) > 0;
            this.bitUSBReady = (this.theSevenBytes[1] & 1) > 0;
            this.bitEnableCharge = (this.theSevenBytes[1] & 2) > 0;
            this.bitStopCharge = (this.theSevenBytes[1] & 4) > 0;
            this.bitCtrlBeep = (this.theSevenBytes[1] & 8) > 0;
            this.bitHDDisableKey = (this.theSevenBytes[1] & 0x10) > 0;
            this.bitSystemReset = (this.theSevenBytes[1] & 0x20) > 0;
            this.bitDisableBeep = (this.theSevenBytes[4] & 1) > 0;
            this.bitDemoMode = (this.theSevenBytes[4] & 2) > 0;
            this.bitSecurityMode = (this.theSevenBytes[4] & 4) > 0;
            this.doorStatusBytes = new byte[4];
            for (k5 = 0; k5 < 4; ++k5) {
                this.doorStatusBytes[k5] = this.rawData[k5 + 94];
            }
            this.doorOpen = this.doorStatusBytes[0] == 1;
            int temp = Util.LEBytesToInt(this.doorStatusBytes[2], this.doorStatusBytes[3]);
            this.timeSinceDoorStatusChange = temp / 8;
            this.RFCardIDBytes = new byte[20];
            for (int k6 = 0; k6 < 20; ++k6) {
                this.RFCardIDBytes[k6] = this.rawData[k6 + 98];
            }
            boolean bl = this.isRFIDCardPresent = this.RFCardIDBytes[0] != 0;
            if (this.isRFIDCardPresent) {
                this.RFIDCardType = this.RFCardIDBytes[0];
                this.RFIDStatusByte = this.RFCardIDBytes[1];
                temp = Util.LEBytesToInt(this.RFCardIDBytes[2], this.RFCardIDBytes[3]);
                this.timeSinceCardLastRead = temp / 8;
                StringBuilder sb = new StringBuilder();
                switch (this.RFIDCardType) {
                    case 1: {
                        int k7;
                        int i2 = this.RFCardIDBytes[4] / 64;
                        int numBytes = i2 * 3 + 4;
                        for (k7 = 0; k7 < numBytes; ++k7) {
                            String tempByte = Integer.toHexString(this.RFCardIDBytes[6 + k7] & 0xFF).toUpperCase();
                            if (tempByte.length() == 1) {
                                tempByte = "0" + tempByte;
                            }
                            sb.append(tempByte);
                        }
                        break;
                    }
                    case 2: {
                        int k7;
                        for (k7 = 0; k7 < 4; ++k7) {
                            String tempByte = Integer.toHexString(this.RFCardIDBytes[5 + k7] & 0xFF).toUpperCase();
                            if (tempByte.length() == 1) {
                                tempByte = "0" + tempByte;
                            }
                            sb.append(tempByte);
                        }
                        break;
                    }
                    case 3: {
                        int k7;
                        for (k7 = 0; k7 < 6; ++k7) {
                            String tempByte = Integer.toHexString(this.RFCardIDBytes[6 + k7] & 0xFF).toUpperCase();
                            if (tempByte.length() == 1) {
                                tempByte = "0" + tempByte;
                            }
                            sb.append(tempByte);
                        }
                        break;
                    }
                    default: {
                        int k7;
                        for (k7 = 4; k7 < 20; ++k7) {
                            String tempByte = Integer.toHexString(this.RFCardIDBytes[k7] & 0xFF).toUpperCase();
                            if (tempByte.length() == 1) {
                                tempByte = "0" + tempByte;
                            }
                            sb.append(tempByte);
                        }
                    }
                }
                this.RFCardID = sb.toString();
                StringBuilder ssb = new StringBuilder();
                for (int k8 = 0; k8 < 20; ++k8) {
                    if (k8 == 2 || k8 == 3) continue;
                    String tempByte = Integer.toHexString(this.RFCardIDBytes[k8] & 0xFF).toUpperCase();
                    if (tempByte.length() == 1) {
                        tempByte = "0" + tempByte;
                    }
                    ssb.append(tempByte);
                }
                this.rawRFIDField = ssb.toString();
            }
        }
    }

    private void processPacketTwo(byte[] packet2) {
        short secs = (short)(Util.ByteToShort(packet2[0]) / 4);
        short mins = Util.ByteToShort(packet2[1]);
        short hours = Util.ByteToShort(packet2[2]);
        short day = Util.ByteToShort(packet2[3]);
        short month = Util.ByteToShort(packet2[4]);
        short year = (short)(Util.ByteToShort(packet2[6]) + 1996);
        GregorianCalendar KeyCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        KeyCalendar.set(year, month - 1, day, hours, mins, secs);
        this.keyTime = Util.secondsUTCFromUTCGC(KeyCalendar);
        if ((packet2[7] & 0xFF & 0x80) > 0) {
            short min15 = Util.ByteToShort((byte)(packet2[7] ^ 0x80));
            if (min15 >= 0 && min15 <= 96) {
                this.Offset = (short)Util.decodeOffset(min15);
            }
        } else if (packet2[7] >= 1 && packet2[7] <= 72) {
            this.Index = packet2[7];
            this.Offset = (short)-1;
        }
        this.keyType = Util.ByteToShort((byte)(packet2[8] & 0x7F));
        if (this.keyType < 0 || this.keyType > 8) {
            this.keyType = (short)2;
        }
        this.fromAuthorizer = (packet2[8] & 0x80) <= 0;
        this.fileConfigBytes = new byte[4];
        this.fileConfigBytes[0] = packet2[12];
        this.fileConfigBytes[1] = packet2[11];
        this.fileConfigBytes[2] = packet2[10];
        this.fileConfigBytes[3] = packet2[9];
        this.currentKeySettingID = Util.fourBEBytesToLong(this.fileConfigBytes);
        if (this.currentKeySettingID == 0xFFFFFFFFL) {
            this.currentKeySettingID = Util.getVidexTime();
        }
        byte[] temp = new byte[]{packet2[20], packet2[21]};
        this.numEvents = Util.BEBytesToShort(temp);
        temp = new byte[]{packet2[22], packet2[23]};
        this.eventAddr = Util.BEBytesToShort(temp);
        this.downloadStatus = Util.ByteToShort(packet2[24]);
    }

    private void processPacketThree(byte[] packet3) {
        this.keyConfig = packet3;
        this.isProgrammer = (this.keyIDBytes[1] & 0x80) > 0 && this.PID != 106;
        this.isConfigureKey = (this.keyConfig[14] & 0xFF & 1) > 0 && (this.keyConfig[15] & 0xFF & 8) == 0;
        this.isHighSecurityBitSet = (this.keyConfig[14] & 0x40) > 0;
        this.calculateRealNumEvents();
        this.calculateVoltage();
        this.calculateChargeStatus(this.keyConfig[23]);
        this.isRolloverSet = (this.keyConfig[14] & 0x10) > 0;
        byte[] nl = new byte[]{this.keyConfig[11], this.keyConfig[12]};
        this.numLocks = Util.BEBytesToShort(nl);
    }

    private boolean checkForSingleKeyLocker(byte[] bytes) {
        return bytes[0] == 87 && bytes[6] == 99 && bytes[7] == Util.CRC8(bytes, 7);
    }

    private void calculateChargeStatus(byte chargeStatusByte) {
        int mask2;
        int mask1;
        if (this.isStealthKey) {
            mask1 = 4;
            mask2 = 8;
        } else if (this.isBluetoothKey) {
            mask1 = 32;
            mask2 = 16;
        } else {
            mask1 = 1;
            mask2 = 2;
        }
        this.charged = (chargeStatusByte & 0xFF & mask1) == 0 ? ((chargeStatusByte & 0xFF & mask2) == 0 ? 0 : 1) : -1;
    }

    private void isGM() {
        this.isGrandMaster = this.keyConfig[0] == 106;
    }

    private void calculateRealNumEvents() {
        int max = (this.keyConfig[15] & 0x20) > 0 ? 4000 : 1916;
        this.realNumEvents = this.numEvents > max ? max : this.numEvents;
    }

    private void calculateVoltage() {
        if (this.PID == 0) {
            return;
        }
        int voltageByte = 0;
        double battery = 0.0;
        if (this.PID < 108) {
            voltageByte = this.keyConfig[10];
            battery = (voltageByte & 0xF0) * 5000 / 512 + 1250;
        } else if (this.PID == 108) {
            voltageByte = this.keyConfig[10];
            if (voltageByte < 0) {
                voltageByte = 256 + voltageByte;
            }
            battery = 5000 * voltageByte / 255;
        } else if (this.PID == 109) {
            voltageByte = this.keyConfig[24];
            if (voltageByte < 0) {
                voltageByte = 256 + voltageByte;
            }
            battery = 5000 * voltageByte / 255;
        } else if (this.PID == 110 || this.PID == 113) {
            voltageByte = this.keyConfig[10];
            if (voltageByte < 0) {
                voltageByte = 256 + voltageByte;
            }
            battery = 6600 * voltageByte / 255;
        }
        if (voltageByte == 0) {
            this.voltage = "0.00";
        } else {
            this.millivolts = new Integer((int)battery).toString();
            this.voltage = this.millivolts.substring(0, 1) + "." + this.millivolts.substring(1, 3);
        }
        double lowBattery = 0.0;
        if (this.PID < 108 || this.PID == 109) {
            voltageByte = this.keyConfig[10];
            lowBattery = 5000.0 * ((double)(voltageByte & 0xF) / 32.0 + 0.25);
        } else if (this.PID == 108) {
            voltageByte = this.keyConfig[24];
            if (voltageByte < 0) {
                voltageByte = 256 + voltageByte;
            }
            lowBattery = 5000 * voltageByte / 255;
        } else if (this.PID == 110 || this.PID == 113) {
            voltageByte = this.keyConfig[24];
            if (voltageByte < 0) {
                voltageByte = 256 + voltageByte;
            }
            lowBattery = 6600 * voltageByte / 255;
        }
        Double d2 = new Double(lowBattery);
        lowBattery = d2.intValue();
        if (battery < lowBattery) {
            this.voltage = this.voltage + AppRenderer.instance.render("message.low.battery");
            this.isLowBattery = true;
        }
    }

    private void processPacketFour(byte[] packet4) {
        byte[] temp = new byte[4];
        for (int k = 0; k < 4; ++k) {
            temp[k] = packet4[k];
        }
        this.downloadFileID = Util.fourBEBytesToLong(temp);
        temp = new byte[]{packet4[4], packet4[5]};
        this.fileStartAddr = Util.twoBEBytesToInt(temp);
        temp[0] = packet4[6];
        temp[1] = packet4[7];
        this.fileBytesRemaining = Util.twoBEBytesToInt(temp);
        this.numberOfFiles = Util.ByteToShort(packet4[8]);
        this.numberOfDownloads = Util.ByteToShort(packet4[9]);
        this.currentFileIndex = Util.ByteToShort(packet4[10]);
        this.currentFileOPMode = Util.ByteToShort(packet4[11]);
        temp[0] = packet4[12];
        temp[1] = packet4[13];
        this.fileCRC = Util.twoBEBytesToInt(temp);
    }

    public String getStringType() {
        String keyType2;
        switch (this.PID) {
            case 105: {
                keyType2 = "IR6";
                break;
            }
            case 106: {
                if ((this.keyIDBytes[1] & 0x80) > 0) {
                    return "Invalid GrandMaster Key";
                }
                return "GrandMaster Key";
            }
            case 108: {
                keyType2 = "Stealth";
                break;
            }
            case 109: {
                keyType2 = "IR7";
                break;
            }
            case 110: {
                keyType2 = "Bluetooth";
                break;
            }
            case 113: {
                keyType2 = "USB";
                break;
            }
            default: {
                return "Unknown Key Type";
            }
        }
        if (this.isConfigureKey) {
            return keyType2 + " Configure Key";
        }
        if (this.isProgrammer) {
            return keyType2 + " Programmer Key";
        }
        return keyType2 + " Standard Key";
    }

    public void printSingleKeyCabinetInfo() {
        System.out.println("status bytes:");
        Util.printHexBytes(this.rawData);
        System.out.println("");
        System.out.println("cabinet id:   " + this.linkID);
        System.out.println("RFIDFirmware: " + this.RFIDFirmware);
        if (this.isRFIDCardPresent) {
            System.out.println("card type:    " + this.RFIDCardType);
            System.out.println("last read:    " + this.timeSinceCardLastRead + " seconds ago");
            System.out.println("RFCardID:     " + this.RFCardID);
        } else {
            System.out.println("no card present");
        }
        if (this.doorOpen) {
            System.out.println("door has been open for   " + this.timeSinceDoorStatusChange + " seconds");
        } else {
            System.out.println("door has been closed for " + this.timeSinceDoorStatusChange + " seconds");
        }
    }

    public void printStatus() {
        System.out.println("***** Status Info: *****");
        System.out.println("PID                 = " + this.PID);
        System.out.println("SWV                 = " + this.SWV);
        System.out.println("HWV                 = " + this.HWV);
        System.out.println("keyID               = " + this.keyID);
        System.out.println("linkID             = " + this.linkID);
        System.out.println("keyTime             = " + this.keyTime);
        System.out.println("Index               = " + this.Index);
        System.out.println("Offset              = " + this.Offset);
        System.out.println("keyType             = " + this.keyType);
        System.out.println("currentKeySettingID = " + this.currentKeySettingID);
        System.out.println("number of events    = " + this.numEvents);
        System.out.println("event start address = " + this.eventAddr);
        System.out.println("downloadStatus      = " + this.downloadStatus);
        System.out.println("fileStartAddr       = " + this.fileStartAddr);
        System.out.println("fileBytesRemaining  = " + this.fileBytesRemaining);
        System.out.println("numberOfFiles       = " + this.numberOfFiles);
        System.out.println("numberOfDownloads   = " + this.numberOfDownloads);
        System.out.println("currentFileIndex    = " + this.currentFileIndex);
        System.out.println("currentFileOPMode   = " + this.currentFileOPMode);
        System.out.println("downloadFileID      = " + this.downloadFileID);
        System.out.println("fileCRC             = " + this.fileCRC);
        System.out.println("voltage             = " + this.voltage);
        System.out.print("KeyConfig-> ");
        Util.printHexBytes(this.keyConfig);
    }
}

