/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AbortFlag;
import cyberlink.CyberLink;
import cyberlink.EncoderException;
import cyberlink.FileManager;
import cyberlink.KeyStatus;
import cyberlink.SingleKeyCabinet;
import cyberlink.Util;
import cyberlink.WorkerThread;

public class KeySessionHandler {
    private static FileManager fileManager;
    private String keySerial;
    private KeyStatus KS;
    private static AbortFlag flag;
    private WorkerThread wt;
    public int expectedEventTime;
    public static boolean needsWebConfig;
    public static boolean KeyStatusModeOn;
    private boolean lastDoorOpen = false;

    public KeySessionHandler(FileManager fileManager, AbortFlag flag, WorkerThread wt) {
        KeySessionHandler.fileManager = fileManager;
        this.keySerial = null;
        KeySessionHandler.flag = flag;
        this.expectedEventTime = Integer.MIN_VALUE;
        this.wt = wt;
    }

    public FileManager getFileManager() {
        return fileManager;
    }

    public KeyStatus connectToKey() throws Exception {
        while (true) {
            this.wt.flag.check();
            if (!SingleKeyCabinet.pauseReadStatus) {
                short status;
                this.KS = fileManager.readStatus();
                if (this.KS.isVault) {
                    this.doDoorStatus(this.KS);
                }
                if ((status = this.KS.getDownloadStatus()) == 64) {
                    if (KeySessionHandler.flag.abort) {
                        throw new InterruptedException("aborted");
                    }
                    if (needsWebConfig) {
                        throw new EncoderException(EncoderException.ErrorCode.WEB_STATION_CONFIG_NEEDED);
                    }
                    if (KeyStatusModeOn) {
                        throw new EncoderException(EncoderException.ErrorCode.KEY_STATUS_MODE_ON);
                    }
                    Thread.sleep(500L);
                    continue;
                }
                if (!this.KS.validateFile()) {
                    if (KeySessionHandler.flag.abort) {
                        throw new InterruptedException("aborted");
                    }
                    Thread.sleep(500L);
                    continue;
                }
                String tempID = this.KS.getKeyID();
                if (this.keySerial == null) {
                    this.keySerial = tempID;
                } else if (!this.keySerial.equals(tempID)) {
                    throw new Exception("different key in session, aborting.");
                }
                this.expectedEventTime = Util.getVidexTime();
                return this.KS;
            }
            Thread.sleep(500L);
        }
    }

    private void doDoorStatus(KeyStatus KS) {
        if (this.lastDoorOpen != KS.doorOpen) {
            this.lastDoorOpen = KS.doorOpen;
            this.wt.setCurrentVariables(fileManager.getLinkID(), KS.getRawData());
        }
    }

    public KeyStatus connectToRFID() throws Exception {
        while (true) {
            this.wt.flag.check();
            this.KS = fileManager.readStatus();
            if (this.KS.isVault) {
                if (!this.KS.isRFIDCardPresent) continue;
                return this.KS;
            }
            if (KeySessionHandler.flag.abort) {
                throw new InterruptedException("aborted");
            }
            Thread.sleep(500L);
        }
    }

    public byte[] getStatusBytes() {
        return this.KS.getRawData();
    }

    public byte[] getkeyConfigBytes() {
        return this.KS.getkeyConfigBytes();
    }

    public byte[] getFileConfigBytes() {
        return this.KS.getFileConfigBytes();
    }

    public boolean isProgrammer() {
        return this.KS.isProgrammer;
    }

    public void deleteKeyConfig() {
        fileManager.deleteKeyConfig();
    }

    public void deleteFirmwareConfig() {
        fileManager.deleteFirmwareConfig();
    }

    public void readStatusFile() {
        try {
            fileManager.readStatus();
        }
        catch (EncoderException e2) {
            System.out.println(e2.toString());
        }
    }

    public boolean isKeyGone() throws Exception {
        KeyStatus ks = null;
        short downloadStatus = 0;
        while ((downloadStatus = (ks = fileManager.readStatus()).getDownloadStatus()) != 64) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!KeySessionHandler.flag.abort) continue;
        }
        if (!KeySessionHandler.flag.abort) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        throw new InterruptedException("aborted");
    }

    public boolean isKeyGoneAskOnce() throws Exception {
        KeyStatus ks = fileManager.readStatus();
        short downloadStatus = ks.getDownloadStatus();
        return downloadStatus == 64;
    }

    public static byte[] getEventFile() throws Exception {
        byte[] response;
        while (!fileManager.isDownloadFileReady(response = fileManager.readEventFile())) {
            if (response[48] == 64) {
                fileManager.abortLinkOperation();
                KeySessionHandler.flag.abort = true;
                break;
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!KeySessionHandler.flag.abort) continue;
        }
        return response;
    }

    public static byte[] getEventFileWithConfirmation(byte[] configBytesFromServer) throws Exception {
        byte[] response;
        while (!fileManager.isDownloadFileReady(response = fileManager.readEventFile())) {
            if (response[48] == 64) {
                fileManager.abortLinkOperation();
                KeySessionHandler.flag.abort = true;
                break;
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!KeySessionHandler.flag.abort) continue;
        }
        return fileManager.getEventFileWithConfirmation(response, configBytesFromServer);
    }

    public void sendKeyDisable() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 97;
        file[5] = 46;
        file[16] = -1;
        file[17] = -1;
        file[18] = -1;
        file[19] = -1;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public static void sendKeyReady() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 96;
        file[5] = 46;
        file[16] = -1;
        file[17] = -1;
        file[18] = -1;
        file[19] = -1;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public static void sendRefreshStatus() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 1;
        file[2] = 5;
        file[3] = 1;
        file[5] = 46;
        file[12] = 1;
        file[13] = 0;
        file[14] = 0;
        file[15] = 0;
        file[16] = -1;
        file[17] = -1;
        file[18] = -1;
        file[19] = -1;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public static int readBatteryByte() throws Exception {
        byte[] request = new byte[52];
        request[0] = 51;
        request[1] = 64;
        request[5] = 54;
        request[16] = -1;
        request[17] = -1;
        request[18] = -1;
        request[19] = -1;
        request[44] = 5;
        request[45] = 1;
        request[46] = 0;
        request[47] = 0;
        request[48] = 1;
        request[49] = 1;
        request[50] = 0;
        request[51] = 34;
        request = Util.makeCRC16(request, request.length);
        fileManager.writeConfigFile(request);
        Thread.sleep(CyberLink.fileTransferWait);
        byte[] bytes = KeySessionHandler.getEventFile();
        return bytes[85];
    }

    public void resetKey() throws Exception {
        byte[] request = new byte[52];
        request[0] = 51;
        request[1] = 64;
        request[2] = 0;
        request[3] = 0;
        request[5] = 52;
        request[16] = -1;
        request[17] = -1;
        request[18] = -1;
        request[19] = -1;
        request[44] = 4;
        request[45] = 2;
        request[46] = 0;
        request[47] = 24;
        request[48] = 0;
        request[49] = 0;
        request = Util.makeCRC16(request, request.length);
        fileManager.writeConfigFile(request);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public static KeyStatus getFreshStatusFile() throws Exception {
        byte[] request = new byte[52];
        request[0] = 51;
        request[1] = 64;
        request[5] = 54;
        request[16] = -1;
        request[17] = -1;
        request[18] = -1;
        request[19] = -1;
        request[44] = 5;
        request[45] = 1;
        request[46] = 0;
        request[47] = 0;
        request[48] = 1;
        request[49] = 1;
        request[50] = 0;
        request[51] = 34;
        request = Util.makeCRC16(request, request.length);
        fileManager.writeConfigFile(request);
        Thread.sleep(CyberLink.fileTransferWait);
        KeyStatus KS = fileManager.readStatus();
        return KS;
    }

    public static void sendChargeComplete() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 99;
        file[5] = 46;
        file[16] = -1;
        file[17] = -1;
        file[18] = -1;
        file[19] = -1;
        file[30] = 13;
        file[31] = 0;
        file[32] = 8;
        file[33] = 0;
        file[34] = -1;
        file[35] = -1;
        file[36] = 1;
        file[37] = 0;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public static void sendFreeUpLEDs() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 99;
        file[5] = 46;
        file[16] = -1;
        file[17] = -1;
        file[18] = -1;
        file[19] = -1;
        file[30] = 0;
        file[31] = 0;
        file[32] = 0;
        file[33] = 0;
        file[34] = 0;
        file[35] = 0;
        file[36] = 0;
        file[37] = 0;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public void getRFID_ID() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 127;
        file[5] = 46;
        file[12] = 105;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public void getCabinetDoorStatus() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 127;
        file[5] = 46;
        file[12] = 106;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public void makeMusic() throws Exception {
        byte[] file = new byte[66];
        file[0] = 51;
        file[1] = 127;
        file[5] = 62;
        file[12] = 107;
        file[13] = 3;
        file[44] = 1;
        file[45] = 0;
        file[46] = 9;
        file[47] = 0;
        file[48] = 2;
        file[49] = 2;
        file[50] = 9;
        file[51] = 2;
        file[52] = 0;
        file[53] = 18;
        file[54] = 9;
        file[55] = 2;
        file[56] = 2;
        file[57] = 2;
        file[58] = 0;
        file[59] = 18;
        file[60] = 9;
        file[61] = 2;
        file[62] = 2;
        file[63] = 2;
        file[64] = 9;
        file[65] = 2;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public byte[] getNetworkSettings() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 127;
        file[5] = 46;
        file[12] = 115;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
        return KeySessionHandler.getEventFile();
    }

    public byte[] getWSNetworkSettings() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 115;
        file[5] = 46;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
        return KeySessionHandler.getEventFile();
    }

    public void sendDemoModeOnCommand() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 127;
        file[5] = 46;
        file[12] = 107;
        file[13] = 33;
        file[30] = 2;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public void getRestartKeyHandling() throws Exception {
        byte[] file = new byte[44];
        file[0] = 51;
        file[1] = 127;
        file[5] = 46;
        file[12] = 107;
        file[13] = 13;
        byte[] ready = Util.makeCRC16(file, file.length);
        fileManager.writeConfigFile(ready);
        Thread.sleep(CyberLink.fileTransferWait);
    }

    public byte[] sendLocklistCommand(byte[] configBytes) throws Exception {
        int numberOfLocks = Math.min(this.KS.getNumLocks(), 4000);
        int sleepTime = numberOfLocks < 440 ? 4000 : numberOfLocks / 110 * 1000;
        fileManager.writeConfigFile(configBytes);
        Thread.sleep(sleepTime);
        this.expectedEventTime = Util.getVidexTime();
        return KeySessionHandler.getEventFile();
    }

    public byte[] sendEventRequestCommand(byte[] configBytes) throws Exception {
        fileManager.writeConfigFile(configBytes);
        Thread.sleep(4000L);
        return KeySessionHandler.getEventFile();
    }

    public byte[] sendKeyConfigGetEvents(byte[] configBytes) throws Exception {
        int sleepTime = configBytes.length < 4000 ? CyberLink.fileTransferWait : (int)((6.4E-4 * (double)configBytes.length + 3.0) * 1000.0);
        fileManager.writeConfigFile(configBytes);
        Thread.sleep(sleepTime);
        this.expectedEventTime = Util.getVidexTime();
        return KeySessionHandler.getEventFile();
    }

    public byte[] sendKeyConfigGetEvents(byte[] configBytes, byte[] configBytesFromServer) throws Exception {
        int sleepTime = configBytes.length < 4000 ? CyberLink.fileTransferWait : (int)((6.4E-4 * (double)configBytes.length + 3.0) * 1000.0);
        fileManager.writeConfigFile(configBytes);
        Thread.sleep(sleepTime);
        this.expectedEventTime = Util.getVidexTime();
        return KeySessionHandler.getEventFileWithConfirmation(configBytesFromServer);
    }

    public void sendKeyConfigOnly(byte[] configBytes) throws Exception {
        int sleepTime = configBytes.length < 4000 ? CyberLink.fileTransferWait : (int)((6.4E-4 * (double)configBytes.length + 3.0) * 1000.0);
        fileManager.writeConfigFile(configBytes);
        Thread.sleep(sleepTime);
        this.expectedEventTime = Util.getVidexTime();
    }

    static {
        needsWebConfig = false;
        KeyStatusModeOn = false;
    }
}

