/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AbortFlag;
import cyberlink.AppRenderer;
import cyberlink.CyberLink;
import cyberlink.EncoderException;
import cyberlink.KeySessionHandler;
import cyberlink.KeyStatus;
import cyberlink.LastCardInfo;
import cyberlink.MacRawDiskReader;
import cyberlink.Util;
import cyberlink.WorkerThread;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileSystemView;

public class FileManager {
    public boolean isMac;
    private MacRawDiskReader MRDR;
    private boolean ISUSBKEY;
    private FileSystemView view;
    private ArrayList<File> roots;
    private String linkID;
    private File cyberLinkKVT;
    private File cyberLinkKST;
    private File cyberLinkKCG;
    private File FirmwareKCG;
    private File scriptFile;
    private String userHomePath;
    private File linkFolder;
    private WorkerThread worker;
    private String macMountPt;

    public FileManager(WorkerThread wt) throws EncoderException {
        this.worker = wt;
        this.processFilePathsKVT();
        KeyStatus KS = this.readStatus();
        this.ISUSBKEY = KS.isUSBKey;
        this.linkID = KS.getLinkID();
        this.processFilePathsKCG(KS);
    }

    private void processFilePathsKVT() throws EncoderException {
        boolean waiting = true;
        while (waiting && !this.worker.flag.abort) {
            this.linkFolder = this.getLinkFolder();
            if (this.linkFolder == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            waiting = false;
        }
        this.cyberLinkKVT = new File(this.linkFolder, "CYBERKEY.KVT");
        this.cyberLinkKST = new File(this.linkFolder, "CYBERKEY.KST");
    }

    private void processFilePathsKCG(KeyStatus KS) {
        if (this.isMac) {
            if (KS.isUSBStation) {
                this.macMountPt = "//Volumes/USB STATION";
            } else if (KS.isWEBStation) {
                this.macMountPt = "//Volumes/WEB STATION";
            } else if (KS.isEncoder) {
                this.macMountPt = "//Volumes/IR ENCODER";
            } else if (KS.isVault) {
                this.macMountPt = "//Volumes/KEY VAULT1";
            } else if (KS.isCardReader) {
                this.macMountPt = "//Volumes/RFID READER";
            } else if (KS.isUSBKey) {
                File volume = new File("//Volumes/USBKey");
                if (volume.exists()) {
                    this.macMountPt = "//Volumes/USBKey";
                } else {
                    volume = new File("//Volumes/CyberKey");
                    if (volume.exists()) {
                        this.macMountPt = "//Volumes/CyberKey";
                    }
                }
            }
            assert (this.macMountPt != null);
            this.cyberLinkKCG = new File(this.macMountPt, "CYBERKEY.KCG");
            this.FirmwareKCG = new File(this.macMountPt, "Firmware.KCG");
        } else {
            this.cyberLinkKCG = new File(this.linkFolder, "CYBERKEY.KCG");
            this.FirmwareKCG = new File(this.linkFolder, "Firmware.KCG");
        }
    }

    public boolean isDevicePresent() throws IOException, InterruptedException {
        if (this.isMac) {
            return this.getMacMountPoint() != null;
        }
        return this.cyberLinkKST.exists() && this.cyberLinkKVT.exists();
    }

    private boolean doesUSBKeyVolumeExist() {
        String OS = System.getProperty("os.name");
        boolean doesExist = false;
        if (OS.indexOf("Mac") != -1) {
            File volume = new File("//Volumes/USBKey");
            doesExist = volume.exists() ? true : (volume = new File("//Volumes/CyberKey")).exists();
        } else if (OS.indexOf("Linux") != -1) {
            File volume = new File("//media/USBKey");
            doesExist = volume.exists() ? true : ((volume = new File("//mnt/USBKey")).exists() ? true : ((volume = new File("//media/CyberKey")).exists() ? true : (volume = new File("//mnt/CyberKey")).exists()));
        } else if (OS.indexOf("Windows") != -1) {
            File[] tempRoots;
            this.roots = new ArrayList();
            this.view = FileSystemView.getFileSystemView();
            for (File file : tempRoots = File.listRoots()) {
                if (this.view.isFloppyDrive(file)) continue;
                this.roots.add(file);
            }
            doesExist = false;
            for (File root : this.roots) {
                if (!root.equals(this.linkFolder)) continue;
                doesExist = true;
                break;
            }
        }
        return doesExist;
    }

    private File getLinkFolder() {
        this.isMac = false;
        String OS = System.getProperty("os.name");
        File volume = null;
        if (OS.indexOf("Mac") != -1) {
            this.isMac = true;
            volume = this.findOnMac();
        } else if (OS.indexOf("Linux") != -1) {
            volume = FileManager.findOnLinux();
        } else if (OS.indexOf("Windows") != -1) {
            volume = FileManager.findOnWindows();
        }
        return volume;
    }

    private static File findOnWindows() {
        FileSystemView view = FileSystemView.getFileSystemView();
        File[] volumes = File.listRoots();
        ArrayList<File> volumesToCheck = new ArrayList<File>(volumes.length);
        for (File volume : volumes) {
            if (view.isFloppyDrive(volume)) continue;
            if (view.getSystemDisplayName(volume).toUpperCase().indexOf("IR ENCODER") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("USB STATION") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("WEB STATION") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("KEY VAULT1") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("RFID READER") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("USBKEY") != -1 || view.getSystemDisplayName(volume).toUpperCase().indexOf("CyberKey") != -1) {
                if (!FileManager.isLinkVolume(volume)) continue;
                return volume;
            }
            volumesToCheck.add(volume);
        }
        Iterator itr = volumesToCheck.iterator();
        while (itr.hasNext()) {
            File volume = (File)itr.next();
            String description = null;
            try {
                description = view.getSystemTypeDescription(volume);
            }
            catch (NullPointerException ne) {
                // empty catch block
            }
            if (description == null || description.indexOf("Removable") == -1) continue;
            if (FileManager.isLinkVolume(volume)) {
                return volume;
            }
            itr.remove();
        }
        for (File volume : volumesToCheck) {
            if (!FileManager.isLinkVolume(volume)) continue;
            return volume;
        }
        return null;
    }

    private static boolean isLinkVolume(File volume) {
        return new File(volume, "CYBERKEY.KST").exists() && new File(volume, "CYBERKEY.KVT").exists();
    }

    private File findOnMac() {
        try {
            this.userHomePath = System.getProperty("user.home");
            this.scriptFile = new File(this.userHomePath, "findEncoder.sh");
            String path = this.getMacMountPoint();
            if (path == null) {
                return null;
            }
            File directory = new File(path);
            this.MRDR = new MacRawDiskReader(path);
            String command = "rm -f " + this.userHomePath + "/Desktop/CyberLink.jnlp";
            Process result = Runtime.getRuntime().exec(command);
            result.waitFor();
            command = "rm -f " + this.userHomePath + "/Downloads/CyberLink.jnlp";
            result = Runtime.getRuntime().exec(command);
            result.waitFor();
            this.scriptFile.delete();
            return directory;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String getMacMountPoint() throws IOException, InterruptedException {
        String returnVal = null;
        this.makeShellScriptAvailable();
        Process result = Runtime.getRuntime().exec(this.scriptFile.getAbsolutePath());
        result.waitFor();
        BufferedReader br = new BufferedReader(new InputStreamReader(result.getInputStream()));
        returnVal = br.readLine();
        if (returnVal == null) {
            br.close();
            throw new IOException();
        }
        br.close();
        String[] tokens = returnVal.split("/");
        if (tokens.length < 3) {
            return null;
        }
        return "/dev/r" + tokens[2];
    }

    private static File findOnLinux() {
        System.out.println();
        File directory = new File("//media/IR ENCODER");
        if (!directory.exists()) {
            directory = new File("//mnt/IR ENCODER");
        }
        if (!directory.exists()) {
            directory = new File("//media/USB STATION");
        }
        if (!directory.exists()) {
            directory = new File("//media/daveh/USB STATION");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/USB STATION");
        }
        if (!directory.exists()) {
            directory = new File("//media/WEB STATION");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/WEB STATION");
        }
        if (!directory.exists()) {
            directory = new File("//media/KEY VAULT1");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/KEY VAULT1");
        }
        if (!directory.exists()) {
            directory = new File("//media/RFID READER");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/RFID READER");
        }
        if (!directory.exists()) {
            directory = new File("//media/USBKey");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/USBKey");
        }
        if (!directory.exists()) {
            directory = new File("//media/CyberKey");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/CyberKey");
        }
        if (!directory.exists()) {
            directory = new File("//media/IR_ENCODER");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/IR_ENCODER");
        }
        if (!directory.exists()) {
            directory = new File("//media/USB_STATION");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/USB_STATION");
        }
        if (!directory.exists()) {
            directory = new File("//media/WEB_STATION");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/WEB_STATION");
        }
        if (!directory.exists()) {
            directory = new File("//media/KEY_VAULT1");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/KEY_VAULT1");
        }
        if (!directory.exists()) {
            directory = new File("//media/RFID_READER");
        }
        if (!directory.exists()) {
            directory = new File("//mnt/RFID_READER");
        }
        if (directory.exists()) {
            return directory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStatus readStatus() throws EncoderException {
        try {
            byte[] b2 = this.readBinaryFileFromDisk(this.cyberLinkKST);
            KeyStatus KS = new KeyStatus(b2);
            if (KS.isVault && CyberLink.cardScanningMode.booleanValue() || KS.isCardReader) {
                this.worker.uiHandler.postOperation(AppRenderer.instance.render("status.cardreader.message.ready"));
            } else if (KeySessionHandler.KeyStatusModeOn) {
                this.worker.uiHandler.postOperation(AppRenderer.instance.render("status.message.current.status.mode"));
            } else if (!this.worker.startingOver) {
                // empty if block
            }
            if (KS.isVault) {
                if (CyberLink.cardScanningMode.booleanValue()) {
                    this.worker.uiHandler.postStatus(AppRenderer.instance.render("status.cardreader.presentcard"));
                } else if (CyberLink.needsDedicatedKeyForVault) {
                    this.worker.uiHandler.postStatus(AppRenderer.instance.render("status.vault.presentDedicatedkey"));
                } else {
                    this.worker.uiHandler.postStatus(AppRenderer.instance.render("status.vault.generic.message"));
                }
            } else if (KS.isCardReader) {
                this.worker.uiHandler.postStatus(AppRenderer.instance.render("status.cardreader.presentcard"));
            }
            this.worker.encoder.getFrameRef().setViewKeyInfoVisible(!KS.isCardReader && CyberLink.cardScanningMode == false);
            this.worker.encoder.getFrameRef().setViewCardInfoVisible(KS.isCardReader || CyberLink.cardScanningMode != false);
            if ((CyberLink.cardScanningMode.booleanValue() || KS.isCardReader) && KS.timeSinceCardLastRead >= 0 && KS.timeSinceCardLastRead <= 2 && KS.RFCardID != null) {
                try {
                    this.worker.webService.issueRFIdCard(KS.RFCardIDBytes);
                }
                catch (Exception e2) {
                    System.err.println("WARNING: issueCard.do failed: " + e2.toString());
                }
                StringSelection ss = new StringSelection(KS.RFCardID);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
                String OS = System.getProperty("os.name");
                if (OS.indexOf("Mac") != -1) {
                    String command = "tell application \"System Events\"\r\tkeystroke \"v\" using {command down}\r  keystroke return\rend tell";
                    String[] scriptArray = new String[]{"osascript", "-e", command};
                    try {
                        Process result = Runtime.getRuntime().exec(scriptArray);
                        result.waitFor();
                    }
                    catch (Exception e3) {
                        System.out.println("error " + e3);
                    }
                } else if (OS.indexOf("Windows") != -1) {
                    File scriptFile = null;
                    try {
                        scriptFile = File.createTempFile("paste", ".wsf");
                        InputStream in = CyberLink.class.getResourceAsStream("paste.wsf");
                        if (in == null) {
                            System.out.println("can't read the script as resource stream");
                        }
                        byte[] b22 = new byte[1024];
                        int numRead = in.read(b22);
                        FileWriter fw = new FileWriter(scriptFile);
                        for (int k = 0; k < numRead; ++k) {
                            fw.write((char)b22[k]);
                        }
                        fw.close();
                        in.close();
                        Process result = Runtime.getRuntime().exec("cscript " + scriptFile.getAbsolutePath());
                        result.waitFor();
                    }
                    catch (Exception ioe) {
                        System.out.println("error " + ioe);
                    }
                    finally {
                        if (scriptFile != null) {
                            scriptFile.delete();
                        }
                    }
                }
                this.worker.uiHandler.postCardID(KS.RFCardID);
                this.worker.lastCardInfo = new LastCardInfo(KS);
                this.worker.sendCardData();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ioe) {
                    // empty catch block
                }
            }
            if (this.linkID != null && !KS.getLinkID().equals(this.linkID)) {
                throw new EncoderException(EncoderException.ErrorCode.WRONG_LINK);
            }
            return KS;
        }
        catch (FileNotFoundException fe) {
            fe.printStackTrace();
            this.worker.uiHandler.postOperation(AppRenderer.instance.render("status.message.settingup"));
            this.worker.uiHandler.postStatus("");
            throw new EncoderException(EncoderException.ErrorCode.LINK_NOT_FOUND);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new EncoderException(EncoderException.ErrorCode.STATUSFILE_NOT_FOUND);
        }
    }

    public void abortLinkOperation() throws EncoderException {
        byte[] dummyCommand = new byte[]{51, 1, 1, 0, 0, 46, 51, 46, 51, 1, -1, 51, 1, 46, -1, -1, -1, -1, -1, -1, 46, 51, 1, -1, 51, 1, 46, -1, 51, 1, 1, 0, 0, 46, 51, 46, 51, 1, -1, 51, 1, 46, -1, -1, 113, -86};
        this.writeBinaryFileToDisk(this.cyberLinkKCG, dummyCommand);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cyberLinkKCG.delete();
    }

    public String getLinkID() {
        return this.linkID;
    }

    public void deleteKeyConfig() {
        if (this.cyberLinkKCG.exists()) {
            this.cyberLinkKCG.delete();
        }
    }

    public void deleteEventFile() {
        if (this.cyberLinkKVT.exists()) {
            this.cyberLinkKVT.delete();
        }
    }

    public void deleteFirmwareConfig() {
        if (this.FirmwareKCG.exists()) {
            this.FirmwareKCG.delete();
        }
    }

    public byte[] readEventFile() throws EncoderException {
        int tries = 3;
        while (tries > 0) {
            this.worker.flag.check();
            try {
                return this.readBinaryFileFromDisk(this.cyberLinkKVT);
            }
            catch (IOException fe) {
                --tries;
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (tries != 0) continue;
                fe.printStackTrace();
            }
        }
        throw new EncoderException(EncoderException.ErrorCode.EVENTFILE_NOT_FOUND);
    }

    public boolean isDownloadFileReady(byte[] bytes) throws EncoderException {
        byte DStatus = bytes[48];
        if (this.isEncrypted(bytes)) {
            return true;
        }
        if (DStatus < 64 || DStatus >= 96) {
            return true;
        }
        if (DStatus == 66 || DStatus == 64) {
            return false;
        }
        if (DStatus == 65) {
            return true;
        }
        throw new EncoderException(EncoderException.ErrorCode.CONFIGFILE_PROBLEM, DStatus);
    }

    private boolean isEncrypted(byte[] bytes) {
        if (bytes[0] != 0) {
            return false;
        }
        for (int k = 1; k < 8; ++k) {
            if (bytes[k] == 0) continue;
            return true;
        }
        return false;
    }

    public void writeConfigFileOn81(String fileName, byte[] b2) throws EncoderException {
        try {
            String tmpFolder = System.getProperty("java.io.tmpdir");
            String folderPlusFile = tmpFolder + fileName;
            File f2 = new File(folderPlusFile);
            this.writeBinaryFileToDisk(f2, b2);
            String clientMountPt = this.linkFolder.getAbsolutePath();
            String command = "cmd.exe /c copy " + folderPlusFile + " " + clientMountPt;
            Process result = Runtime.getRuntime().exec(command);
            result.waitFor();
            f2.delete();
        }
        catch (Exception ioe) {
            throw new EncoderException(EncoderException.ErrorCode.CONFIGFILE_PROBLEM);
        }
    }

    public void writeConfigFile(byte[] b2) throws EncoderException {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        if (name.contains("Mac")) {
            this.writeBinaryFileToDisk(this.cyberLinkKCG, b2);
        } else {
            Float windows8;
            Float fl_version = Float.valueOf(Float.parseFloat(version));
            if (fl_version.compareTo(windows8 = new Float(6.2)) >= 0 || WorkerThread.USEWRITEFILEWORKAROUND) {
                this.writeConfigFileOn81("CYBERKEY.KCG", b2);
            } else {
                this.writeBinaryFileToDisk(this.cyberLinkKCG, b2);
            }
        }
    }

    public void writeFirmware(byte[] newFirmware) throws IOException, EncoderException {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        if (this.isMac) {
            this.MRDR.closeBuffStream();
            this.writeBinaryFileToDisk(new File(this.macMountPt, "Firmware.KCG"), newFirmware);
        } else {
            Float windows8;
            Float fl_version = Float.valueOf(Float.parseFloat(version));
            if (fl_version.compareTo(windows8 = new Float(6.2)) >= 0 || WorkerThread.USEWRITEFILEWORKAROUND) {
                this.writeConfigFileOn81("Firmware.KCG", newFirmware);
            } else {
                this.writeBinaryFileToDisk(new File(this.cyberLinkKST.getParentFile(), "Firmware.KCG"), newFirmware);
            }
        }
    }

    public static void redirectStream(InputStream in, OutputStream out, byte[] buf) throws IOException {
        while (true) {
            int nRead;
            if ((nRead = in.read(buf)) > 0) {
                out.write(buf, 0, nRead);
                continue;
            }
            if (nRead == -1) break;
        }
    }

    public byte[] getEventFileWithConfirmation(byte[] firstEvents, byte[] configBytesFromServer) throws IOException, EncoderException {
        if (this.isEventFileGood(firstEvents, configBytesFromServer)) {
            return firstEvents;
        }
        for (int k = 0; k < 2; ++k) {
            byte[] events = this.readBinaryFileFromDisk(this.cyberLinkKVT);
            if (this.isEventFileGood(events, configBytesFromServer)) {
                return events;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isEventFileGood(byte[] eventFile, byte[] configBytesFromServer) throws EncoderException {
        boolean isGood = false;
        byte[] config = new byte[4];
        int start = eventFile.length - 14;
        for (int k = 0; k < 4; ++k) {
            config[k] = eventFile[start + k];
        }
        int configIDFromEvents = Util.BEBytesToInt(config);
        if (configBytesFromServer == null) {
            if (configIDFromEvents == 255 || configIDFromEvents == 251 || configIDFromEvents == 249 || configIDFromEvents == 246 || configIDFromEvents == 0x1000000) {
                isGood = true;
            }
            if (configIDFromEvents == CyberLink.lastConfigID) {
                throw new EncoderException(EncoderException.ErrorCode.ALREADY_CONFIGURED);
            }
        } else {
            int configIDFromServerConfig = Util.BEBytesToInt(configBytesFromServer);
            if (configIDFromEvents == configIDFromServerConfig) {
                isGood = true;
            }
        }
        return isGood;
    }

    public byte[] getEventFileFromUSBKeyWithCable() throws IOException {
        byte[] events = null;
        for (int k = 0; k < 2; ++k) {
            events = this.readBinaryFileFromDisk(this.cyberLinkKVT);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            events = this.readBinaryFileFromDisk(this.cyberLinkKVT);
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBinaryFileFromDisk(File file) throws IOException {
        FileInputStream fis = null;
        try {
            if (this.isMac) {
                byte[] byArray = this.MRDR.getUSBMacFile(file.getName());
                return byArray;
            }
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 1024);
            ByteArrayOutputStream bbos = new ByteArrayOutputStream(1024);
            int val = bis.read();
            while (val != -1) {
                bbos.write(val);
                val = bis.read();
            }
            byte[] byArray = bbos.toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryFileToDisk(File fileName, byte[] b2) throws EncoderException {
        int tryNum = 0;
        while (tryNum < 3) {
            ++tryNum;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(fileName);
                fos.write(b2);
                if (this.ISUSBKEY) {
                    fos.flush();
                }
                return;
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (fos == null) continue;
                    fos.close();
                }
                catch (IOException ioe) {
                    System.out.println("error while closing config file: " + ioe.toString());
                }
            }
        }
        throw new EncoderException(EncoderException.ErrorCode.USB_WRITE_ERROR);
    }

    private void makeShellScriptAvailable() {
        try {
            InputStream in = CyberLink.class.getResourceAsStream("findEncoder.sh");
            if (in == null) {
                System.out.println("can't read the script as resource stream");
            }
            byte[] b2 = new byte[1024];
            int numRead = in.read(b2);
            FileWriter fw = new FileWriter(this.scriptFile);
            for (int k = 0; k < numRead; ++k) {
                fw.write((char)b2[k]);
            }
            fw.close();
            in.close();
            Process result = Runtime.getRuntime().exec("chmod 775 " + this.scriptFile.getAbsolutePath());
            result.waitFor();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void writeFirmwareUpgrade(byte[] newFirmware) throws EncoderException, IOException {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        if (this.isMac) {
            this.MRDR.closeBuffStream();
            this.writeBinaryFileToDisk(new File(this.macMountPt, "ENCODEFW.BIN"), newFirmware);
        } else {
            Float windows8;
            Float fl_version = Float.valueOf(Float.parseFloat(version));
            if (fl_version.compareTo(windows8 = new Float(6.2)) >= 0 || WorkerThread.USEWRITEFILEWORKAROUND) {
                this.writeConfigFileOn81("ENCODEFW.BIN", newFirmware);
            } else {
                this.writeBinaryFileToDisk(new File(this.cyberLinkKST.getParentFile(), "ENCODEFW.BIN"), newFirmware);
            }
        }
    }

    public void writeWEBStationFirmwareUpgrade(byte[] newFirmware) throws EncoderException, IOException {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        if (this.isMac) {
            this.MRDR.closeBuffStream();
            this.writeBinaryFileToDisk(new File(this.macMountPt, "WebStation.KCG"), newFirmware);
        } else {
            Float windows8;
            Float fl_version = Float.valueOf(Float.parseFloat(version));
            if (fl_version.compareTo(windows8 = new Float(6.2)) >= 0 || WorkerThread.USEWRITEFILEWORKAROUND) {
                this.writeConfigFileOn81("WebStation.KCG", newFirmware);
            } else {
                this.writeBinaryFileToDisk(new File(this.cyberLinkKST.getParentFile(), "WebStation.KCG"), newFirmware);
            }
        }
    }

    public void waitForAllKeysToLeave(AbortFlag flag) throws EncoderException, InterruptedException {
        int count = 0;
        while (!flag.abort) {
            KeyStatus KS = this.readStatus();
            count = KS.getDownloadStatus() == 64 ? ++count : 0;
            if (count == 4) {
                return;
            }
            Thread.sleep(250L);
        }
        throw new InterruptedException("aborted");
    }

    public void waitForChargingKeyToLeave(WorkerThread wt) throws Exception {
        KeyStatus KS = this.readStatus();
        int count = 0;
        int lastVoltageCheckValue = 0;
        long checkBatteryStartTime = System.currentTimeMillis();
        boolean firstTime = true;
        while (!wt.flag.abort) {
            if (this.ISUSBKEY && this.linkID.startsWith("Z")) {
                if (!this.doesUSBKeyVolumeExist()) {
                    wt.uiHandler.setBarColor(-1);
                    wt.uiHandler.updateProgressBar(0);
                    wt.uiHandler.postStatus("");
                    wt.uiHandler.postKeyname("");
                    wt.uiHandler.postVoltage("");
                    wt.uiHandler.postOperation(AppRenderer.instance.render("status.message.settingup"));
                    return;
                }
            } else {
                KS = this.readStatus();
                if (KS.getDownloadStatus() == 64 && ++count == 3) {
                    wt.uiHandler.setBarColor(-1);
                    wt.uiHandler.updateProgressBar(0);
                    wt.uiHandler.postStatus("");
                    wt.uiHandler.postKeyname("");
                    wt.uiHandler.postVoltage("");
                    wt.uiHandler.postOperation(AppRenderer.instance.render("status.message.settingup"));
                    KeySessionHandler.sendFreeUpLEDs();
                    return;
                }
            }
            System.gc();
            if (firstTime || System.currentTimeMillis() - checkBatteryStartTime > 120000L) {
                if (KS.isUSBKey && this.linkID.startsWith("Z")) {
                    KeySessionHandler.sendRefreshStatus();
                    KS = this.readStatus();
                } else {
                    KS = KeySessionHandler.getFreshStatusFile();
                }
                count = 0;
                firstTime = false;
                String voltageStr = KS.getVoltage();
                String milliStr = KS.getMillivolts();
                int currentMillivolts = Integer.parseInt(milliStr);
                wt.uiHandler.postVoltage(AppRenderer.instance.render("status.battery.voltage") + " " + voltageStr);
                int cs = this.getVoltageStatus(currentMillivolts);
                int charging = KS.chargeStatus();
                wt.uiHandler.setPRBarIndeterminate(false);
                wt.uiHandler.setPRBarMinMaxValue(0, 100);
                wt.uiHandler.setBarColor(cs);
                wt.uiHandler.updateProgressBar(cs);
                if (currentMillivolts != lastVoltageCheckValue) {
                    lastVoltageCheckValue = currentMillivolts;
                    wt.setCurrentVariables(KS.getLinkID(), KS.getRawData());
                }
                if (KS.isUSBKey && KS.getLinkID().startsWith("Z")) {
                    wt.uiHandler.postKeyname(AppRenderer.instance.render("status.usb.remove.key"));
                } else {
                    wt.uiHandler.postKeyname(AppRenderer.instance.render("charge.key.remove"));
                }
                if (charging == 0) {
                    if (cs < 100) {
                        wt.uiHandler.postStatus(AppRenderer.instance.render("status.key.charging"));
                    } else {
                        wt.uiHandler.postStatus(AppRenderer.instance.render("status.key.charged"));
                        if (!KS.isUSBKey || !KS.getLinkID().startsWith("Z")) {
                            KeySessionHandler.sendChargeComplete();
                        }
                    }
                } else {
                    wt.uiHandler.postStatus(AppRenderer.instance.render("status.key.charged"));
                }
                checkBatteryStartTime = System.currentTimeMillis();
            }
            Thread.sleep(500L);
        }
        throw new InterruptedException("aborted");
    }

    private int getVoltageStatus(int volts) {
        int batt = 0;
        if (volts > 3950) {
            batt = 100;
        } else if (volts >= 3800 && volts < 3950) {
            batt = 75;
        } else if (volts >= 3700 && volts < 3800) {
            batt = 50;
        } else if (volts >= 3500 && volts < 3700) {
            batt = 25;
        } else if (volts <= 3500) {
            batt = 0;
        }
        return batt;
    }
}

