/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] certificates, String RSA) {
        try {
            this.standardTrustManager.checkClientTrusted(certificates, "RSA");
        }
        catch (Exception e2) {
            System.out.println("error in checkClientTrusted: " + e2);
        }
    }

    public void checkServerTrusted(X509Certificate[] certificates, String RSA) {
        if (certificates != null && LOG.isDebugEnabled()) {
            LOG.debug("Server certificate chain:");
            for (int i2 = 0; i2 < certificates.length; ++i2) {
                LOG.debug("X509Certificate[" + i2 + "]=" + certificates[i2]);
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate certificate = certificates[0];
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e2) {
                LOG.error(e2.toString());
            }
        } else {
            try {
                this.standardTrustManager.checkServerTrusted(certificates, "RSA");
            }
            catch (Exception e3) {
                System.out.println("error in checkServerTrusted: " + e3);
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

