/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.ConfigInfo;
import cyberlink.CyberLink;
import cyberlink.EasySSLProtocolSocketFactory;
import cyberlink.KeyStatus;
import cyberlink.LastCardInfo;
import cyberlink.ServerProperties;
import cyberlink.ServiceException;
import cyberlink.UIHandler;
import cyberlink.Util;
import cyberlink.WorkerThread;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyberLinkClient {
    private UIHandler uiHandler;
    private String cellNodeID;
    private String account;
    private String serverAddress;
    private HttpClient client;
    private boolean isSSL;

    public CyberLinkClient() {
    }

    public String getCurrentServerAddress() {
        return this.serverAddress;
    }

    public void setCurrentServerAddress(String addr) {
        this.serverAddress = addr;
    }

    public void closeIdleConnection() {
        this.client.getHttpConnectionManager().closeIdleConnections(0L);
    }

    public CyberLinkClient(UIHandler uiHandler, String linkID) {
        this.uiHandler = uiHandler;
        this.cellNodeID = linkID;
        this.account = CyberLink.account;
        try {
            String secProviderName = "com.sun.crypto.provider.SunJCE";
            Provider secProvider = (Provider)Class.forName(secProviderName).newInstance();
            Security.addProvider(secProvider);
        }
        catch (Exception e2) {
            uiHandler.postError(AppRenderer.instance.render("proxy.error.ssl") + " " + e2);
        }
        this.serverAddress = this.getServerAddress();
        if (this.isSSL) {
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
            Protocol.registerProtocol("https", easyhttps);
            this.client = new HttpClient();
        } else {
            this.client = new HttpClient();
        }
        if (this.isProxyRequired()) {
            HostConfiguration HConf = this.client.getHostConfiguration();
            HConf.setProxy(CyberLink.proxyHost, CyberLink.proxyPort);
            if (this.isCertRequired()) {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(CyberLink.proxyUserName, CyberLink.proxyPassword);
                this.client.getState().setProxyCredentials(new AuthScope(CyberLink.proxyHost, CyberLink.proxyPort, AuthScope.ANY_REALM), defaultcreds);
                this.client.getParams().setAuthenticationPreemptive(true);
            }
        }
    }

    private void setUserAgentHeader(PostMethod method) {
        int type = this.cellNodeID.startsWith("V") ? 1 : (this.cellNodeID.startsWith("Z") ? 6 : (this.cellNodeID.startsWith("v") ? 3 : 5));
        method.addRequestHeader(new Header("User-Agent", "cntype=" + type));
    }

    private List<Part> getCommonReqParts() {
        String IP = null;
        try {
            IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        parts.add(new StringPart("cellNodeID", this.cellNodeID));
        if (this.account != null) {
            parts.add(new StringPart("catalog", this.account));
        }
        if (IP != null) {
            parts.add(new StringPart("IPAddress", IP));
        }
        return parts;
    }

    private List<NameValuePair> getCommonReqParams() {
        String IP = null;
        try {
            IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        pairs.add(new NameValuePair("cellNodeID", this.cellNodeID));
        if (this.account != null) {
            pairs.add(new NameValuePair("catalog", this.account));
        }
        if (IP != null) {
            pairs.add(new NameValuePair("IPAddress", IP));
        }
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doPost(String command, Map<String, Object> params) throws IOException, Exception {
        PostMethod method = new PostMethod(this.serverAddress + command);
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        for (Map.Entry<String, Object> e2 : params.entrySet()) {
            String paramName = e2.getKey();
            Object value = e2.getValue();
            if (value == null) continue;
            if (value instanceof byte[]) {
                parts.add(new FilePart(paramName, new ByteArrayPartSource(paramName, (byte[])value)));
                continue;
            }
            parts.add(new StringPart(paramName, value.toString()));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), method.getParams()));
        try {
            byte[] byArray;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byArray = null;
                return byArray;
            }
            byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean issueKey(String issueNumber, byte[] status, String keySerial, byte[] GMInfo) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "issueKey.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        if (issueNumber != "-1") {
            parts.add(new StringPart("issueNumber", issueNumber));
        }
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        if (GMInfo != null) {
            parts.add(new FilePart("GMInfo", new ByteArrayPartSource("GMInfo", GMInfo)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                boolean bl = false;
                return bl;
            }
            boolean bl = method.getResponseBodyAsString().equals("1");
            return bl;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmStatus(byte[] status) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "checkLinkExists.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            CyberLink.needsDedicatedKeyForVault = false;
            if (method.getStatusCode() != 200) {
                if (method.getStatusCode() == 241) {
                    CyberLink.needsDedicatedKeyForVault = false;
                } else if (method.getStatusCode() == 242) {
                    CyberLink.needsDedicatedKeyForVault = true;
                } else {
                    this.throwError(method);
                }
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueStation(Integer issueNumber, byte[] status) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "issueStation.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("issueNumber", issueNumber.toString()));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueStation(String issuePassord, byte[] statusData) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "issueStation.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("issuePassword", issuePassord));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", statusData)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueRFIdCard(byte[] cardScanBytes) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "issueCard.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new FilePart("cardScanBytes", new ByteArrayPartSource("cardScanBytes", cardScanBytes)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueCellNode(String issuePassord, byte[] statusData) throws Exception {
        String hostName;
        PostMethod method = new PostMethod(this.serverAddress + "issue.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        KeyStatus KS = new KeyStatus(statusData);
        String type = "1";
        if (KS.isEncoder) {
            type = "1";
        } else if (KS.isStation) {
            type = "3";
        } else if (KS.isUSBKey) {
            type = "6";
        } else if (KS.isVault) {
            type = "5";
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            if (hostName == null || hostName.length() == 0) {
                hostName = System.getProperty("user.name");
            }
        }
        catch (UnknownHostException ex) {
            hostName = System.getProperty("user.name");
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("hostName", hostName));
        parts.add(new StringPart("issuePassword", issuePassord));
        parts.add(new StringPart("type", type));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", statusData)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueCellNode(Integer issueNumber, byte[] statusData) throws Exception {
        String hostName;
        PostMethod method = new PostMethod(this.serverAddress + "issue.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        KeyStatus KS = new KeyStatus(statusData);
        String type = "1";
        if (KS.isEncoder) {
            type = "1";
        } else if (KS.isStation) {
            type = "3";
        } else if (KS.isUSBKey) {
            type = "6";
        } else if (KS.isVault) {
            type = "5";
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            if (hostName == null || hostName.length() == 0) {
                hostName = System.getProperty("user.name");
            }
        }
        catch (UnknownHostException ex) {
            hostName = System.getProperty("user.name");
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("hostName", hostName));
        parts.add(new StringPart("issueNumber", issueNumber.toString()));
        parts.add(new StringPart("type", type));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", statusData)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] addCellnodeEvent(String keySerial, int event_type) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "addCellnodeEvent.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("keySerial", keySerial));
        params.add(new NameValuePair("event_type", new Integer(event_type).toString()));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getWebStationConfig(String stationID) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "getWebStationConfig.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("stationID", stationID));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendWebStationConfigConfirm(String stationID, byte[] eventFile) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "confirmWebStationConfig.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("stationID", stationID));
        parts.add(new FilePart("eventFile", new ByteArrayPartSource("eventFile", eventFile)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getEventRequest(String keySerial, byte[] status) throws Exception {
        String localServerAddress = CyberLinkClient.fixFirmwareUpgradeURLIfPresent(this.serverAddress);
        PostMethod method = new PostMethod(localServerAddress + "getEventRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new StringPart("USB", "USB"));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    public byte[] getSynchronizationCmd(String keySerial, byte[] events, byte[] lockListBytes, byte[] keyStatus, int expTime, int programmerCode) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keySerial", keySerial);
        params.put("requestTime", Util.getVidexTime());
        params.put("expectedTime", expTime);
        params.put("progCode", programmerCode);
        params.put("status", keyStatus);
        params.put("events", events);
        params.put("locklist", lockListBytes);
        return this.doPost("getSynchronizationCmd.do", params);
    }

    public void checkCanTouchKey(byte[] keyStatus) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("status", keyStatus);
        this.doPost("checkCanTouchKey.do", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGMFactoryConfig(String keySerial, byte[] status, byte[] GMInfo) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "getGMFactoryConfig.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        if (GMInfo != null) {
            parts.add(new FilePart("GMInfo", new ByteArrayPartSource("GMInfo", GMInfo)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] initializeKey(String keySerial, byte[] status, byte[] GMInfo) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "initializeKey.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        if (GMInfo != null) {
            parts.add(new FilePart("GMInfo", new ByteArrayPartSource("GMInfo", GMInfo)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProperties getServerProperties(int myEncoderFirmwareVer) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "getServerProperties.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        this.setUserAgentHeader(method);
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("myEncoderFirmwareVer", Integer.toString(myEncoderFirmwareVer)));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        try {
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(CyberLink.timeout * 1000);
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                ServerProperties serverProperties = null;
                return serverProperties;
            }
            Properties props = new Properties();
            props.load(new BufferedInputStream(method.getResponseBodyAsStream(), 1024));
            ServerProperties sp = new ServerProperties();
            String tmp = props.getProperty("productLevel");
            if (tmp == null) {
                tmp = props.getProperty("propertylevel");
            }
            sp.productLevel = Integer.parseInt(tmp);
            tmp = props.getProperty("encoderFirmwareVer");
            sp.encoderFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.encoderFWPath = props.getProperty("encoderFirmwarePath");
            tmp = props.getProperty("stationFirmwareVer");
            sp.stationFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.stationFWPath = props.getProperty("stationFirmwarePath");
            tmp = props.getProperty("webstationFirmwareVer");
            sp.webstationFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.webstationFWPath = props.getProperty("webstationFirmwarePath");
            tmp = props.getProperty("vaultWEBFirmwareVer");
            sp.vaultWEBFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.vaultWEBFWPath = props.getProperty("vaultWEBFirmwarePath");
            tmp = props.getProperty("vaultUSBFirmwareVer");
            sp.vaultUSBFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.vaultUSBFWPath = props.getProperty("vaultUSBFirmwarePath");
            tmp = props.getProperty("vaultRFIDFirmwareVer");
            sp.vaultRFIDFWVer = tmp != null ? Integer.parseInt(tmp) : 0;
            sp.vaultRFIDFWPath = props.getProperty("vaultRFIDFirmwarePath");
            tmp = props.getProperty("keyFirmware108Ver");
            sp.firmware_108 = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("keyFirmware109Ver");
            sp.firmware_109 = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("keyFirmware110Ver");
            sp.firmware_110 = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("keyFirmware113SWVer");
            sp.software_113 = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("keyFirmware113HWVer");
            sp.hardware_113 = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("allowKeyUpdating");
            sp.allowKeyUpdating = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("issueWithKey");
            sp.issueWithKey = tmp != null ? Integer.parseInt(tmp) : 0;
            tmp = props.getProperty("useCopyBypass");
            sp.useCopyBypass = tmp != null ? Integer.parseInt(tmp) : 0;
            ServerProperties serverProperties = sp;
            return serverProperties;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadCurrentEncoderFirmware(String path) throws Exception {
        String req = CyberLink.serverURL.getPath().endsWith("/") ? CyberLink.serverURL.toString() + path : CyberLink.serverURL.toString() + "/" + path;
        GetMethod method = new GetMethod(req);
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    public byte[] getKeyConfig2(byte[] keyStatus, int progCode, ConfigInfo extraInfo, String newPIN) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("progCode", progCode);
        params.put("status", keyStatus);
        params.put("newPIN", newPIN);
        byte[] incoming = this.doPost("getKeyConfig2.do", params);
        extraInfo.extractExtraInfo(incoming);
        WorkerThread.configBytesFromServer = extraInfo.getConfigIDBytes();
        return extraInfo.extractConfiguration(incoming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFirmware(int version, byte[] status, byte[] events, byte[] lockListData, boolean doLatestFirmware) throws Exception {
        String address = doLatestFirmware ? this.getFirmwareUpgradeServerAddress() : this.serverAddress;
        PostMethod method = new PostMethod(address + "getFirmware.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("version", Integer.toString(version)));
        if (!doLatestFirmware) {
            parts.add(new StringPart("manual", "true"));
        }
        parts.add(new FilePart("status", new ByteArrayPartSource("status", status)));
        parts.add(new FilePart("events", new ByteArrayPartSource("events", events)));
        if (lockListData != null) {
            parts.add(new FilePart("lockListData", new ByteArrayPartSource("lockListData", lockListData)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        this.uiHandler.postOperation(AppRenderer.instance.render("message.recharge.update"));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.recharge.getfirmware"));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getGMBytesRequestCommand(String keySerial) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "getGMBytesRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<NameValuePair> params = this.getCommonReqParams();
        params.add(new NameValuePair("keySerial", keySerial));
        method.setRequestBody(params.toArray(new NameValuePair[0]));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.master.config"));
        try {
            byte[] incoming;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = incoming = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLockListRequestCommand(String keySerial, byte[] status) throws Exception {
        String localServerAddress = CyberLinkClient.fixFirmwareUpgradeURLIfPresent(this.serverAddress);
        PostMethod method = new PostMethod(localServerAddress + "getLockListBytesRequest.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        this.uiHandler.postStatus(AppRenderer.instance.render("message.key.locklist"));
        try {
            byte[] incoming;
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = incoming = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getProgConfig(byte[] status, boolean doLatestFirmware) throws Exception {
        String address = doLatestFirmware ? this.getFirmwareUpgradeServerAddress() : this.serverAddress;
        PostMethod method = new PostMethod(address + "getProgConfig.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new FilePart("status", new ByteArrayPartSource("status", status)));
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveKeyEvents(byte[] eventData, byte[] lockListData, String keySerial) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "saveKeyEvents.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        parts.add(new StringPart("keySerial", keySerial));
        parts.add(new FilePart("eventData", new ByteArrayPartSource("eventData", eventData)));
        if (lockListData != null) {
            parts.add(new FilePart("lockListData", new ByteArrayPartSource("lockListData", lockListData)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            if (method.getStatusCode() != 200) {
                this.throwError(method);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendStatusReport(byte[] statusData) throws Exception {
        PostMethod method = new PostMethod(this.serverAddress + "sendStatusReport.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        String hostAddr = InetAddress.getLocalHost().getHostAddress();
        parts.add(new StringPart("IPAddress", hostAddr));
        if (statusData != null) {
            parts.add(new FilePart("statusData", new ByteArrayPartSource("statusData", statusData)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
            int status = method.getStatusCode();
            switch (status) {
                case 200: 
                case 240: 
                case 241: 
                case 242: {
                    int n = status;
                    return n;
                }
            }
            this.throwError(method);
            int n = 0;
            return n;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCardData(LastCardInfo info) throws IOException {
        PostMethod method = new PostMethod(this.serverAddress + "sendCardData.do");
        if (this.isCertRequired()) {
            method.setDoAuthentication(true);
        }
        List<Part> parts = this.getCommonReqParts();
        if (info != null) {
            parts.add(new FilePart("cardBytes", new ByteArrayPartSource("cardBytes", info.cardIDBytes)));
        }
        method.setRequestEntity(new MultipartRequestEntity(parts.toArray(new Part[0]), method.getParams()));
        try {
            this.client.executeMethod(method);
        }
        finally {
            method.releaseConnection();
        }
    }

    private void throwError(HttpMethod method) throws Exception {
        if (method.getStatusCode() == 555) {
            String txt = method.getResponseBodyAsString();
            BufferedReader reader = new BufferedReader(new StringReader(txt));
            String line = reader.readLine();
            if (line != null && line.equals("ERROR") && (line = reader.readLine()) != null) {
                try {
                    int code = Integer.parseInt(line);
                    reader.readLine();
                    String friendlyMessage = reader.readLine();
                    for (ServiceException.ErrorCode ec : EnumSet.allOf(ServiceException.ErrorCode.class)) {
                        if (ec.ordinal() != code) continue;
                        throw new ServiceException(ec, friendlyMessage);
                    }
                    throw new Exception("Unrecognized web service exception: #" + code);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            throw new Exception("Unrecognized web service exception response: " + txt);
        }
        if (method.getStatusCode() != 299) {
            Header contentType;
            if (method.getStatusCode() == 500 && (contentType = method.getResponseHeader("content-type")) != null && contentType.getValue().contains("text/html")) {
                String body = method.getResponseBodyAsString();
                Pattern pat = Pattern.compile("<pre>(.+)</pre>", 40);
                Matcher m = pat.matcher(body);
                if (m.find()) {
                    System.err.println(method.getStatusLine().toString());
                    System.err.println(m.group(1));
                    System.err.println();
                }
            }
            throw new Exception(method.getStatusLine().toString());
        }
    }

    private boolean isProxyRequired() {
        return CyberLink.proxyHost != null && CyberLink.proxyPort != 0;
    }

    private boolean isCertRequired() {
        return CyberLink.proxyUserName != null && CyberLink.proxyPassword != null;
    }

    private String getServerAddress() {
        String protocol = CyberLink.serverURL.getProtocol();
        this.isSSL = protocol.equals("https");
        String url = CyberLink.serverURL.toString();
        if (!url.endsWith("/")) {
            return url + "/services/cellnode/";
        }
        return url + "services/cellnode/";
    }

    private String getFirmwareUpgradeServerAddress() {
        String protocol = CyberLink.serverURL.getProtocol();
        this.isSSL = protocol.equals("https");
        String url = CyberLink.serverURL.toString();
        if (!url.endsWith("/")) {
            return url + "/FW_Upgrade/services/cellnode/";
        }
        return url + "FW_Upgrade/services/cellnode/";
    }

    public static String fixFirmwareUpgradeURLIfPresent(String url) {
        boolean doit = url.contains("/FW_Upgrade/");
        String retVal = url;
        if (doit) {
            String[] parts = url.split("FW_Upgrade/");
            retVal = parts[0] + parts[1];
        }
        return retVal;
    }
}

