/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.DesEncrypter;
import cyberlink.KeySessionHandler;
import cyberlink.Listener;
import cyberlink.MainFrame;
import cyberlink.StatusProcessor;
import cyberlink.UIHandler;
import cyberlink.Util;
import cyberlink.WorkerThread;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class CyberLink {
    boolean packFrame = false;
    public static WorkerThread wt;
    public StatusProcessor sp;
    private Listener listener;
    private UIHandler UIhandler;
    private String propertyFileName;
    private static String prefsFileName;
    public MainFrame frame;
    public static URL serverURL;
    public static String account;
    public static String proxyHost;
    public static int proxyPort;
    public static String proxyUserName;
    public static String proxyPassword;
    public static int timeout;
    public static Boolean cardScanningMode;
    public static boolean noPrompt;
    public static int fileTransferWait;
    public static long usbKeyCommId;
    public static int lastConfigID;
    public static boolean needsDedicatedKeyForVault;

    public static void connectionSettingsChanged() {
        if (wt != null) {
            CyberLink.wt.serverProps = null;
            wt.signalReset();
        }
    }

    public static void main(String[] args) {
        new AppRenderer();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                try {
                    new CyberLink();
                }
                catch (NullPointerException nex) {
                    nex.printStackTrace();
                }
            }
        });
    }

    public CyberLink() {
        while (this.connectToListener()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.listener = new Listener();
        this.listener.start();
        this.initDefaultSettings();
        this.readSettings();
        this.readPrefs();
        this.setProperties();
        this.setUpUserInterface();
        this.frame.showApp();
        this.UIhandler = new UIHandler(this.frame);
        this.UIhandler.postOperation(AppRenderer.instance.render("brief.title"));
        wt = new WorkerThread(this);
        this.frame.setWorkerThreadReference(wt);
        this.sp = new StatusProcessor(wt);
        wt.start();
        this.sp.start();
        if (noPrompt) {
            CyberLink.wt.NM.sendStartUp();
        }
    }

    public void showMacExitDialog() {
        JOptionPane.showMessageDialog(this.frame, AppRenderer.instance.render("update.mac.message"), AppRenderer.instance.render("update.mac.title"), 1);
    }

    private boolean connectToListener() {
        try {
            Socket socket = new Socket((String)null, 17926);
            socket.close();
        }
        catch (UnknownHostException u) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public UIHandler getUIHandler() {
        return this.UIhandler;
    }

    public MainFrame getFrameRef() {
        return this.frame;
    }

    public void shutdown() {
        KeySessionHandler.KeyStatusModeOn = false;
        if (this.sp != null) {
            this.sp.stopProcessing();
        }
        if (wt != null) {
            if (noPrompt) {
                CyberLink.wt.NM.sendShutdown();
            }
            wt.stopWorking();
            try {
                this.sp.join();
                wt.join();
            }
            catch (InterruptedException ie) {
                System.out.println("join for WorkerThread failed" + ie);
            }
        }
        this.writeSettings();
        CyberLink.writePrefs();
        this.listener.stopListener();
        if (this.connectToListener()) {
            try {
                this.listener.join();
            }
            catch (InterruptedException e2) {
                System.out.println("join for Listener failed" + e2);
            }
        }
        System.exit(0);
    }

    private void initDefaultSettings() {
        serverURL = null;
        account = null;
        proxyHost = null;
        proxyPort = 0;
        proxyUserName = null;
        proxyPassword = null;
        timeout = 5;
        noPrompt = false;
        fileTransferWait = 4000;
        String home = System.getProperty("user.home");
        this.propertyFileName = home + File.separator + "CyberIREncoder.properties";
        prefsFileName = home + File.separator + "CyberLink.prefs";
        cardScanningMode = new Boolean(false);
    }

    private void setProperties() {
        String url = System.getProperty("serverUrl");
        String localAccount = System.getProperty("accountName");
        String j_url = System.getProperty("jnlp.serverUrl");
        String j_localAccount = System.getProperty("jnlp.accountName");
        if (url != null) {
            try {
                serverURL = new URL(url.trim());
            }
            catch (MalformedURLException m) {}
        } else if (j_url != null) {
            try {
                serverURL = new URL(j_url.trim());
            }
            catch (MalformedURLException m) {
                // empty catch block
            }
        }
        if (localAccount != null) {
            account = localAccount;
        } else if (j_localAccount != null) {
            account = j_localAccount;
        }
        this.writeSettings();
    }

    private void readPrefs() {
        if (new File(prefsFileName).exists()) {
            try {
                FileInputStream in = new FileInputStream(prefsFileName);
                Properties prefs = new Properties();
                prefs.load(in);
                in.close();
                String tmp = prefs.getProperty("cyberlink.noprompt");
                noPrompt = tmp != null && tmp.length() > 0 ? tmp.trim().equals("1") || tmp.trim().toLowerCase().equals("true") : false;
                tmp = prefs.getProperty("cyberlink.filetransferwait");
                fileTransferWait = tmp != null && tmp.length() > 0 ? Integer.parseInt(tmp.trim()) : 4000;
                tmp = prefs.getProperty("cyberlink.usbkeycommid");
                usbKeyCommId = tmp != null && tmp.length() > 0 ? (long)Integer.parseInt(tmp.trim()) : 0L;
                tmp = prefs.getProperty("cyberlink.lastconfigid");
                lastConfigID = tmp != null && tmp.length() > 0 ? Integer.parseInt(tmp.trim()) : 0;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void writePrefs() {
        Properties prefs = new Properties();
        if (noPrompt) {
            prefs.put("cyberlink.noprompt", "true");
        } else {
            prefs.put("cyberlink.noprompt", "false");
        }
        prefs.put("cyberlink.filetransferwait", Integer.toString(fileTransferWait));
        prefs.put("cyberlink.usbkeycommid", Integer.toString((int)usbKeyCommId));
        prefs.put("cyberlink.lastconfigid", Integer.toString(lastConfigID));
        try {
            FileOutputStream out = new FileOutputStream(prefsFileName);
            prefs.store(out, "CyberLink Preferences");
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void readSettings() {
        if (new File(this.propertyFileName).exists()) {
            try {
                FileInputStream in = new FileInputStream(this.propertyFileName);
                Properties settings = new Properties();
                settings.load(in);
                in.close();
                String tmp = settings.getProperty("server.url");
                if (tmp != null && tmp.length() > 0) {
                    try {
                        serverURL = new URL(tmp.trim());
                    }
                    catch (MalformedURLException mex) {
                        // empty catch block
                    }
                }
                if ((tmp = settings.getProperty("server.account")) != null) {
                    if ((tmp = tmp.trim()).length() > 0) {
                        account = tmp;
                    }
                } else {
                    account = null;
                }
                if ((tmp = settings.getProperty("proxy.host")) != null && tmp.length() > 0) {
                    proxyHost = tmp.trim();
                }
                if ((tmp = settings.getProperty("proxy.port")) != null && tmp.length() > 0) {
                    proxyPort = Integer.parseInt(tmp.trim());
                }
                if ((tmp = settings.getProperty("proxy.username")) != null && tmp.length() > 0) {
                    proxyUserName = tmp.trim();
                }
                if ((tmp = settings.getProperty("proxy.pwd")) != null && tmp.length() > 0) {
                    proxyPassword = CyberLink.deMystify(tmp.trim());
                }
                if ((tmp = settings.getProperty("timeout")) != null && tmp.length() > 0) {
                    timeout = Integer.parseInt(tmp.trim());
                }
                cardScanningMode = false;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String Mystify(String s) {
        DesEncrypter encrypter = new DesEncrypter(Util.getKey());
        return encrypter.encrypt(s);
    }

    public static String deMystify(String s) {
        DesEncrypter encrypter = new DesEncrypter(Util.getKey());
        return encrypter.decrypt(s);
    }

    public void writeSettings() {
        Properties settings = new Properties();
        if (serverURL != null && serverURL.toString().length() > 0) {
            settings.put("server.url", serverURL.toString());
        }
        if (account != null) {
            settings.put("server.account", account);
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            settings.put("proxy.host", proxyHost);
        }
        if (proxyPort != 0) {
            settings.put("proxy.port", Integer.toString(proxyPort));
        }
        if (proxyUserName != null && proxyUserName.length() > 0) {
            settings.put("proxy.username", proxyUserName);
        }
        if (proxyPassword != null && proxyPassword.length() > 0) {
            settings.put("proxy.pwd", CyberLink.Mystify(proxyPassword));
        }
        if (timeout != 5) {
            settings.put("timeout", Integer.toString(timeout));
        }
        try {
            FileOutputStream out = new FileOutputStream(this.propertyFileName);
            settings.store(out, "CyberIREncoder Properties");
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void setUpUserInterface() {
        this.frame = new MainFrame(this);
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setVisible(true);
    }
}

