/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.AppRenderer;
import cyberlink.EncoderException;
import cyberlink.FileManager;
import cyberlink.KeySessionHandler;
import cyberlink.KeyStatus;
import cyberlink.MainFrame;
import cyberlink.UIHandler;
import cyberlink.WorkerThread;
import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CurrentKeyStatus {
    private FileManager FM;
    private KeyStatus KS;
    private WorkerThread WT;
    private UIHandler uiHandler;

    public CurrentKeyStatus(WorkerThread WT) {
        try {
            this.WT = WT;
            this.FM = WT.fileManager;
            if (this.FM == null) {
                this.FM = new FileManager(WT);
            }
            this.uiHandler = WT.uiHandler;
            this.processKey();
        }
        catch (Exception encx) {
            System.out.println(encx);
        }
    }

    private void processKey() throws EncoderException {
        while (KeySessionHandler.KeyStatusModeOn) {
            this.WT.flag.check();
            this.uiHandler.postOperation(AppRenderer.instance.render("status.message.current.status.mode"));
            this.uiHandler.postStatus(AppRenderer.instance.render("status.message.current.status"));
            this.KS = this.waitForKey();
            if (this.KS != null) {
                this.presentStatusReport();
                this.waitForKeyToLeave();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private KeyStatus waitForKey() throws EncoderException {
        KeyStatus ks = this.FM.readStatus();
        short downloadStatus = ks.getDownloadStatus();
        if (downloadStatus == 64) {
            return null;
        }
        return ks;
    }

    private void waitForKeyToLeave() throws EncoderException {
        this.uiHandler.postStatus(AppRenderer.instance.render("status.remove.key"));
        this.uiHandler.updateProgressBar(0);
        while (KeySessionHandler.KeyStatusModeOn) {
            this.WT.flag.check();
            KeyStatus ks = this.FM.readStatus();
            short downloadStatus = ks.getDownloadStatus();
            if (downloadStatus == 64) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void presentStatusReport() {
        String status = this.getCurrentStatus();
        JTextArea text = new JTextArea(status, 8, 40);
        text.setEditable(false);
        text.setForeground(Color.BLACK);
        MainFrame frame = this.WT.encoder.getFrameRef();
        ImageIcon image1 = new ImageIcon(MainFrame.class.getResource("about.png"));
        JOptionPane.showMessageDialog(frame, new JScrollPane(text), "Current Key Status", 1, new ImageIcon(image1.getImage()));
    }

    public String getCurrentStatus() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("Key ID: " + this.KS.getKeyID() + "\n");
            sb.append("Product ID: " + this.KS.getPID() + ", " + this.KS.getStringType() + "\n");
            sb.append("Software Version: " + this.KS.getSWV() + "\n");
        }
        catch (Exception encx) {
            System.out.println(encx);
        }
        return sb.toString();
    }
}

