/*
 * Decompiled with CFR 0.152.
 */
package cyberlink;

import cyberlink.Util;
import java.io.UnsupportedEncodingException;

public class ConfigInfo {
    private byte[] sizeBytes = new byte[4];
    private int size;
    private byte[] fileExpBytes = new byte[4];
    private int fileExpTime;
    private byte[] configIDBytes = new byte[4];
    private int configID;
    private byte[] numLockBytes = new byte[4];
    private int numLocks;
    private byte Recurring;
    private boolean Disabled;
    private byte[] PINBytes = new byte[20];
    private boolean pinFlag = false;
    private byte[] trimmedMessage;
    private byte[] incomingMessage;
    private String keyName;

    ConfigInfo() {
    }

    public void extractExtraInfo(byte[] message) {
        int k;
        this.incomingMessage = message;
        for (k = 0; k < 4; ++k) {
            this.sizeBytes[k] = message[k];
        }
        this.size = (int)Util.fourBEBytesToLong(this.sizeBytes);
        for (k = 4; k < 8; ++k) {
            this.fileExpBytes[k - 4] = message[k];
            this.fileExpTime = (int)Util.fourBEBytesToLong(this.fileExpBytes);
        }
        for (k = 8; k < 12; ++k) {
            this.configIDBytes[k - 8] = message[k];
            this.configID = (int)Util.fourBEBytesToLong(this.configIDBytes);
        }
        for (k = 12; k < 16; ++k) {
            this.numLockBytes[k - 12] = message[k];
            this.numLocks = (int)Util.fourBEBytesToLong(this.numLockBytes);
        }
        this.Recurring = message[16];
        this.Disabled = message[17] != 0;
        int nameSize = message[23];
        byte[] nameBytes = new byte[nameSize];
        for (int k2 = 0; k2 < nameSize; ++k2) {
            nameBytes[k2] = message[24 + k2];
        }
        try {
            this.keyName = new String(nameBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        if (message[this.size] == -1) {
            this.pinFlag = true;
            System.arraycopy(message, this.size + 1, this.PINBytes, 0, 20);
        } else {
            this.pinFlag = false;
            this.PINBytes = null;
        }
    }

    public byte[] extractConfiguration(byte[] incoming) {
        int length = incoming.length;
        int numBytes = this.pinFlag ? this.size + 21 : this.size;
        this.trimmedMessage = new byte[length - numBytes];
        for (int k = 0; k < this.trimmedMessage.length; ++k) {
            this.trimmedMessage[k] = incoming[k + numBytes];
        }
        return this.trimmedMessage;
    }

    public int getnumLocks() {
        return this.numLocks;
    }

    public int getFileExpireTime() {
        return this.fileExpTime;
    }

    public int configID() {
        return this.configID;
    }

    public byte[] getPINBytes() {
        return this.PINBytes;
    }

    public byte[] getConfigIDBytes() {
        return this.configIDBytes;
    }

    public boolean getDeletedFlag() {
        return this.Disabled;
    }

    public boolean pinRequired() {
        return this.pinFlag;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void printInfo() {
        System.out.println("\nincoming message-> ");
        Util.printHexBytes(this.incomingMessage);
        System.out.println("\ntrimmed message-> ");
        Util.printHexBytes(this.trimmedMessage);
        System.out.print("fileExpireBytes-> ");
        Util.printHexBytes(this.fileExpBytes);
        System.out.println("fileExpireTime-> " + this.fileExpTime);
        System.out.print("configIDBytes-> ");
        Util.printHexBytes(this.configIDBytes);
        System.out.println("configID-> " + this.configID);
        System.out.print("numLockBytes-> ");
        Util.printHexBytes(this.numLockBytes);
        System.out.println("numLocks-> " + this.numLocks);
        System.out.println("Recurring-> " + this.Recurring);
        System.out.println("Disabled-> " + this.Disabled);
        System.out.println("keyName-> " + this.keyName);
        if (this.pinFlag) {
            System.out.print("PINBytes-> ");
            Util.printHexBytes(this.PINBytes);
        } else {
            System.out.println("no PIN required");
        }
    }
}

