/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonControl;
import com.borland.jbcl.control.ButtonDescriptor;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ButtonDialog
extends JDialog
implements ActionListener,
KeyListener,
Serializable {
    public static final String NONE_COMMAND = "none";
    public static final String OK_COMMAND = "ok";
    public static final String YES_COMMAND = "yes";
    public static final String NO_COMMAND = "no";
    public static final String CANCEL_COMMAND = "cancel";
    public static final String DONE_COMMAND = "done";
    public static final String HELP_COMMAND = "help";
    public static final String APPLY_COMMAND = "apply";
    public static final String NEXT_COMMAND = "next";
    public static final String PREVIOUS_COMMAND = "previous";
    public static final String DETAILS_COMMAND = "details";
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 4;
    public static final int CANCEL = 8;
    public static final int DONE = 16;
    public static final int HELP = 32;
    public static final int APPLY = 64;
    public static final int NEXT = 128;
    public static final int PREVIOUS = 256;
    public static final int DETAILS = 512;
    public static final int OK_CANCEL = 9;
    public static final int YES_NO = 6;
    public static final int YES_NO_CANCEL = 14;
    public static final int OK_CANCEL_APPLY = 73;
    public static final int APPLY_DONE = 80;
    public static final int ALL = 1023;
    protected Container buttonPanel;
    protected transient ActionMulticaster actionMulticaster;
    protected int buttonSet;
    protected boolean centered = true;
    protected boolean enterOK = true;
    protected boolean escapeCancel = true;
    protected ButtonDescriptor[] buttonDescriptors;
    protected String[] labels;
    protected JPanel buttonPanelHolder;
    protected int buttonAlignment = 1;
    protected ButtonDescriptor result;
    protected Component centerPanel;
    protected Hashtable listeningTo = new Hashtable();

    protected static final ButtonDescriptor[] buttonSetToButtonDescriptors(int buttonSet) {
        Vector<ButtonDescriptor> descr = new Vector<ButtonDescriptor>();
        if ((buttonSet & 0x100) != 0) {
            descr.addElement(new ButtonDescriptor(PREVIOUS_COMMAND, Res._Previous, 256, false));
        }
        if ((buttonSet & 0x80) != 0) {
            descr.addElement(new ButtonDescriptor(NEXT_COMMAND, Res._NextButton, 128, false));
        }
        if ((buttonSet & 0x200) != 0) {
            descr.addElement(new ButtonDescriptor(DETAILS_COMMAND, Res._Details, 512, false));
        }
        if ((buttonSet & 1) != 0) {
            descr.addElement(new ButtonDescriptor(OK_COMMAND, Res._OK, 1, true));
        }
        if ((buttonSet & 2) != 0) {
            descr.addElement(new ButtonDescriptor(YES_COMMAND, Res._Yes1, 2, true));
        }
        if ((buttonSet & 4) != 0) {
            descr.addElement(new ButtonDescriptor(NO_COMMAND, Res._No1, 4, true));
        }
        if ((buttonSet & 8) != 0) {
            descr.addElement(new ButtonDescriptor(CANCEL_COMMAND, Res._Cancel1, 8, true));
        }
        if ((buttonSet & 0x10) != 0) {
            descr.addElement(new ButtonDescriptor(DONE_COMMAND, Res._Done, 16, true));
        }
        if ((buttonSet & 0x20) != 0) {
            descr.addElement(new ButtonDescriptor(HELP_COMMAND, Res._Help, 32, false));
        }
        if ((buttonSet & 0x40) != 0) {
            descr.addElement(new ButtonDescriptor(APPLY_COMMAND, Res._Apply, 64, false));
        }
        Object[] list = new ButtonDescriptor[descr.size()];
        descr.copyInto(list);
        return list;
    }

    protected ButtonDialog(Frame frame, String title, boolean modal, Component centerPanel, Container buttonPanel, ButtonDescriptor[] buttonDescriptors) {
        super(frame, title, modal);
        this.buttonPanel = buttonPanel;
        if (buttonPanel == null) {
            this.buttonPanelHolder = new JPanel();
            this.buttonPanelHolder.setLayout(new FlowLayout(1));
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridLayout(1, 0, 6, 0));
            this.buttonPanelHolder.add(this.buttonPanel);
        }
        if (centerPanel != null) {
            this.getContentPane().setLayout(new BorderLayout());
            this.setBackground(SystemColor.control);
            this.getContentPane().add(centerPanel, "Center");
            if (this.buttonPanelHolder != null) {
                this.getContentPane().add((Component)this.buttonPanelHolder, "South");
            } else {
                this.getContentPane().add((Component)this.buttonPanel, "South");
            }
        }
        this.buttonSet = -1;
        this.setButtonSet(buttonDescriptors);
        this.listenForKeys(this);
        this.enableEvents(64L);
        this.pack();
    }

    protected ButtonDialog(Frame frame, String title, Component centerPanel, int buttonSet) {
        this(frame, title, true, centerPanel, null, ButtonDialog.buttonSetToButtonDescriptors(buttonSet));
    }

    public ButtonDialog(Frame frame, String title, Component centerPanel) {
        this(frame, title, centerPanel, 1);
    }

    public Component getCenterPanel() {
        return this.centerPanel;
    }

    public void setCenterPanel(Component panel) {
        if (this.centerPanel != null) {
            this.dropKeyListeners(this);
        }
        this.centerPanel = panel;
        if (this.centerPanel != null) {
            this.getContentPane().setLayout(new BorderLayout());
            this.setBackground(SystemColor.control);
            this.getContentPane().add(this.centerPanel, "Center");
            if (this.buttonPanelHolder != null) {
                this.getContentPane().add((Component)this.buttonPanelHolder, "South");
            } else {
                this.getContentPane().add((Component)this.buttonPanel, "South");
            }
            this.listenForKeys(this);
            this.pack();
        }
    }

    protected ButtonDialog(Frame frame, String title) {
        this(frame, title, null, 1);
    }

    protected ButtonDialog(Frame frame) {
        this(frame, "", null, 1);
    }

    public void setButtonSet(int bs) {
        if ((bs & 0xFFFFFC00) != 0) {
            throw new IllegalArgumentException(Res.bundle.format(35, new String[]{Integer.toString(bs & 0xFFFFFC00)}));
        }
        if (bs != this.buttonSet) {
            this.buttonSet = bs;
            this.setButtonSet(ButtonDialog.buttonSetToButtonDescriptors(bs));
        }
    }

    private void setButtonSet(ButtonDescriptor[] buttonDescriptors) {
        int i2;
        if (this.buttonDescriptors != null) {
            for (i2 = 0; i2 < this.buttonDescriptors.length; ++i2) {
                this.buttonDescriptors[i2].button.removeActionListener(this);
            }
        }
        this.buttonDescriptors = buttonDescriptors;
        this.buttonPanel.removeAll();
        for (i2 = 0; i2 < buttonDescriptors.length; ++i2) {
            ButtonControl b2;
            buttonDescriptors[i2].button = b2 = new ButtonControl();
            b2.setActionCommand(buttonDescriptors[i2].command);
            b2.addActionListener(this);
            this.buttonPanel.add(b2);
        }
        this.setDefaultLabels();
        this.setupButtonLabels();
    }

    public int getButtonSet() {
        return this.buttonSet;
    }

    public void setCentered(boolean c2) {
        this.centered = c2;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setEnterOK(boolean e2) {
        this.enterOK = e2;
    }

    public boolean isEnterOK() {
        return this.enterOK;
    }

    public void setEscapeCancel(boolean c2) {
        this.escapeCancel = c2;
    }

    public boolean isEscapeCancel() {
        return this.escapeCancel;
    }

    public void setButtonAlignment(int alignment) {
        if (alignment == this.buttonAlignment || this.buttonPanelHolder == null) {
            return;
        }
        FlowLayout flow = (FlowLayout)this.buttonPanelHolder.getLayout();
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            throw new IllegalArgumentException();
        }
        flow.setAlignment(alignment);
        this.buttonAlignment = alignment;
        this.invalidate();
        this.repaint(100L);
    }

    public int getButtonAlignment() {
        return this.buttonAlignment;
    }

    public synchronized void addActionListener(ActionListener l) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(l);
        }
    }

    protected void processActionEvent(ActionEvent e2) {
        block4: {
            this.result = this.buttonFromCommand(e2.getActionCommand());
            if (this.actionMulticaster != null) {
                try {
                    this.actionMulticaster.dispatch(e2);
                }
                catch (Exception ex) {
                    if (this.result == null || !this.result.closeDialog) break block4;
                    return;
                }
            }
        }
        if (this.result != null && this.result.closeDialog || e2.getActionCommand().equals(CANCEL_COMMAND)) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void setLabels(String[] l) {
        if (l != null) {
            for (int i2 = 0; i2 < this.labels.length && i2 < l.length; ++i2) {
                this.labels[i2] = l[i2];
            }
        } else {
            this.setDefaultLabels();
        }
        this.setupButtonLabels();
    }

    private void setDefaultLabels() {
        this.labels = new String[this.buttonDescriptors.length];
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            this.labels[i2] = this.buttonDescriptors[i2].label;
        }
    }

    protected void setupButtonLabels() {
        if (this.labels.length == this.buttonDescriptors.length) {
            for (int i2 = 0; i2 < this.labels.length; ++i2) {
                this.buttonDescriptors[i2].button.setLabel(this.labels[i2]);
            }
        } else {
            for (int i3 = 0; i3 < this.buttonPanel.getComponentCount(); ++i3) {
                ((Button)this.buttonPanel.getComponent(i3)).setLabel(this.labels[i3]);
            }
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setResult(int id) {
        this.result = this.buttonFromID(id);
    }

    public int getResult() {
        return this.result != null ? this.result.getID() : 0;
    }

    public ButtonDescriptor buttonFromID(int id) {
        for (int i2 = 0; i2 < this.buttonDescriptors.length; ++i2) {
            if (this.buttonDescriptors[i2].id != id) continue;
            return this.buttonDescriptors[i2];
        }
        return null;
    }

    public ButtonDescriptor buttonFromCommand(String actionCommand) {
        for (int i2 = 0; i2 < this.buttonDescriptors.length; ++i2) {
            if (!this.buttonDescriptors[i2].command.equals(actionCommand)) continue;
            return this.buttonDescriptors[i2];
        }
        return null;
    }

    public void enableButton(String actionCommand, boolean enableState) {
        ButtonDescriptor bd = this.buttonFromCommand(actionCommand);
        if (bd != null) {
            bd.button.setEnabled(enableState);
        }
    }

    public void show() {
        this.result = null;
        if (this.centered) {
            this.centerOnScreen();
        } else {
            this.assureOnScreen();
        }
        super.show();
    }

    public void actionPerformed(ActionEvent e2) {
        this.processActionEvent(e2);
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        return ps;
    }

    protected void processWindowEvent(WindowEvent e2) {
        super.processWindowEvent(e2);
        if (e2.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, CANCEL_COMMAND));
        } else if (e2.getID() == 200 && this.getComponentCount() > 0) {
            this.getComponent(this.getComponentCount() - 1).transferFocus();
        }
    }

    protected void centerOnScreen() {
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension s = this.getSize();
        this.setLocation((d2.width - s.width) / 2, (d2.height - s.height) / 2);
    }

    protected void assureOnScreen() {
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle b2 = this.getBounds();
        if (b2 == null) {
            return;
        }
        if (b2.x + b2.width > d2.width || b2.y + b2.height > d2.height) {
            if (b2.x + b2.width > d2.width) {
                b2.x -= b2.x + b2.width - d2.width;
            }
            if (b2.y + b2.height > d2.height) {
                b2.y -= b2.y + b2.height - d2.height;
            }
            this.setLocation(b2.x, b2.y);
        }
    }

    protected void dropKeyListeners(Component comp) {
        Enumeration e2 = this.listeningTo.elements();
        while (e2.hasMoreElements()) {
            Component c2 = (Component)e2.nextElement();
            c2.removeKeyListener(this);
        }
        this.listeningTo = new Hashtable();
    }

    protected void listenForKeys(Component comp) {
        if (this.listeningTo.get(comp) == null) {
            comp.addKeyListener(this);
            this.listeningTo.put(comp, comp);
        }
        if (comp instanceof Container) {
            Container c2 = (Container)comp;
            int count = c2.getComponentCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.listenForKeys(c2.getComponent(i2));
            }
        }
    }

    public void dispose() {
        this.getContentPane().removeAll();
        if (this.centerPanel != null) {
            this.dropKeyListeners(this.centerPanel);
            this.centerPanel = null;
        }
        if (this.buttonDescriptors != null) {
            for (int i2 = 0; i2 < this.buttonDescriptors.length; ++i2) {
                this.buttonDescriptors[i2].button.removeActionListener(this);
            }
        }
        super.dispose();
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.isConsumed()) {
            return;
        }
        if (e2.getKeyCode() == 27 && this.escapeCancel && (e2.getModifiers() & (1 | 2 | 8)) == 0) {
            this.processActionEvent(new ActionEvent(e2.getSource(), 1001, CANCEL_COMMAND));
        } else if (e2.getKeyCode() == 10 && (e2.getModifiers() & (1 | 8)) == 0) {
            boolean needsCtrl;
            boolean isCtrl = (e2.getModifiers() & 2) != 0;
            boolean bl = needsCtrl = !this.enterOK || e2.getSource() instanceof TextArea;
            if (isCtrl == needsCtrl) {
                this.processActionEvent(new ActionEvent(e2.getSource(), 1001, OK_COMMAND));
            }
        } else if (e2.getKeyCode() == 112 && (e2.getModifiers() & (1 | 2 | 8)) == 0) {
            this.processActionEvent(new ActionEvent(e2.getSource(), 1001, HELP_COMMAND));
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    static {
        NONE_COMMAND = NONE_COMMAND;
        OK_COMMAND = OK_COMMAND;
        YES_COMMAND = YES_COMMAND;
        NO_COMMAND = NO_COMMAND;
        CANCEL_COMMAND = CANCEL_COMMAND;
        DONE_COMMAND = DONE_COMMAND;
        HELP_COMMAND = HELP_COMMAND;
        APPLY_COMMAND = APPLY_COMMAND;
        NEXT_COMMAND = NEXT_COMMAND;
        PREVIOUS_COMMAND = PREVIOUS_COMMAND;
        DETAILS_COMMAND = DETAILS_COMMAND;
        NONE = 0;
        OK = 1;
        YES = 2;
        NO = 4;
        CANCEL = 8;
        DONE = 16;
        HELP = 32;
        APPLY = 64;
        NEXT = 128;
        PREVIOUS = 256;
        DETAILS = 512;
        OK_CANCEL = 9;
        YES_NO = 6;
        YES_NO_CANCEL = 14;
        OK_CANCEL_APPLY = 73;
        APPLY_DONE = 80;
        ALL = 1023;
    }
}

